/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.http2.framing;

import java.nio.ByteOrder;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.http.impl.engine.http2.ByteFlag$;
import org.apache.pekko.http.impl.engine.http2.FrameEvent;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$Flags$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$CONTINUATION$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$DATA$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$GOAWAY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$HEADERS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PING$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PRIORITY$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$PUSH_PROMISE$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$RST_STREAM$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$SETTINGS$;
import org.apache.pekko.http.impl.engine.http2.Http2Protocol$FrameType$WINDOW_UPDATE$;
import org.apache.pekko.http.impl.engine.http2.framing.FrameRenderer;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;

@InternalApi
public final class FrameRenderer$ {
    public static final FrameRenderer$ MODULE$ = new FrameRenderer$();
    private static final ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public ByteOrder byteOrder() {
        return byteOrder;
    }

    /*
     * WARNING - void declaration
     */
    public ByteString render(FrameEvent frame) {
        if (frame instanceof FrameEvent.GoAwayFrame) {
            void apply_streamId;
            void apply_flags;
            void apply_tpe;
            FrameEvent.GoAwayFrame goAwayFrame = (FrameEvent.GoAwayFrame)frame;
            int lastStreamId = goAwayFrame.lastStreamId();
            Http2Protocol.ErrorCode errorCode = goAwayFrame.errorCode();
            ByteString debug = goAwayFrame.debug();
            boolean bl = false;
            int n = Http2Protocol$Flags$.MODULE$.NO_FLAGS();
            Http2Protocol$FrameType$GOAWAY$ http2Protocol$FrameType$GOAWAY$ = Http2Protocol$FrameType$GOAWAY$.MODULE$;
            int apply_payloadSize = 8 + debug.length();
            http2Protocol$FrameType$GOAWAY$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, (int)apply_streamId).putInt32(lastStreamId).putInt32(errorCode.id()).put(debug).build();
        }
        if (frame instanceof FrameEvent.DataFrame) {
            void apply_flags;
            void apply_tpe;
            FrameEvent.DataFrame dataFrame = (FrameEvent.DataFrame)frame;
            int streamId = dataFrame.streamId();
            boolean endStream = dataFrame.endStream();
            ByteString payload = dataFrame.payload();
            int n = ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream);
            Http2Protocol$FrameType$DATA$ http2Protocol$FrameType$DATA$ = Http2Protocol$FrameType$DATA$.MODULE$;
            int apply_payloadSize = payload.length();
            http2Protocol$FrameType$DATA$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, streamId).put(payload).build();
        }
        if (frame instanceof FrameEvent.HeadersFrame) {
            void apply_flags;
            void apply_tpe;
            FrameEvent.HeadersFrame headersFrame = (FrameEvent.HeadersFrame)frame;
            int streamId = headersFrame.streamId();
            boolean endStream = headersFrame.endStream();
            boolean endHeaders = headersFrame.endHeaders();
            ByteString headerBlockFragment = headersFrame.headerBlockFragment();
            Option<FrameEvent.PriorityFrame> prioInfo = headersFrame.priorityInfo();
            byte by = (byte)((byte)(ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_STREAM(), endStream) | ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders)) | ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.PRIORITY(), prioInfo.isDefined()));
            Http2Protocol$FrameType$HEADERS$ http2Protocol$FrameType$HEADERS$ = Http2Protocol$FrameType$HEADERS$.MODULE$;
            int apply_payloadSize = (prioInfo.isDefined() ? 5 : 0) + headerBlockFragment.length();
            http2Protocol$FrameType$HEADERS$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, streamId).putPriorityInfo(prioInfo).put(headerBlockFragment).build();
        }
        if (frame instanceof FrameEvent.WindowUpdateFrame) {
            void apply_flags;
            void apply_tpe;
            FrameEvent.WindowUpdateFrame windowUpdateFrame = (FrameEvent.WindowUpdateFrame)frame;
            int streamId = windowUpdateFrame.streamId();
            int windowSizeIncrement = windowUpdateFrame.windowSizeIncrement();
            int n = Http2Protocol$Flags$.MODULE$.NO_FLAGS();
            Http2Protocol$FrameType$WINDOW_UPDATE$ http2Protocol$FrameType$WINDOW_UPDATE$ = Http2Protocol$FrameType$WINDOW_UPDATE$.MODULE$;
            int apply_payloadSize = 4;
            http2Protocol$FrameType$WINDOW_UPDATE$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, streamId).putInt32(windowSizeIncrement).build();
        }
        if (frame instanceof FrameEvent.ContinuationFrame) {
            void apply_flags;
            void apply_tpe;
            FrameEvent.ContinuationFrame continuationFrame = (FrameEvent.ContinuationFrame)frame;
            int streamId = continuationFrame.streamId();
            boolean endHeaders = continuationFrame.endHeaders();
            ByteString payload = continuationFrame.payload();
            int n = ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders);
            Http2Protocol$FrameType$CONTINUATION$ http2Protocol$FrameType$CONTINUATION$ = Http2Protocol$FrameType$CONTINUATION$.MODULE$;
            int apply_payloadSize = payload.length();
            http2Protocol$FrameType$CONTINUATION$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, streamId).put(payload).build();
        }
        if (frame instanceof FrameEvent.SettingsFrame) {
            void apply_streamId;
            void apply_flags;
            void apply_tpe;
            Seq<FrameEvent.Setting> settings = ((FrameEvent.SettingsFrame)frame).settings();
            boolean bl = false;
            int n = Http2Protocol$Flags$.MODULE$.NO_FLAGS();
            Http2Protocol$FrameType$SETTINGS$ http2Protocol$FrameType$SETTINGS$ = Http2Protocol$FrameType$SETTINGS$.MODULE$;
            int apply_payloadSize = settings.length() * 6;
            http2Protocol$FrameType$SETTINGS$ = null;
            FrameRenderer.Frame b = new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, (int)apply_streamId);
            this.renderNext$1(settings, b);
            return b.build();
        }
        if (frame instanceof FrameEvent.SettingsAckFrame) {
            void apply_streamId;
            void apply_flags;
            void apply_tpe;
            boolean bl = false;
            int n = Http2Protocol$Flags$.MODULE$.ACK();
            Http2Protocol$FrameType$SETTINGS$ http2Protocol$FrameType$SETTINGS$ = Http2Protocol$FrameType$SETTINGS$.MODULE$;
            int apply_payloadSize = 0;
            http2Protocol$FrameType$SETTINGS$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, (int)apply_streamId).build();
        }
        if (frame instanceof FrameEvent.PingFrame) {
            void apply_streamId;
            void apply_flags;
            void apply_tpe;
            FrameEvent.PingFrame pingFrame = (FrameEvent.PingFrame)frame;
            boolean ack = pingFrame.ack();
            ByteString data = pingFrame.data();
            boolean bl = false;
            int n = ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.ACK(), ack);
            Http2Protocol$FrameType$PING$ http2Protocol$FrameType$PING$ = Http2Protocol$FrameType$PING$.MODULE$;
            int apply_payloadSize = data.length();
            http2Protocol$FrameType$PING$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, (int)apply_streamId).put(data).build();
        }
        if (frame instanceof FrameEvent.RstStreamFrame) {
            void apply_flags;
            void apply_tpe;
            FrameEvent.RstStreamFrame rstStreamFrame = (FrameEvent.RstStreamFrame)frame;
            int streamId = rstStreamFrame.streamId();
            Http2Protocol.ErrorCode errorCode = rstStreamFrame.errorCode();
            int n = Http2Protocol$Flags$.MODULE$.NO_FLAGS();
            Http2Protocol$FrameType$RST_STREAM$ http2Protocol$FrameType$RST_STREAM$ = Http2Protocol$FrameType$RST_STREAM$.MODULE$;
            int apply_payloadSize = 4;
            http2Protocol$FrameType$RST_STREAM$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, streamId).putInt32(errorCode.id()).build();
        }
        if (frame instanceof FrameEvent.PushPromiseFrame) {
            void apply_flags;
            void apply_tpe;
            FrameEvent.PushPromiseFrame pushPromiseFrame = (FrameEvent.PushPromiseFrame)frame;
            int streamId = pushPromiseFrame.streamId();
            boolean endHeaders = pushPromiseFrame.endHeaders();
            int promisedStreamId = pushPromiseFrame.promisedStreamId();
            ByteString headerBlockFragment = pushPromiseFrame.headerBlockFragment();
            int n = ByteFlag$.MODULE$.ifSet$extension(Http2Protocol$Flags$.MODULE$.END_HEADERS(), endHeaders);
            Http2Protocol$FrameType$PUSH_PROMISE$ http2Protocol$FrameType$PUSH_PROMISE$ = Http2Protocol$FrameType$PUSH_PROMISE$.MODULE$;
            int apply_payloadSize = 4 + headerBlockFragment.length();
            http2Protocol$FrameType$PUSH_PROMISE$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, streamId).putInt32(promisedStreamId).put(headerBlockFragment).build();
        }
        if (frame instanceof FrameEvent.PriorityFrame) {
            void apply_flags;
            void apply_tpe;
            FrameEvent.PriorityFrame priorityFrame = (FrameEvent.PriorityFrame)frame;
            int streamId = priorityFrame.streamId();
            int n = Http2Protocol$Flags$.MODULE$.NO_FLAGS();
            Http2Protocol$FrameType$PRIORITY$ http2Protocol$FrameType$PRIORITY$ = Http2Protocol$FrameType$PRIORITY$.MODULE$;
            int apply_payloadSize = 5;
            http2Protocol$FrameType$PRIORITY$ = null;
            return new FrameRenderer.Frame(apply_payloadSize, (Http2Protocol.FrameType)apply_tpe, (int)apply_flags, streamId).putPriorityInfo(priorityFrame).build();
        }
        throw new IllegalStateException(new StringBuilder(23).append("Unexpected frame type ").append(frame.frameTypeName()).append(".").toString());
    }

    public ByteString renderFrame(Http2Protocol.FrameType tpe, int flags, int streamId, ByteString payload) {
        int apply_payloadSize = payload.length();
        return new FrameRenderer.Frame(apply_payloadSize, tpe, flags, streamId).put(payload).build();
    }

    private final void renderNext$1(Seq remaining, FrameRenderer.Frame b$1) {
        Option option;
        while (remaining != null && !(option = package$.MODULE$.$plus$colon().unapply((SeqOps)remaining)).isEmpty()) {
            FrameEvent.Setting setting = (FrameEvent.Setting)((Tuple2)option.get())._1();
            Seq remaining2 = (Seq)((Tuple2)option.get())._2();
            if (setting == null) break;
            Http2Protocol.SettingIdentifier id = setting.identifier();
            int value = setting.value();
            b$1.putInt16(id.id());
            b$1.putInt32(value);
            remaining = remaining2;
        }
        if (Nil$.MODULE$.equals(remaining)) {
            return;
        }
        throw new MatchError((Object)remaining);
    }

    private FrameRenderer$() {
    }
}

