/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.MBeanServer;
import javax.management.ObjectName;

final class SecurityActions {
    private static void doPrivileged(PrivilegedExceptionAction<Void> action) throws Exception {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(action);
            } else {
                action.run();
            }
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    static void registerMBean(Object mbean, ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        SecurityActions.doPrivileged(() -> {
            mBeanServer.registerMBean(mbean, objectName);
            return null;
        });
    }

    static void unregisterMBean(ObjectName objectName, MBeanServer mBeanServer) throws Exception {
        SecurityActions.doPrivileged(() -> {
            mBeanServer.unregisterMBean(objectName);
            return null;
        });
    }

    private SecurityActions() {
    }
}

