/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class TeeServletOutputStream
extends ServletOutputStream {
    final ServletOutputStream underlyingStream;
    final ByteArrayOutputStream baosCopy;

    TeeServletOutputStream(ServletResponse httpServletResponse) throws IOException {
        this.underlyingStream = httpServletResponse.getOutputStream();
        this.baosCopy = new ByteArrayOutputStream();
    }

    byte[] getOutputStreamAsByteArray() {
        return this.baosCopy.toByteArray();
    }

    public void write(int val) throws IOException {
        if (this.underlyingStream != null) {
            this.underlyingStream.write(val);
            this.baosCopy.write(val);
        }
    }

    public void write(byte[] byteArray) throws IOException {
        if (this.underlyingStream == null) {
            return;
        }
        this.write(byteArray, 0, byteArray.length);
    }

    public void write(byte[] byteArray, int offset, int length) throws IOException {
        if (this.underlyingStream == null) {
            return;
        }
        this.underlyingStream.write(byteArray, offset, length);
        this.baosCopy.write(byteArray, offset, length);
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
        if (this.underlyingStream == null) {
            return;
        }
        this.underlyingStream.flush();
        this.baosCopy.flush();
    }

    public boolean isReady() {
        throw new RuntimeException("Not yet implemented");
    }

    public void setWriteListener(WriteListener listener) {
        throw new RuntimeException("Not yet implemented");
    }
}

