/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros;

import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.ext.macros.internal.MacroDefinitionRepository;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.ReferenceNode;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacroDefinitionBlock
extends Block
implements ReferenceNode<MacroDefinitionRepository, MacroDefinitionBlock, MacroReference> {
    private BasedSequence openingMarker = BasedSequence.NULL;
    private BasedSequence name = BasedSequence.NULL;
    private BasedSequence openingTrailing = BasedSequence.NULL;
    private BasedSequence closingMarker = BasedSequence.NULL;
    private BasedSequence closingTrailing = BasedSequence.NULL;
    private int ordinal = 0;
    private int firstReferenceOffset = Integer.MAX_VALUE;
    private int footnoteReferences = 0;
    private boolean inExpansion = false;

    public int getFootnoteReferences() {
        return this.footnoteReferences;
    }

    public void setFootnoteReferences(int footnoteReferences) {
        this.footnoteReferences = footnoteReferences;
    }

    public int getFirstReferenceOffset() {
        return this.firstReferenceOffset;
    }

    public void setFirstReferenceOffset(int firstReferenceOffset) {
        this.firstReferenceOffset = firstReferenceOffset;
    }

    public void addFirstReferenceOffset(int firstReferenceOffset) {
        if (this.firstReferenceOffset < firstReferenceOffset) {
            this.firstReferenceOffset = firstReferenceOffset;
        }
    }

    public boolean isReferenced() {
        return this.firstReferenceOffset < Integer.MAX_VALUE;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public boolean isInExpansion() {
        return this.inExpansion;
    }

    public void setInExpansion(boolean inExpansion) {
        this.inExpansion = inExpansion;
    }

    public void getAstExtra(@NotNull StringBuilder out) {
        MacroDefinitionBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.openingMarker, (String)"open");
        MacroDefinitionBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.name, (String)"name");
        MacroDefinitionBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.openingTrailing, (String)"openTrail");
        MacroDefinitionBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.closingMarker, (String)"close");
        MacroDefinitionBlock.segmentSpanChars((StringBuilder)out, (BasedSequence)this.closingTrailing, (String)"closeTrail");
    }

    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.name, this.openingTrailing, this.closingMarker, this.closingTrailing};
    }

    @Nullable
    public MacroReference getReferencingNode(@NotNull Node node) {
        return node instanceof MacroReference ? (MacroReference)node : null;
    }

    public int compareTo(MacroDefinitionBlock other) {
        return SequenceUtils.compare((CharSequence)this.name, (CharSequence)other.name, (boolean)true);
    }

    public MacroDefinitionBlock() {
    }

    public MacroDefinitionBlock(BasedSequence chars) {
        super(chars);
    }

    public MacroDefinitionBlock(BasedSequence chars, List<BasedSequence> segments) {
        super(chars, segments);
    }

    public MacroDefinitionBlock(BlockContent blockContent) {
        super(blockContent);
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getName() {
        return this.name;
    }

    public void setName(BasedSequence name) {
        this.name = name;
    }

    public BasedSequence getClosingMarker() {
        return this.closingMarker;
    }

    public void setClosingMarker(BasedSequence closingMarker) {
        this.closingMarker = closingMarker;
    }

    public BasedSequence getOpeningTrailing() {
        return this.openingTrailing;
    }

    public void setOpeningTrailing(BasedSequence openingTrailing) {
        this.openingTrailing = openingTrailing;
    }

    public BasedSequence getClosingTrailing() {
        return this.closingTrailing;
    }

    public void setClosingTrailing(BasedSequence closingTrailing) {
        this.closingTrailing = closingTrailing;
    }
}

