/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.support;

import java.time.Instant;
import java.util.Optional;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.vault.support.Versioned;

public class VaultRevisionMetadata
implements RevisionMetadata<Integer> {
    private final Versioned.Metadata metadata;

    public VaultRevisionMetadata(Versioned<?> versioned) {
        this(versioned.getRequiredMetadata());
    }

    public VaultRevisionMetadata(Versioned.Metadata metadata) {
        this.metadata = metadata;
    }

    public Optional<Integer> getRevisionNumber() {
        return Optional.of(this.metadata.getVersion().getVersion());
    }

    public Optional<Instant> getRevisionInstant() {
        return Optional.of(this.metadata.getCreatedAt());
    }

    public <T> T getDelegate() {
        return (T)this.metadata;
    }
}

