/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.function.Consumer;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.spi.DotIdentifierSequence;

public interface ModelPartContainer
extends ModelPart {
    public ModelPart findSubPart(String var1, EntityMappingType var2);

    default public void forEachSubPart(IndexedConsumer<ModelPart> consumer) {
        this.forEachSubPart(consumer, null);
    }

    public void forEachSubPart(IndexedConsumer<ModelPart> var1, EntityMappingType var2);

    public void visitSubParts(Consumer<ModelPart> var1, EntityMappingType var2);

    default public ModelPart findByPath(String path) {
        int dotIndex;
        int nextStart = 0;
        ModelPartContainer modelPartContainer = this;
        while ((dotIndex = path.indexOf(46, nextStart)) != -1) {
            modelPartContainer = (ModelPartContainer)modelPartContainer.findSubPart(path.substring(nextStart, dotIndex), null);
            nextStart = dotIndex + 1;
        }
        return modelPartContainer.findSubPart(path.substring(nextStart), null);
    }

    default public ModelPart findByPath(DotIdentifierSequence path) {
        DotIdentifierSequence endPart;
        ModelPartContainer modelPartContainer = this;
        if (path.getParent() != null) {
            DotIdentifierSequence[] parts = path.getParts();
            int end = parts.length - 1;
            for (int i = 0; i < end; ++i) {
                DotIdentifierSequence part = parts[i];
                modelPartContainer = (ModelPartContainer)modelPartContainer.findSubPart(part.getLocalName(), null);
            }
            endPart = parts[end];
        } else {
            endPart = path;
        }
        return modelPartContainer.findSubPart(endPart.getLocalName(), null);
    }
}

