/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.internal.impl;

import jakarta.persistence.criteria.JoinType;
import java.util.Map;
import org.hibernate.Incubating;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.Configuration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.internal.impl.AbstractAuditAssociationQuery;
import org.hibernate.envers.query.internal.impl.AuditQueryImplementor;

@Incubating
public class EntitiesAtRevisionAssociationQuery<Q extends AuditQueryImplementor>
extends AbstractAuditAssociationQuery<Q> {
    public EntitiesAtRevisionAssociationQuery(EnversService enversService, AuditReaderImplementor auditReader, Q parent, QueryBuilder queryBuilder, String propertyName, JoinType joinType, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String ownerAlias, String userSuppliedAlias, AuditCriterion onClauseCriterion) {
        super(enversService, auditReader, parent, queryBuilder, propertyName, joinType, aliasToEntityNameMap, aliasToComponentPropertyNameMap, ownerAlias, userSuppliedAlias, onClauseCriterion);
    }

    @Override
    protected AbstractAuditAssociationQuery<AbstractAuditAssociationQuery<Q>> createAssociationQuery(String associationName, JoinType joinType, String alias, AuditCriterion onClause) {
        return new EntitiesAtRevisionAssociationQuery<AbstractAuditAssociationQuery<Q>>(this.enversService, this.auditReader, this, this.queryBuilder, associationName, joinType, this.aliasToEntityNameMap, this.aliasToComponentPropertyNameMap, this.alias, alias, this.onClauseCriterion);
    }

    @Override
    protected Parameters createEntityJoin(Configuration configuration) {
        Parameters onClauseParameters = super.createEntityJoin(configuration);
        if (this.enversService.getEntitiesConfigurations().isVersioned(this.entityName)) {
            String originalIdPropertyName = configuration.getOriginalIdPropertyName();
            String revisionPropertyPath = configuration.getRevisionNumberPath();
            Parameters parametersToUse = this.parameters;
            if (this.joinType == JoinType.LEFT) {
                parametersToUse = this.parameters.addSubParameters("or");
                parametersToUse.addNullRestriction(revisionPropertyPath, true);
                parametersToUse = parametersToUse.addSubParameters("and");
            }
            MiddleIdData referencedIdData = new MiddleIdData(configuration, this.enversService.getEntitiesConfigurations().get(this.entityName).getIdMappingData(), null, this.entityName, true);
            this.enversService.getAuditStrategy().addEntityAtRevisionRestriction(configuration, this.queryBuilder, parametersToUse, revisionPropertyPath, configuration.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, this.alias, this.queryBuilder.generateAlias(), true);
        }
        return onClauseParameters;
    }
}

