/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmDiscriminatorSubclassEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.envers.boot.model.Attribute;
import org.hibernate.envers.boot.model.Join;
import org.hibernate.envers.boot.model.JoinAwarePersistentEntity;
import org.hibernate.envers.boot.model.SubclassPersistentEntity;
import org.hibernate.envers.configuration.internal.metadata.AuditTableData;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.mapping.PersistentClass;

public class DiscriminatorPersistentEntity
extends SubclassPersistentEntity
implements JoinAwarePersistentEntity {
    private final List<Join> joins;
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private String discriminatorValue;

    public DiscriminatorPersistentEntity(AuditTableData auditTableData, PersistentClass persistentClass) {
        super(auditTableData, persistentClass);
        this.joins = new ArrayList<Join>();
    }

    @Override
    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Override
    public boolean isJoinAware() {
        return true;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    @Override
    public List<Join> getJoins() {
        return Collections.unmodifiableList(this.joins);
    }

    @Override
    public void addJoin(Join join) {
        this.joins.add(join);
    }

    @Override
    public void build(JaxbHbmHibernateMapping mapping) {
        mapping.getSubclass().add(this.buildJaxbMapping());
    }

    public JaxbHbmDiscriminatorSubclassEntityType buildJaxbMapping() {
        JaxbHbmDiscriminatorSubclassEntityType entity = new JaxbHbmDiscriminatorSubclassEntityType();
        entity.setExtends(this.getExtends());
        if (this.getPersistentClass() != null) {
            entity.setAbstract(this.getPersistentClass().isAbstract());
        }
        if (!StringTools.isEmpty(this.getAuditTableData().getAuditEntityName())) {
            entity.setEntityName(this.getAuditTableData().getAuditEntityName());
        }
        for (Attribute attribute : this.attributes) {
            entity.getAttributes().add((Serializable)attribute.build());
        }
        if (!StringTools.isEmpty(this.discriminatorValue)) {
            entity.setDiscriminatorValue(this.discriminatorValue);
        }
        for (Join join : this.joins) {
            entity.getJoin().add(join.build());
        }
        return entity;
    }
}

