/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.json;

import com.xebialabs.deployit.core.rest.json.ReaderPostProcessor;
import com.xebialabs.deployit.core.xml.PasswordEncryptingCiConverter;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.ControlJsonConverter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ControlJsonMessageBodyReaderWriter
implements MessageBodyReader<Control>,
MessageBodyWriter<Control> {
    private final ReaderPostProcessor postProcessor;

    @Autowired
    public ControlJsonMessageBodyReaderWriter(ReaderPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Control.class.isAssignableFrom(type);
    }

    public Control readFrom(Class<Control> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String json = IOUtils.toString((InputStream)entityStream, (Charset)StandardCharsets.UTF_8);
        return this.postProcessor.apply(context -> {
            PasswordEncryptingCiConverter converter = new PasswordEncryptingCiConverter();
            context.register((ConfigurationItemConverter)converter);
            return new ControlJsonConverter((ConfigurationItemConverter)converter).toControl(json);
        });
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Control.class.isAssignableFrom(type);
    }

    public long getSize(Control control, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Control control, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String json = new ControlJsonConverter((ConfigurationItemConverter)new PasswordEncryptingCiConverter()).toJson(control);
        entityStream.write(json.getBytes(StandardCharsets.UTF_8));
    }
}

