/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.paging.PageTransactionInfo;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.files.FileStoreMonitor;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;

public interface PagingManager
extends ActiveMQComponent,
HierarchicalRepositoryChangeListener {
    public PagingStore getPageStore(SimpleString var1) throws Exception;

    public void addTransaction(PageTransactionInfo var1);

    public PageTransactionInfo getTransaction(long var1);

    public void removeTransaction(long var1);

    public Map<Long, PageTransactionInfo> getTransactions();

    public void reloadStores() throws Exception;

    public SimpleString[] getStoreNames();

    public void deletePageStore(SimpleString var1) throws Exception;

    public void processReload() throws Exception;

    public void disableCleanup();

    public void resumeCleanup();

    public void addBlockedStore(PagingStore var1);

    public void injectMonitor(FileStoreMonitor var1) throws Exception;

    default public void execute(Runnable runnable) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void lock();

    public void unlock();

    public PagingManager addSize(int var1, boolean var2);

    default public PagingManager addSize(int size) {
        return this.addSize(size, false);
    }

    default public PagingManager addSizeOnly(int size) {
        return this.addSize(size, true);
    }

    public boolean isUsingGlobalSize();

    public boolean isGlobalFull();

    public boolean isDiskFull();

    public long getDiskUsableSpace();

    public long getDiskTotalSpace();

    default public long getGlobalSize() {
        return 0L;
    }

    default public long getGlobalMessages() {
        return 0L;
    }

    public void checkMemory(Runnable var1);

    public void counterSnapshot();

    default public void checkStorage(Runnable runWhenAvailable) {
        this.checkMemory(runWhenAvailable);
    }

    default public long getMaxSize() {
        return 0L;
    }

    default public long getMaxMessages() {
        return 0L;
    }

    default public Future<Object> rebuildCounters(Set<Long> storedLargeMessages) {
        return null;
    }

    default public void forEachTransaction(BiConsumer<Long, PageTransactionInfo> transactionConsumer) {
    }

    default public boolean isRebuildingCounters() {
        return false;
    }
}

