/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.tree.SqmStatement;

public final class SqmInterpretationsKey
implements QueryInterpretationCache.Key {
    private final Object query;
    private final Class<?> resultType;
    private final LockOptions lockOptions;
    private final TupleTransformer<?> tupleTransformer;
    private final ResultListTransformer<?> resultListTransformer;
    private final Collection<String> enabledFetchProfiles;
    private final int hashcode;

    public static SqmInterpretationsKey createInterpretationsKey(InterpretationsKeySource keySource) {
        if (SqmInterpretationsKey.isCacheable(keySource)) {
            Object query = "<criteria>".equals(keySource.getQueryString()) ? keySource.getSqmStatement() : keySource.getQueryString();
            return new SqmInterpretationsKey(query, query.hashCode(), keySource.getResultType(), keySource.getQueryOptions().getLockOptions(), keySource.getQueryOptions().getTupleTransformer(), keySource.getQueryOptions().getResultListTransformer(), SqmInterpretationsKey.memoryEfficientDefensiveSetCopy(keySource.getLoadQueryInfluencers().getEnabledFetchProfileNames()));
        }
        return null;
    }

    private static Collection<String> memoryEfficientDefensiveSetCopy(Set<String> set) {
        if (set == null) {
            return null;
        }
        switch (set.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return Set.of(set.iterator().next());
            }
            case 2: {
                Iterator<String> iterator = set.iterator();
                return Set.of(iterator.next(), iterator.next());
            }
        }
        return Set.copyOf(set);
    }

    private static boolean isCacheable(InterpretationsKeySource keySource) {
        assert (keySource.getQueryOptions().getAppliedGraph() != null);
        return keySource.isQueryPlanCacheable() && !keySource.getLoadQueryInfluencers().hasEnabledFilters() && keySource.getQueryOptions().getAppliedGraph().getSemantic() == null && keySource.hasMultiValuedParameterBindingsChecker().get() == false == Boolean.TRUE;
    }

    public static QueryInterpretationCache.Key generateNonSelectKey(InterpretationsKeySource keyDetails) {
        return null;
    }

    private SqmInterpretationsKey(Object query, int hash, Class<?> resultType, LockOptions lockOptions, TupleTransformer<?> tupleTransformer, ResultListTransformer<?> resultListTransformer, Collection<String> enabledFetchProfiles) {
        this.query = query;
        this.hashcode = hash;
        this.resultType = resultType;
        this.lockOptions = lockOptions;
        this.tupleTransformer = tupleTransformer;
        this.resultListTransformer = resultListTransformer;
        this.enabledFetchProfiles = enabledFetchProfiles;
    }

    @Override
    public QueryInterpretationCache.Key prepareForStore() {
        return new SqmInterpretationsKey(this.query, this.hashcode, this.resultType, this.lockOptions.makeDefensiveCopy(), this.tupleTransformer, this.resultListTransformer, this.enabledFetchProfiles);
    }

    @Override
    public String getQueryString() {
        return this.query instanceof String ? (String)this.query : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || SqmInterpretationsKey.class != o.getClass()) {
            return false;
        }
        SqmInterpretationsKey that = (SqmInterpretationsKey)o;
        return this.hashcode == o.hashCode() && this.query.equals(that.query) && Objects.equals(this.resultType, that.resultType) && Objects.equals(this.lockOptions, that.lockOptions) && Objects.equals(this.tupleTransformer, that.tupleTransformer) && Objects.equals(this.resultListTransformer, that.resultListTransformer) && Objects.equals(this.enabledFetchProfiles, that.enabledFetchProfiles);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static interface InterpretationsKeySource
    extends CacheabilityInfluencers {
        public Class<?> getResultType();
    }

    public static interface CacheabilityInfluencers {
        public boolean isQueryPlanCacheable();

        public String getQueryString();

        public SqmStatement<?> getSqmStatement();

        public QueryOptions getQueryOptions();

        public LoadQueryInfluencers getLoadQueryInfluencers();

        public Supplier<Boolean> hasMultiValuedParameterBindingsChecker();
    }
}

