/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.aop.support.StaticMethodMatcherPointcut;
import org.springframework.lang.Nullable;
import org.springframework.util.PatternMatchUtils;

public class NameMatchMethodPointcut
extends StaticMethodMatcherPointcut
implements Serializable {
    private List<String> mappedNamePatterns = new ArrayList<String>();

    public void setMappedName(String mappedNamePattern) {
        this.setMappedNames(mappedNamePattern);
    }

    public void setMappedNames(String ... mappedNamePatterns) {
        this.mappedNamePatterns = new ArrayList<String>(Arrays.asList(mappedNamePatterns));
    }

    public NameMatchMethodPointcut addMethodName(String mappedNamePattern) {
        this.mappedNamePatterns.add(mappedNamePattern);
        return this;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        for (String mappedNamePattern : this.mappedNamePatterns) {
            if (!mappedNamePattern.equals(method.getName()) && !this.isMatch(method.getName(), mappedNamePattern)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(String methodName, String mappedNamePattern) {
        return PatternMatchUtils.simpleMatch((String)mappedNamePattern, (String)methodName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof NameMatchMethodPointcut)) return false;
        NameMatchMethodPointcut that = (NameMatchMethodPointcut)other;
        if (!this.mappedNamePatterns.equals(that.mappedNamePatterns)) return false;
        return true;
    }

    public int hashCode() {
        return this.mappedNamePatterns.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + String.valueOf(this.mappedNamePatterns);
    }
}

