/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository.sql.commands;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.sql.SchemaInfo;
import com.xebialabs.deployit.core.sql.spring.package;
import com.xebialabs.deployit.engine.spi.event.CiRenamedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.repository.sql.artifacts.ArtifactDataRepository;
import com.xebialabs.deployit.repository.sql.base.package$;
import com.xebialabs.deployit.repository.sql.cache.CiPathModifiedInfo;
import com.xebialabs.deployit.repository.sql.cache.CisCacheDataProcessor;
import com.xebialabs.deployit.repository.sql.cache.ConsolidatedCiRenamedInfo;
import com.xebialabs.deployit.repository.sql.commands.ChangeSetContext;
import com.xebialabs.deployit.repository.sql.commands.UpdatePathCommand;
import com.xebialabs.deployit.sql.base.schema.CIS$;
import com.xebialabs.deployit.util.Tuple;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005eb\u0001B\b\u0011\u0001uA\u0001B\t\u0001\u0003\u0006\u0004%\te\t\u0005\ta\u0001\u0011\t\u0011)A\u0005I!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00059\u0001\t\u0015\r\u0011\"\u0001:\u0011!1\u0006A!A!\u0002\u0013Q\u0004\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011y\u0003!Q1A\u0005\u0004}C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006a\u0002!\t%\u001d\u0005\u0006w\u0002!\t\u0005 \u0005\u0006}\u0002!Ia \u0005\b\u0003\u0013\u0001A\u0011BA\u0006\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'\u0011QBU3oC6,7i\\7nC:$'BA\t\u0013\u0003!\u0019w.\\7b]\u0012\u001c(BA\n\u0015\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Y\t!B]3q_NLGo\u001c:z\u0015\t9\u0002$\u0001\u0005eKBdw._5u\u0015\tI\"$A\u0005yK\nL\u0017\r\\1cg*\t1$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u0002!%\u0011\u0011\u0005\u0005\u0002\u0012+B$\u0017\r^3QCRD7i\\7nC:$\u0017\u0001\u00046eE\u000e$V-\u001c9mCR,W#\u0001\u0013\u0011\u0005\u0015rS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001B2pe\u0016T!!\u000b\u0016\u0002\t)$'m\u0019\u0006\u0003W1\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002[\u0005\u0019qN]4\n\u0005=2#\u0001\u0004&eE\u000e$V-\u001c9mCR,\u0017!\u00046eE\u000e$V-\u001c9mCR,\u0007%\u0001\nbeRLg-Y2u%\u0016\u0004xn]5u_JL\bCA\u001a7\u001b\u0005!$BA\u001b\u0013\u0003%\t'\u000f^5gC\u000e$8/\u0003\u00028i\t1\u0012I\u001d;jM\u0006\u001cG\u000fR1uCJ+\u0007o\\:ji>\u0014\u00180A\u0005sK:\fW.Z\"jgV\t!\bE\u0002<\u000b\"s!\u0001\u0010\"\u000f\u0005u\u0002U\"\u0001 \u000b\u0005}b\u0012A\u0002\u001fs_>$h(C\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019E)A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0005K!AR$\u0003\u0011%#XM]1cY\u0016T!a\u0011#\u0011\t%ceJT\u0007\u0002\u0015*\u00111JF\u0001\u0005kRLG.\u0003\u0002N\u0015\n)A+\u001e9mKB\u0011qj\u0015\b\u0003!F\u0003\"!\u0010#\n\u0005I#\u0015A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015#\u0002\u0015I,g.Y7f\u0007&\u001c\b%A\u000bdSN\u001c\u0015m\u00195f\t\u0006$\u0018\r\u0015:pG\u0016\u001c8o\u001c:\u0011\u0005ecV\"\u0001.\u000b\u0005m\u0013\u0012!B2bG\",\u0017BA/[\u0005U\u0019\u0015n]\"bG\",G)\u0019;b!J|7-Z:t_J\f!b]2iK6\f\u0017J\u001c4p+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA\nd\u0015\t9c#\u0003\u0002fE\nQ1k\u00195f[\u0006LeNZ8\u0002\u0017M\u001c\u0007.Z7b\u0013:4w\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b%dWN\\8\u0015\u0005)\\\u0007CA\u0010\u0001\u0011\u0015q\u0016\u0002q\u0001a\u0011\u0015\u0011\u0013\u00021\u0001%\u0011\u0015\t\u0014\u00021\u00013\u0011\u0015A\u0014\u00021\u0001;\u0011\u00159\u0016\u00021\u0001Y\u0003\u001d)\u00070Z2vi\u0016$\"A\u001d<\u0011\u0005M$X\"\u0001#\n\u0005U$%\u0001B+oSRDQa\u001e\u0006A\u0002a\fqaY8oi\u0016DH\u000f\u0005\u0002 s&\u0011!\u0010\u0005\u0002\u0011\u0007\"\fgnZ3TKR\u001cuN\u001c;fqR\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003evDQa^\u0006A\u0002a\faA]3oC6,G#\u0002:\u0002\u0002\u0005\u0015\u0001BBA\u0002\u0019\u0001\u0007a*A\u0003pY\u0012LE\r\u0003\u0004\u0002\b1\u0001\rAT\u0001\b]\u0016<h*Y7f\u000391\u0018\r\\5eCR,'+\u001a8b[\u0016$RA]A\u0007\u0003\u001fAa!a\u0001\u000e\u0001\u0004q\u0005BBA\u0004\u001b\u0001\u0007a*A\nrk\u0016\u0014\u00180\u00118e!J,g+\u00197jI\u0006$X\r\u0006\u0004\u0002\u0016\u0005U\u0012q\u0007\t\u0007g\u0006]a*a\u0007\n\u0007\u0005eAI\u0001\u0004UkBdWM\r\t\b\u0003;\t)CTA\u0015\u001b\t\tyBC\u0002L\u0003CQ!!a\t\u0002\t)\fg/Y\u0005\u0005\u0003O\tyBA\u0002NCB\u0004B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t#\u0001\u0003mC:<\u0017\u0002BA\u001a\u0003[\u0011aa\u00142kK\u000e$\bBBA\u0002\u001d\u0001\u0007a\n\u0003\u0004\u0002\b9\u0001\rA\u0014")
public class RenameCommand
extends UpdatePathCommand {
    private final JdbcTemplate jdbcTemplate;
    private final Iterable<Tuple<String, String>> renameCis;
    private final CisCacheDataProcessor cisCacheDataProcessor;
    private final SchemaInfo schemaInfo;

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public Iterable<Tuple<String, String>> renameCis() {
        return this.renameCis;
    }

    public SchemaInfo schemaInfo() {
        return this.schemaInfo;
    }

    @Override
    public void execute(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable)t -> {
            this.rename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void validate(ChangeSetContext context) {
        this.renameCis().foreach((Function1 & Serializable)t -> {
            this.validateRename((String)t.a, (String)t.b);
            return BoxedUnit.UNIT;
        });
    }

    private void rename(String oldId, String newName) {
        String string;
        Map map;
        block3: {
            Tuple2<String, Map<String, Object>> tuple2;
            block2: {
                tuple2 = this.queryAndPreValidate(oldId, newName);
                if (tuple2 == null) break block2;
                String oldPath = (String)tuple2._1();
                map = (Map)tuple2._2();
                if (oldPath == null) break block2;
                string = oldPath;
                if (map != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        Map map2 = map;
        Tuple2 tuple2 = new Tuple2((Object)string, (Object)map2);
        String oldPath = (String)tuple2._1();
        Map map3 = (Map)tuple2._2();
        ConfigurationItem ci = package$.MODULE$.readBaseCiFromMap(map3);
        String newPath = (String)package$.MODULE$.parentPath(oldId).getOrElse((Function0 & Serializable)() -> {
            throw new NoSuchElementException("No parent path for ID " + oldId);
        }) + "/" + newName;
        ListBuffer modifiedCisInfo = (ListBuffer)this.updateNameAndPath(oldPath, newPath)._2();
        modifiedCisInfo.addOne((Object)new CiPathModifiedInfo(ci.get$internalId(), package$.MODULE$.pathToId(oldPath), oldPath, ci.getName(), package$.MODULE$.pathToId(newPath), newPath, newName));
        this.cisCacheDataProcessor.onRename(new ConsolidatedCiRenamedInfo(ci, (List<CiPathModifiedInfo>)modifiedCisInfo.toList()));
        EventBusHolder.publish((Object)new CiRenamedEvent(ci, newName));
    }

    private void validateRename(String oldId, String newName) {
        this.queryAndPreValidate(oldId, newName);
        String newPath = (String)package$.MODULE$.parentPath(oldId).getOrElse((Function0 & Serializable)() -> {
            throw new NoSuchElementException("No parent path for ID " + oldId);
        }) + "/" + newName;
        if (this.exists(newPath)) {
            throw new ItemAlreadyExistsException("The destination id [%s] exists.", new Object[]{package$.MODULE$.pathToId(newPath)});
        }
    }

    private Tuple2<String, Map<String, Object>> queryAndPreValidate(String oldId, String newName) {
        Type ciType;
        Checks.checkArgument((!StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(newName), '/') ? 1 : 0) != 0, (String)"New name [%s] should not contain a /", (Object[])new Object[]{newName});
        String oldPath = package$.MODULE$.idToPath(oldId);
        Map map = (Map)this.jdbcTemplate().queryForObject(this.SELECT_CI_BY_PATH(), (RowMapper)package.MapRowMapper$.MODULE$, new Object[]{oldPath});
        Type type = ciType = Type.valueOf((String)((String)map.get(CIS$.MODULE$.ci_type().name())));
        Type type2 = Type.valueOf(Root.class);
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        return new Tuple2((Object)oldPath, (Object)map);
    }

    public RenameCommand(JdbcTemplate jdbcTemplate, ArtifactDataRepository artifactRepository, Iterable<Tuple<String, String>> renameCis, CisCacheDataProcessor cisCacheDataProcessor, SchemaInfo schemaInfo) {
        this.jdbcTemplate = jdbcTemplate;
        this.renameCis = renameCis;
        this.cisCacheDataProcessor = cisCacheDataProcessor;
        this.schemaInfo = schemaInfo;
        super(jdbcTemplate, artifactRepository);
    }
}

