/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.handler.WebSocketHandlerDecorator;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.jetty.JettyRequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.GlassFishRequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.StandardWebSocketUpgradeStrategy;
import org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.UndertowRequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.WebLogicRequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.WebSphereRequestUpgradeStrategy;

public abstract class AbstractHandshakeHandler
implements HandshakeHandler,
Lifecycle {
    private static final HttpMethod CONNECT_METHOD = HttpMethod.valueOf((String)"CONNECT");
    private static final boolean tomcatWsPresent;
    private static final boolean jettyWsPresent;
    private static final boolean undertowWsPresent;
    private static final boolean glassfishWsPresent;
    private static final boolean weblogicWsPresent;
    private static final boolean websphereWsPresent;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final RequestUpgradeStrategy requestUpgradeStrategy;
    private final List<String> supportedProtocols = new ArrayList<String>();
    private volatile boolean running;

    protected AbstractHandshakeHandler() {
        this(AbstractHandshakeHandler.initRequestUpgradeStrategy());
    }

    protected AbstractHandshakeHandler(RequestUpgradeStrategy requestUpgradeStrategy) {
        Assert.notNull((Object)requestUpgradeStrategy, (String)"RequestUpgradeStrategy must not be null");
        this.requestUpgradeStrategy = requestUpgradeStrategy;
    }

    public RequestUpgradeStrategy getRequestUpgradeStrategy() {
        return this.requestUpgradeStrategy;
    }

    public void setSupportedProtocols(String ... protocols) {
        this.supportedProtocols.clear();
        for (String protocol : protocols) {
            this.supportedProtocols.add(protocol.toLowerCase(Locale.ROOT));
        }
    }

    public String[] getSupportedProtocols() {
        return StringUtils.toStringArray(this.supportedProtocols);
    }

    public void start() {
        if (!this.isRunning()) {
            this.running = true;
            this.doStart();
        }
    }

    protected void doStart() {
        RequestUpgradeStrategy requestUpgradeStrategy = this.requestUpgradeStrategy;
        if (requestUpgradeStrategy instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)requestUpgradeStrategy;
            lifecycle.start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.running = false;
            this.doStop();
        }
    }

    protected void doStop() {
        RequestUpgradeStrategy requestUpgradeStrategy = this.requestUpgradeStrategy;
        if (requestUpgradeStrategy instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)requestUpgradeStrategy;
            lifecycle.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    @Override
    public final boolean doHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws HandshakeFailureException {
        WebSocketHttpHeaders headers = new WebSocketHttpHeaders(request.getHeaders());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Processing request " + String.valueOf(request.getURI()) + " with headers=" + String.valueOf((Object)headers)));
        }
        try {
            HttpMethod httpMethod = request.getMethod();
            if (HttpMethod.GET != httpMethod && !CONNECT_METHOD.equals((Object)httpMethod)) {
                response.setStatusCode((HttpStatusCode)HttpStatus.METHOD_NOT_ALLOWED);
                response.getHeaders().setAllow(Set.of(HttpMethod.GET, CONNECT_METHOD));
                if (this.logger.isErrorEnabled()) {
                    this.logger.error((Object)("Handshake failed due to unexpected HTTP method: " + String.valueOf(httpMethod)));
                }
                return false;
            }
            if (HttpMethod.GET == httpMethod) {
                if (!"WebSocket".equalsIgnoreCase(headers.getUpgrade())) {
                    this.handleInvalidUpgradeHeader(request, response);
                    return false;
                }
                List connectionValue = headers.getConnection();
                if (!connectionValue.contains("Upgrade") && !connectionValue.contains("upgrade")) {
                    this.handleInvalidConnectHeader(request, response);
                    return false;
                }
                String key = headers.getSecWebSocketKey();
                if (key == null) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error((Object)"Missing \"Sec-WebSocket-Key\" header");
                    }
                    response.setStatusCode((HttpStatusCode)HttpStatus.BAD_REQUEST);
                    return false;
                }
            }
            if (!this.isWebSocketVersionSupported(headers)) {
                this.handleWebSocketVersionNotSupported(request, response);
                return false;
            }
            if (!this.isValidOrigin(request)) {
                response.setStatusCode((HttpStatusCode)HttpStatus.FORBIDDEN);
                return false;
            }
        }
        catch (IOException ex) {
            throw new HandshakeFailureException("Response update failed during upgrade to WebSocket: " + String.valueOf(request.getURI()), ex);
        }
        String subProtocol = this.selectProtocol(headers.getSecWebSocketProtocol(), wsHandler);
        List<WebSocketExtension> requested = headers.getSecWebSocketExtensions();
        List<WebSocketExtension> supported = this.requestUpgradeStrategy.getSupportedExtensions(request);
        List<WebSocketExtension> extensions = this.filterRequestedExtensions(request, requested, supported);
        Principal user = this.determineUser(request, wsHandler, attributes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Upgrading to WebSocket, subProtocol=" + subProtocol + ", extensions=" + String.valueOf(extensions)));
        }
        this.requestUpgradeStrategy.upgrade(request, response, subProtocol, extensions, user, wsHandler, attributes);
        return true;
    }

    protected void handleInvalidUpgradeHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)LogFormatUtils.formatValue((Object)("Handshake failed due to invalid Upgrade header: " + request.getHeaders().getUpgrade()), (int)-1, (boolean)true));
        }
        response.setStatusCode((HttpStatusCode)HttpStatus.BAD_REQUEST);
        response.getBody().write("Can \"Upgrade\" only to \"WebSocket\".".getBytes(StandardCharsets.UTF_8));
    }

    protected void handleInvalidConnectHeader(ServerHttpRequest request, ServerHttpResponse response) throws IOException {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)LogFormatUtils.formatValue((Object)("Handshake failed due to invalid Connection header" + String.valueOf(request.getHeaders().getConnection())), (int)-1, (boolean)true));
        }
        response.setStatusCode((HttpStatusCode)HttpStatus.BAD_REQUEST);
        response.getBody().write("\"Connection\" must be \"upgrade\".".getBytes(StandardCharsets.UTF_8));
    }

    protected boolean isWebSocketVersionSupported(WebSocketHttpHeaders httpHeaders) {
        String[] supportedVersions;
        String version = httpHeaders.getSecWebSocketVersion();
        for (String supportedVersion : supportedVersions = this.getSupportedVersions()) {
            if (!supportedVersion.trim().equals(version)) continue;
            return true;
        }
        return false;
    }

    protected String[] getSupportedVersions() {
        return this.requestUpgradeStrategy.getSupportedVersions();
    }

    protected void handleWebSocketVersionNotSupported(ServerHttpRequest request, ServerHttpResponse response) {
        if (this.logger.isErrorEnabled()) {
            String version = request.getHeaders().getFirst("Sec-WebSocket-Version");
            this.logger.error((Object)LogFormatUtils.formatValue((Object)("Handshake failed due to unsupported WebSocket version: " + version + ". Supported versions: " + Arrays.toString(this.getSupportedVersions())), (int)-1, (boolean)true));
        }
        response.setStatusCode((HttpStatusCode)HttpStatus.UPGRADE_REQUIRED);
        response.getHeaders().set("Sec-WebSocket-Version", StringUtils.arrayToCommaDelimitedString((Object[])this.getSupportedVersions()));
    }

    protected boolean isValidOrigin(ServerHttpRequest request) {
        return true;
    }

    @Nullable
    protected String selectProtocol(List<String> requestedProtocols, WebSocketHandler webSocketHandler) {
        List<String> handlerProtocols = this.determineHandlerSupportedProtocols(webSocketHandler);
        for (String protocol : requestedProtocols) {
            if (handlerProtocols.contains(protocol.toLowerCase(Locale.ROOT))) {
                return protocol;
            }
            if (!this.supportedProtocols.contains(protocol.toLowerCase(Locale.ROOT))) continue;
            return protocol;
        }
        return null;
    }

    protected final List<String> determineHandlerSupportedProtocols(WebSocketHandler handler) {
        WebSocketHandler handlerToCheck = WebSocketHandlerDecorator.unwrap(handler);
        List<String> subProtocols = null;
        if (handlerToCheck instanceof SubProtocolCapable) {
            SubProtocolCapable subProtocolCapable = (SubProtocolCapable)((Object)handlerToCheck);
            subProtocols = subProtocolCapable.getSubProtocols();
        }
        return subProtocols != null ? subProtocols : Collections.emptyList();
    }

    protected List<WebSocketExtension> filterRequestedExtensions(ServerHttpRequest request, List<WebSocketExtension> requestedExtensions, List<WebSocketExtension> supportedExtensions) {
        ArrayList<WebSocketExtension> result = new ArrayList<WebSocketExtension>(requestedExtensions.size());
        for (WebSocketExtension extension : requestedExtensions) {
            if (!supportedExtensions.contains(extension)) continue;
            result.add(extension);
        }
        return result;
    }

    @Nullable
    protected Principal determineUser(ServerHttpRequest request, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        return request.getPrincipal();
    }

    private static RequestUpgradeStrategy initRequestUpgradeStrategy() {
        if (tomcatWsPresent) {
            return new TomcatRequestUpgradeStrategy();
        }
        if (jettyWsPresent) {
            return new JettyRequestUpgradeStrategy();
        }
        if (undertowWsPresent) {
            return new UndertowRequestUpgradeStrategy();
        }
        if (glassfishWsPresent) {
            return TyrusStrategyDelegate.forGlassFish();
        }
        if (weblogicWsPresent) {
            return TyrusStrategyDelegate.forWebLogic();
        }
        if (websphereWsPresent) {
            return new WebSphereRequestUpgradeStrategy();
        }
        return new StandardWebSocketUpgradeStrategy();
    }

    static {
        ClassLoader classLoader = AbstractHandshakeHandler.class.getClassLoader();
        tomcatWsPresent = ClassUtils.isPresent((String)"org.apache.tomcat.websocket.server.WsHttpUpgradeHandler", (ClassLoader)classLoader);
        jettyWsPresent = ClassUtils.isPresent((String)"org.eclipse.jetty.ee10.websocket.server.JettyWebSocketServerContainer", (ClassLoader)classLoader);
        undertowWsPresent = ClassUtils.isPresent((String)"io.undertow.websockets.jsr.ServerWebSocketContainer", (ClassLoader)classLoader);
        glassfishWsPresent = ClassUtils.isPresent((String)"org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler", (ClassLoader)classLoader);
        weblogicWsPresent = ClassUtils.isPresent((String)"weblogic.websocket.tyrus.TyrusServletWriter", (ClassLoader)classLoader);
        websphereWsPresent = ClassUtils.isPresent((String)"com.ibm.websphere.wsoc.WsWsocServerContainer", (ClassLoader)classLoader);
    }

    private static class TyrusStrategyDelegate {
        private TyrusStrategyDelegate() {
        }

        public static RequestUpgradeStrategy forGlassFish() {
            return new GlassFishRequestUpgradeStrategy();
        }

        public static RequestUpgradeStrategy forWebLogic() {
            return new WebLogicRequestUpgradeStrategy();
        }
    }
}

