/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.dataset.stream.DataSetProducerAdapter;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvDataSetWriter
implements IDataSetConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CsvDataSetWriter.class);
    public static final String NULL = "null";
    private static final String NONE = "none";
    private static final String FIELD_SEPARATOR = ", ";
    private static final String QUOTE = "\"";
    private static final String ESCAPE = "\\";
    private Writer writer;
    private ITableMetaData _activeMetaData;
    private String theDirectory;
    private static char testExport;
    private List tableList;

    public CsvDataSetWriter(String theDirectory) {
        this.setTheDirectory(theDirectory);
    }

    public CsvDataSetWriter(File theDirectory) {
        this.setTheDirectory(theDirectory.getAbsolutePath());
    }

    public void write(IDataSet dataSet) throws DataSetException {
        logger.debug("write(dataSet={}) - start", (Object)dataSet);
        DataSetProducerAdapter provider = new DataSetProducerAdapter(dataSet);
        provider.setConsumer(this);
        provider.produce();
    }

    @Override
    public void startDataSet() throws DataSetException {
        logger.debug("startDataSet() - start");
        try {
            this.tableList = new LinkedList();
            new File(this.getTheDirectory()).mkdirs();
        }
        catch (Exception e) {
            throw new DataSetException("Error while creating the destination directory '" + this.getTheDirectory() + "'", e);
        }
    }

    @Override
    public void endDataSet() throws DataSetException {
        logger.debug("endDataSet() - start");
        File orderingFile = new File(this.getTheDirectory(), "table-ordering.txt");
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new FileWriter(orderingFile));
            for (String file : this.tableList) {
                pw.println(file);
            }
        }
    }

    @Override
    public void startTable(ITableMetaData metaData) throws DataSetException {
        logger.debug("startTable(metaData={}) - start", (Object)metaData);
        try {
            this._activeMetaData = metaData;
            String tableName = this._activeMetaData.getTableName();
            this.setWriter(new FileWriter(this.getTheDirectory() + File.separator + tableName + ".csv"));
            this.writeColumnNames();
            this.getWriter().write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    private void writeColumnNames() throws DataSetException, IOException {
        logger.debug("writeColumnNames() - start");
        Column[] columns = this._activeMetaData.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            String columnName = columns[i].getColumnName();
            this.getWriter().write(columnName);
            if (i >= columns.length - 1) continue;
            this.getWriter().write(FIELD_SEPARATOR);
        }
    }

    @Override
    public void endTable() throws DataSetException {
        logger.debug("endTable() - start");
        try {
            this.getWriter().close();
            this.tableList.add(this._activeMetaData.getTableName());
            this._activeMetaData = null;
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    @Override
    public void row(Object[] values) throws DataSetException {
        logger.debug("row(values={}) - start", values);
        try {
            Column[] columns = this._activeMetaData.getColumns();
            for (int i = 0; i < columns.length; ++i) {
                String columnName = columns[i].getColumnName();
                Object value = values[i];
                if (value == null) {
                    this.getWriter().write(NULL);
                } else if (value == ITable.NO_VALUE) {
                    this.getWriter().write(NONE);
                } else {
                    try {
                        String stringValue = DataType.asString(value);
                        String quoted = this.quote(stringValue);
                        this.getWriter().write(quoted);
                    }
                    catch (TypeCastException e) {
                        throw new DataSetException("table=" + this._activeMetaData.getTableName() + ", row=" + i + ", column=" + columnName + ", value=" + value, e);
                    }
                }
                if (i >= columns.length - 1) continue;
                this.getWriter().write(",");
            }
            this.getWriter().write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    private String quote(String stringValue) {
        logger.debug("quote(stringValue={}) - start", (Object)stringValue);
        return new StringBuffer(QUOTE).append(CsvDataSetWriter.escape(stringValue)).append(QUOTE).toString();
    }

    protected static String escape(String stringValue) {
        logger.debug("escape(stringValue={}) - start", (Object)stringValue);
        char[] array = stringValue.toCharArray();
        testExport = QUOTE.toCharArray()[0];
        char escape = ESCAPE.toCharArray()[0];
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (c == testExport || c == escape) {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public Writer getWriter() {
        logger.debug("getWriter() - start");
        return this.writer;
    }

    public void setWriter(Writer writer) {
        logger.debug("setWriter(writer={}) - start", (Object)writer);
        this.writer = writer;
    }

    public String getTheDirectory() {
        logger.debug("getTheDirectory() - start");
        return this.theDirectory;
    }

    public void setTheDirectory(String theDirectory) {
        logger.debug("setTheDirectory(theDirectory={}) - start", (Object)theDirectory);
        this.theDirectory = theDirectory;
    }

    public static void write(IDataSet dataset, File dest) throws DataSetException {
        logger.debug("write(dataset={}, dest={}) - start", (Object)dataset, (Object)dest);
        CsvDataSetWriter writer = new CsvDataSetWriter(dest);
        writer.write(dataset);
    }

    protected void finalize() throws Throwable {
        logger.debug("finalize() - start");
        if (this.getWriter() != null) {
            this.getWriter().close();
        }
    }
}

