/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AbstractConcurrentArrayQueue;

public class OneToOneConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    public OneToOneConcurrentArrayQueue(int requestedCapacity) {
        super(requestedCapacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        long currentTail = this.tail;
        long currentHead = this.headCache;
        int capacity = this.capacity;
        long bufferLimit = currentHead + (long)capacity;
        if (currentTail >= bufferLimit) {
            currentHead = this.head;
            bufferLimit = currentHead + (long)capacity;
            if (currentTail >= bufferLimit) {
                return false;
            }
            this.headCache = currentHead;
        }
        long elementOffset = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(currentTail, capacity - 1);
        UnsafeAccess.UNSAFE.putOrderedObject(this.buffer, elementOffset, e);
        UnsafeAccess.UNSAFE.putOrderedLong(this, TAIL_OFFSET, currentTail + 1L);
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long currentHead = this.head;
        long elementOffset = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(currentHead, this.capacity - 1);
        Object e = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, elementOffset);
        if (null != e) {
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, elementOffset, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, currentHead + 1L);
        }
        return (E)e;
    }

    @Override
    public int drain(Consumer<E> elementConsumer) {
        return this.drain(elementConsumer, (int)(this.tail - this.head));
    }

    @Override
    public int drain(Consumer<E> elementConsumer, int limit) {
        long elementOffset;
        Object item;
        long currentHead;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long nextSequence = currentHead = this.head;
        long limitSequence = nextSequence + (long)limit;
        while (nextSequence < limitSequence && null != (item = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, elementOffset = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(nextSequence, mask)))) {
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, elementOffset, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, ++nextSequence);
            elementConsumer.accept(item);
        }
        return (int)(nextSequence - currentHead);
    }

    @Override
    public int drainTo(Collection<? super E> target, int limit) {
        long elementOffset;
        Object item;
        int count;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long nextSequence = this.head;
        for (count = 0; count < limit && null != (item = UnsafeAccess.UNSAFE.getObjectVolatile(buffer, elementOffset = OneToOneConcurrentArrayQueue.sequenceToBufferOffset(nextSequence, mask))); ++count) {
            UnsafeAccess.UNSAFE.putOrderedObject(buffer, elementOffset, null);
            UnsafeAccess.UNSAFE.putOrderedLong(this, HEAD_OFFSET, ++nextSequence);
            target.add(item);
        }
        return count;
    }
}

