/*
 * Decompiled with CFR 0.152.
 */
package kamon.context.generated.binary.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.util.InputMismatchException;

public class BooleanTag
implements Serializable {
    public static int colferSizeMax = 0x1000000;
    public String key;
    public boolean value;
    private static final long serialVersionUID = 2L;

    public BooleanTag() {
        this.init();
    }

    private void init() {
        this.key = "";
    }

    public byte[] marshal(OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        if (byArray == null || byArray.length == 0) {
            byArray = new byte[Math.min(colferSizeMax, 2048)];
        }
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferOverflowException bufferOverflowException) {
                byArray = new byte[Math.min(colferSizeMax, byArray.length * 4)];
                continue;
            }
            break;
        }
        outputStream.write(byArray, 0, n);
        return byArray;
    }

    public int marshal(byte[] byArray, int n) {
        int n2 = n;
        try {
            if (!this.key.isEmpty()) {
                int n3;
                int n4;
                byArray[n2++] = 0;
                int n5 = ++n2;
                String string = this.key;
                int n6 = string.length();
                for (n4 = 0; n4 < n6; ++n4) {
                    n3 = string.charAt(n4);
                    if (n3 < 128) {
                        byArray[n2++] = (byte)n3;
                        continue;
                    }
                    if (n3 < 2048) {
                        byArray[n2++] = (byte)(0xC0 | n3 >>> 6);
                        byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                        continue;
                    }
                    if (n3 < 55296 || n3 > 57343) {
                        byArray[n2++] = (byte)(0xE0 | n3 >>> 12);
                        byArray[n2++] = (byte)(0x80 | n3 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n3 & 0x3F);
                        continue;
                    }
                    int n7 = 0;
                    if (++n4 < n6) {
                        n7 = Character.toCodePoint((char)n3, string.charAt(n4));
                    }
                    if (n7 >= 65536 && n7 < 0x200000) {
                        byArray[n2++] = (byte)(0xF0 | n7 >>> 18);
                        byArray[n2++] = (byte)(0x80 | n7 >>> 12 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n7 >>> 6 & 0x3F);
                        byArray[n2++] = (byte)(0x80 | n7 & 0x3F);
                        continue;
                    }
                    byArray[n2++] = 63;
                }
                n4 = n2 - n5;
                if (n4 > colferSizeMax) {
                    throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.BooleanTag.key size %d exceeds %d UTF-8 bytes", n4, colferSizeMax));
                }
                n6 = n5 - 1;
                if (n4 > 127) {
                    ++n2;
                    for (n3 = n4; n3 >= 16384; n3 >>>= 7) {
                        ++n2;
                    }
                    System.arraycopy(byArray, n5, byArray, n2 - n4, n4);
                    do {
                        byArray[n6++] = (byte)(n4 | 0x80);
                    } while ((n4 >>>= 7) > 127);
                }
                byArray[n6] = (byte)n4;
            }
            if (this.value) {
                byArray[n2++] = 1;
            }
            byArray[n2++] = 127;
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 - n > colferSizeMax) {
                throw new IllegalStateException(String.format("colfer: kamon/context/generated/binary/context.BooleanTag exceeds %d bytes", colferSizeMax));
            }
            if (n2 > byArray.length) {
                throw new BufferOverflowException();
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public int unmarshal(byte[] byArray, int n) {
        return this.unmarshal(byArray, n, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unmarshal(byte[] byArray, int n, int n2) {
        int n3;
        block13: {
            if (n2 > byArray.length) {
                n2 = byArray.length;
            }
            n3 = n;
            try {
                byte by = byArray[n3++];
                if (by == 0) {
                    int n4 = 0;
                    int n5 = 0;
                    while (true) {
                        byte by2 = byArray[n3++];
                        n4 |= (by2 & 0x7F) << n5;
                        if (n5 == 28 || by2 >= 0) break;
                        n5 += 7;
                    }
                    if (n4 < 0 || n4 > colferSizeMax) {
                        throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.BooleanTag.key size %d exceeds %d UTF-8 bytes", n4, colferSizeMax));
                    }
                    n5 = n3;
                    n3 += n4;
                    this.key = new String(byArray, n5, n4, StandardCharsets.UTF_8);
                    by = byArray[n3++];
                }
                if (by == 1) {
                    this.value = true;
                    by = byArray[n3++];
                }
                if (by != 127) {
                    throw new InputMismatchException(String.format("colfer: unknown header at byte %d", n3 - 1));
                }
                if (n3 <= n2 || n2 - n >= colferSizeMax) break block13;
            }
            catch (Throwable throwable) {
                if (n3 > n2 && n2 - n < colferSizeMax) {
                    throw new BufferUnderflowException();
                }
                if (n3 < 0 || n3 - n > colferSizeMax) {
                    throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.BooleanTag exceeds %d bytes", colferSizeMax));
                }
                if (n3 > n2) {
                    throw new BufferUnderflowException();
                }
                throw throwable;
            }
            throw new BufferUnderflowException();
        }
        if (n3 < 0 || n3 - n > colferSizeMax) {
            throw new SecurityException(String.format("colfer: kamon/context/generated/binary/context.BooleanTag exceeds %d bytes", colferSizeMax));
        }
        if (n3 > n2) {
            throw new BufferUnderflowException();
        }
        return n3;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while (true) {
            try {
                n = this.marshal(byArray, 0);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                byArray = new byte[4 * byArray.length];
                continue;
            }
            break;
        }
        objectOutputStream.writeInt(n);
        objectOutputStream.write(byArray, 0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.init();
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.readFully(byArray);
        this.unmarshal(byArray, 0);
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.init();
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public BooleanTag withKey(String string) {
        this.key = string;
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    public void setValue(boolean bl) {
        this.value = bl;
    }

    public BooleanTag withValue(boolean bl) {
        this.value = bl;
        return this;
    }

    public final int hashCode() {
        int n = 1;
        if (this.key != null) {
            n = 31 * n + this.key.hashCode();
        }
        n = 31 * n + (this.value ? 1231 : 1237);
        return n;
    }

    public final boolean equals(Object object) {
        return object instanceof BooleanTag && this.equals((BooleanTag)object);
    }

    public final boolean equals(BooleanTag booleanTag) {
        if (booleanTag == null) {
            return false;
        }
        if (booleanTag == this) {
            return true;
        }
        return booleanTag.getClass() == BooleanTag.class && (this.key == null ? booleanTag.key == null : this.key.equals(booleanTag.key)) && this.value == booleanTag.value;
    }

    public static class Unmarshaller {
        protected InputStream in;
        public byte[] buf;
        protected int offset;
        protected int i;

        public Unmarshaller(InputStream inputStream, byte[] byArray) {
            if (byArray == null || byArray.length == 0) {
                byArray = new byte[Math.min(colferSizeMax, 2048)];
            }
            this.buf = byArray;
            this.reset(inputStream);
        }

        public void reset(InputStream inputStream) {
            if (this.i != this.offset) {
                throw new IllegalStateException("colfer: pending data");
            }
            this.in = inputStream;
            this.offset = 0;
            this.i = 0;
        }

        public BooleanTag next() throws IOException {
            if (this.in == null) {
                return null;
            }
            while (true) {
                if (this.i > this.offset) {
                    try {
                        BooleanTag booleanTag = new BooleanTag();
                        this.offset = booleanTag.unmarshal(this.buf, this.offset, this.i);
                        return booleanTag;
                    }
                    catch (BufferUnderflowException bufferUnderflowException) {
                        // empty catch block
                    }
                }
                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (this.i == this.buf.length) {
                    byte[] byArray = this.buf;
                    if (this.offset == 0) {
                        this.buf = new byte[Math.min(colferSizeMax, this.buf.length * 4)];
                    }
                    System.arraycopy(byArray, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert (this.i < this.buf.length);
                int n = this.in.read(this.buf, this.i, this.buf.length - this.i);
                if (n < 0) {
                    if (this.i > this.offset) {
                        throw new InputMismatchException("colfer: pending data with EOF");
                    }
                    return null;
                }
                assert (n > 0);
                this.i += n;
            }
        }
    }
}

