/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.history.Revision;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.data.history.Revisions;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.core.VaultKeyValueMetadataOperations;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultVersionedKeyValueOperations;
import org.springframework.vault.core.util.KeyValueDelegate;
import org.springframework.vault.repository.convert.SecretDocument;
import org.springframework.vault.repository.convert.VaultConverter;
import org.springframework.vault.repository.core.VaultKeyValueTemplate;
import org.springframework.vault.repository.support.VaultRevisionMetadata;
import org.springframework.vault.support.VaultMetadataResponse;
import org.springframework.vault.support.Versioned;

public class VaultRevisionRepository<T>
implements RevisionRepository<T, String, Integer> {
    private final EntityInformation<T, String> metadata;
    private final String keyspacePath;
    private final VaultVersionedKeyValueOperations operations;
    private final VaultKeyValueMetadataOperations metadataOperations;
    private final VaultConverter converter;

    public VaultRevisionRepository(EntityInformation<T, String> metadata, String keyspace, VaultKeyValueTemplate keyValueTemplate) {
        Assert.notNull(metadata, (String)"EntityInformation must not be null");
        Assert.notNull((Object)((Object)keyValueTemplate), (String)"VaultKeyValueTemplate must not be null");
        this.metadata = metadata;
        this.converter = keyValueTemplate.getConverter();
        VaultOperations vaultOperations = keyValueTemplate.getVaultOperations();
        KeyValueDelegate delegate = new KeyValueDelegate(vaultOperations);
        KeyValueDelegate.MountInfo mountInfo = delegate.getMountInfo(keyspace);
        if (!mountInfo.isAvailable()) {
            throw new IllegalStateException("Mount not available under " + keyspace);
        }
        if (!delegate.isVersioned(keyspace)) {
            throw new IllegalStateException("Mount under " + keyspace + " is not versioned");
        }
        this.keyspacePath = keyspace.substring(mountInfo.getPath().length());
        this.operations = vaultOperations.opsForVersionedKeyValue(mountInfo.getPath());
        this.metadataOperations = this.operations.opsForKeyValueMetadata();
    }

    public Optional<Revision<Integer, T>> findLastChangeRevision(String id) {
        Assert.notNull((Object)id, (String)"Identifier must not be null");
        return this.toRevision((Versioned<Map<String, Object>>)this.operations.get(this.getPath(id)), id);
    }

    public Revisions<Integer, T> findRevisions(String id) {
        VaultMetadataResponse metadata = this.metadataOperations.get(this.getPath(id));
        if (metadata == null) {
            return Revisions.none();
        }
        return Revisions.of(this.collectRevisions(id, metadata.getVersions()));
    }

    private List<Revision<Integer, T>> collectRevisions(String id, List<Versioned.Metadata> versions) {
        ArrayList<Revision<Integer, T>> revisions = new ArrayList<Revision<Integer, T>>();
        for (Versioned.Metadata version : versions) {
            Versioned<Map<String, Object>> versioned = this.operations.get(this.getPath(id), version.getVersion());
            if (versioned == null) continue;
            Object entity = versioned.hasData() ? this.converter.read(this.metadata.getJavaType(), this.createDocument(id, versioned)) : null;
            revisions.add(Revision.of((RevisionMetadata)new VaultRevisionMetadata(versioned), entity));
        }
        return revisions;
    }

    public Page<Revision<Integer, T>> findRevisions(String id, Pageable pageable) {
        if (pageable.isUnpaged()) {
            return new PageImpl(Collections.emptyList());
        }
        VaultMetadataResponse metadata = this.metadataOperations.get(this.getPath(id));
        if (metadata == null || pageable.getOffset() > (long)metadata.getVersions().size()) {
            return Page.empty((Pageable)pageable);
        }
        List<Versioned.Metadata> versions = metadata.getVersions();
        int toIndex = Math.min(versions.size(), Math.toIntExact(pageable.getOffset() + (long)pageable.getPageSize()));
        List<Versioned.Metadata> metadataPage = versions.subList(Math.toIntExact(pageable.getOffset()), toIndex);
        List<Revision<Integer, T>> revisions = this.collectRevisions(id, metadataPage);
        return new PageImpl(revisions, pageable, (long)versions.size());
    }

    public Optional<Revision<Integer, T>> findRevision(String id, Integer revisionNumber) {
        Assert.notNull((Object)id, (String)"Identifier must not be null");
        Assert.notNull((Object)revisionNumber, (String)"Revision number must not be null");
        return this.toRevision(this.operations.get(this.getPath(id), Versioned.Version.from(revisionNumber)), id);
    }

    private Optional<Revision<Integer, T>> toRevision(@Nullable Versioned<Map<String, Object>> versioned, String id) {
        if (versioned == null) {
            return Optional.empty();
        }
        Object entity = versioned.hasData() ? this.converter.read(this.metadata.getJavaType(), this.createDocument(id, versioned)) : null;
        return Optional.of(Revision.of((RevisionMetadata)new VaultRevisionMetadata(versioned), entity));
    }

    private String getPath(String id) {
        return this.keyspacePath + "/" + id;
    }

    private SecretDocument createDocument(String id, Versioned<Map<String, Object>> versioned) {
        return new SecretDocument(id, versioned.getVersion().getVersion(), versioned.getRequiredData());
    }
}

