/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.beans;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.BeanProperties;
import com.jeta.forms.gui.beans.DynamicBeanInfo;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.store.bean.BeanDeserializer;
import com.jeta.forms.store.bean.BeanSerializer;
import com.jeta.forms.store.bean.BeanSerializerFactory;
import com.jeta.forms.store.memento.BeanMemento;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.memento.StateRequest;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TransformProperty;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.support.EmptyCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;

public class JETABean
extends JPanel {
    private Component m_delegate;
    private DynamicBeanInfo m_beaninfo;
    private HashMap m_custom_properties = new HashMap();

    public JETABean() {
        this.setOpaque(false);
    }

    public JETABean(Component component, BeanProperties beanProperties) throws FormException {
        this.setOpaque(false);
        try {
            this.m_delegate = component;
            if (beanProperties != null) {
                this.m_beaninfo = beanProperties.getBeanInfo();
                Iterator iterator = beanProperties.getPropertyValues().iterator();
                while (iterator.hasNext()) {
                    JETAProperty jETAProperty = (JETAProperty)iterator.next();
                    this.m_custom_properties.put(jETAProperty.getName(), jETAProperty);
                }
            }
            if (component != null) {
                this.initialize();
            }
        }
        catch (Exception exception) {
            FormsLogger.severe(exception);
        }
    }

    public JETABean(Component component) throws FormException {
        try {
            this.setOpaque(false);
            this.m_delegate = component;
            this.initialize();
        }
        catch (Exception exception) {
            System.out.println(">>>>>> JETABean initialized failed for delegate: " + this.m_delegate);
            exception.printStackTrace();
        }
    }

    public DynamicBeanInfo getBeanInfo() {
        if (this.m_beaninfo == null) {
            try {
                if (this.m_delegate != null) {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.m_delegate.getClass());
                    this.m_beaninfo = new DynamicBeanInfo(beanInfo, null);
                }
            }
            catch (Exception exception) {
                FormsLogger.severe(exception);
            }
        }
        return this.m_beaninfo;
    }

    public JETAProperty getCustomProperty(String string) {
        return (JETAProperty)this.m_custom_properties.get(string);
    }

    public Component getDelegate() {
        return this.m_delegate;
    }

    public Component getBeanChildComponent() {
        if (this.getComponentCount() > 0) {
            return this.getComponent(0);
        }
        return null;
    }

    public String getBeanName() {
        if (this.m_delegate == null) {
            return null;
        }
        return this.m_delegate.getName();
    }

    public Collection getPropertyDescriptors() {
        DynamicBeanInfo dynamicBeanInfo = this.getBeanInfo();
        if (dynamicBeanInfo != null) {
            return dynamicBeanInfo.getPropertyDescriptors();
        }
        return EmptyCollection.getInstance();
    }

    public void getState(BeanMemento beanMemento, StateRequest stateRequest) throws FormException {
        try {
            beanMemento.setJETABeanClass(this.getClass().getName());
            if (this.m_delegate != null && this.m_delegate.getClass() != null) {
                beanMemento.setBeanClass(this.m_delegate.getClass().getName());
                BeanSerializerFactory beanSerializerFactory = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
                if (beanSerializerFactory != null) {
                    BeanSerializer beanSerializer = beanSerializerFactory.createSerializer();
                    beanMemento.setProperties(beanSerializer.writeBean(this));
                } else {
                    FormUtils.safeAssert(false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initialize() throws FormException {
        try {
            this.removeAll();
            if (this.m_delegate != null) {
                this.setLayout(new BorderLayout());
                this.add(this.m_delegate, "Center");
                Collection collection = this.m_custom_properties.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    JETAProperty jETAProperty = (JETAProperty)iterator.next();
                    jETAProperty.updateBean(this);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setCustomProperty(String string, JETAProperty jETAProperty) {
        this.m_custom_properties.put(string, jETAProperty);
    }

    public void setName(String string) {
        FormUtils.safeAssert(false);
    }

    public void setState(BeanMemento beanMemento) throws FormException {
        try {
            PropertiesMemento propertiesMemento = beanMemento.getProperties();
            if (propertiesMemento != null) {
                this.setState(propertiesMemento);
            } else {
                this.setStateOld(beanMemento);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setState(PropertiesMemento propertiesMemento) throws FormException {
        try {
            if (propertiesMemento != null) {
                this.removeAll();
                this.setLayout(new BorderLayout());
                this.m_delegate = null;
                BeanSerializerFactory beanSerializerFactory = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
                if (beanSerializerFactory != null) {
                    BeanDeserializer beanDeserializer = beanSerializerFactory.createDeserializer(propertiesMemento);
                    this.m_delegate = beanDeserializer.createBean();
                    if (this.m_delegate != null) {
                        this.add(this.m_delegate, "Center");
                        Collection collection = this.m_custom_properties.values();
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            JETAProperty jETAProperty = (JETAProperty)iterator.next();
                            if (!(jETAProperty instanceof TransformProperty)) continue;
                            ((TransformProperty)((Object)jETAProperty)).setBean(this);
                        }
                        beanDeserializer.initializeBean(this);
                    }
                } else {
                    FormUtils.safeAssert(false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setStateOld(BeanMemento beanMemento) {
        try {
            Collection collection;
            byte[] byArray = beanMemento.getBeanXML();
            byte[] byArray2 = beanMemento.getBeanXML();
            if (byArray2 == null) {
                return;
            }
            XMLDecoder xMLDecoder = new XMLDecoder(new ByteArrayInputStream(byArray2));
            this.m_delegate = (Component)xMLDecoder.readObject();
            if (this.m_delegate == null) {
                return;
            }
            if (this.m_delegate instanceof JList) {
                ((JList)this.m_delegate).setModel(new DefaultListModel());
            }
            if ((collection = beanMemento.getCustomProperties()) != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    JETAProperty jETAProperty = (JETAProperty)iterator.next();
                    JETAProperty jETAProperty2 = this.getCustomProperty(jETAProperty.getName());
                    if (jETAProperty2 != null) {
                        if (jETAProperty2 instanceof TransformProperty) continue;
                        jETAProperty2.setValue(jETAProperty);
                        continue;
                    }
                    if (jETAProperty instanceof TransformProperty) continue;
                    FormsLogger.debug("JETABean.setState getCustomProperty failed: " + jETAProperty.getName() + "  " + jETAProperty);
                }
            }
            this.initialize();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void postInitialize(FormPanel formPanel) {
        Collection collection = this.m_custom_properties.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JETAProperty jETAProperty = (JETAProperty)iterator.next();
            jETAProperty.postInitialize(formPanel, this);
        }
    }
}

