/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.DiscriminatorSqmPath;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.tree.domain.NonAggregatedCompositeSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;

public class SqmPathVisitor
extends BaseSemanticQueryWalker {
    private final Consumer<SqmPath<?>> pathConsumer;

    public SqmPathVisitor(Consumer<SqmPath<?>> pathConsumer) {
        this.pathConsumer = pathConsumer;
    }

    @Override
    public Object visitBasicValuedPath(SqmBasicValuedSimplePath<?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitEntityValuedPath(SqmEntityValuedSimplePath<?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitAnyValuedValuedPath(SqmAnyValuedSimplePath<?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitQualifiedAttributeJoin(SqmAttributeJoin<?, ?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitTreatedPath(SqmTreatedPath<?, ?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitDiscriminatorPath(DiscriminatorSqmPath<?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitPluralValuedPath(SqmPluralValuedSimplePath<?> path) {
        this.pathConsumer.accept(path);
        return path;
    }

    @Override
    public Object visitNonAggregatedCompositeValuedPath(NonAggregatedCompositeSimplePath<?> path) {
        this.pathConsumer.accept(path);
        return path;
    }
}

