/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import org.dbunit.dataset.datatype.BlobDataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class OracleXMLTypeDataType
extends BlobDataType {
    OracleXMLTypeDataType() {
        super("SQLXML", 2009);
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        byte[] data = null;
        OracleResultSet oracleResultSet = (OracleResultSet)resultSet;
        SQLXML sqlXml = oracleResultSet.getSQLXML(column);
        if (sqlXml != null) {
            data = sqlXml.getString().getBytes();
        }
        return this.typeCast(data);
    }

    @Override
    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)statement;
        SQLXML sqlXmlValue = oraclePreparedStatement.getConnection().createSQLXML();
        sqlXmlValue.setString(new String((byte[])this.typeCast(value)));
        oraclePreparedStatement.setSQLXML(column, sqlXmlValue);
    }

    @Override
    public String getSqlTypeName() {
        return "SYS.XMLTYPE";
    }
}

