/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import jakarta.transaction.TransactionManager;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.LockedStream;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.metadata.Metadata;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.concurrent.locks.LockManager;

public abstract class AbstractDelegatingAdvancedCache<K, V>
extends AbstractDelegatingCache<K, V>
implements AdvancedCache<K, V> {
    protected final AdvancedCache<K, V> cache;

    protected AbstractDelegatingAdvancedCache(AdvancedCache<K, V> cache) {
        super(cache);
        this.cache = cache;
    }

    @Override
    @Deprecated(forRemoval=true)
    public AsyncInterceptorChain getAsyncInterceptorChain() {
        return this.cache.getAsyncInterceptorChain();
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.cache.getEvictionManager();
    }

    @Override
    public ExpirationManager<K, V> getExpirationManager() {
        return this.cache.getExpirationManager();
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.cache.getComponentRegistry();
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.cache.getDistributionManager();
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.cache.getAuthorizationManager();
    }

    @Override
    public AdvancedCache<K, V> lockAs(Object lockOwner) {
        AdvancedCache<K, V> lockCache = this.cache.lockAs(lockOwner);
        if (lockCache != this.cache) {
            return this.rewrap(lockCache);
        }
        return this;
    }

    @Override
    public RpcManager getRpcManager() {
        return this.cache.getRpcManager();
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.cache.getBatchContainer();
    }

    @Override
    public DataContainer<K, V> getDataContainer() {
        return this.cache.getDataContainer();
    }

    public TransactionManager getTransactionManager() {
        return this.cache.getTransactionManager();
    }

    @Override
    public LockManager getLockManager() {
        return this.cache.getLockManager();
    }

    @Override
    public XAResource getXAResource() {
        return this.cache.getXAResource();
    }

    @Override
    public AvailabilityMode getAvailability() {
        return this.cache.getAvailability();
    }

    @Override
    public void setAvailability(AvailabilityMode availabilityMode) {
        this.cache.setAvailability(availabilityMode);
    }

    @ManagedAttribute(description="Returns the cache availability", displayName="Cache availability", dataType=DataType.TRAIT, writable=true)
    public String getCacheAvailability() {
        return this.getAvailability().toString();
    }

    public void setCacheAvailability(String availabilityString) {
        this.setAvailability(AvailabilityMode.valueOf(availabilityString));
    }

    @ManagedAttribute(description="Returns whether cache rebalancing is enabled", displayName="Cache rebalacing", dataType=DataType.TRAIT, writable=true)
    public boolean isRebalancingEnabled() {
        LocalTopologyManager localTopologyManager = this.getComponentRegistry().getComponent(LocalTopologyManager.class);
        if (localTopologyManager != null) {
            try {
                return localTopologyManager.isCacheRebalancingEnabled(this.getName());
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
        return false;
    }

    public void setRebalancingEnabled(boolean enabled) {
        LocalTopologyManager localTopologyManager = this.getComponentRegistry().getComponent(LocalTopologyManager.class);
        if (localTopologyManager != null) {
            try {
                localTopologyManager.setCacheRebalancingEnabled(this.getName(), enabled);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, boolean touchEvenIfExpired) {
        return this.cache.touch(key, touchEvenIfExpired);
    }

    @Override
    public CompletionStage<Boolean> touch(Object key, int segment, boolean touchEvenIfExpired) {
        return this.cache.touch(key, segment, touchEvenIfExpired);
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag flag) {
        AdvancedCache<K, V> flagCache = this.cache.withFlags(flag);
        if (flagCache != this.cache) {
            return this.rewrap(flagCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        AdvancedCache<K, V> flagCache = this.cache.withFlags(flags);
        if (flagCache != this.cache) {
            return this.rewrap(flagCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        AdvancedCache<K, V> flagCache = this.cache.withFlags(flags);
        if (flagCache != this.cache) {
            return this.rewrap(flagCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> noFlags() {
        AdvancedCache<K, V> flagCache = this.cache.noFlags();
        if (flagCache != this.cache) {
            return this.rewrap(flagCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> transform(Function<AdvancedCache<K, V>, ? extends AdvancedCache<K, V>> transformation) {
        AdvancedCache<K, V> newDelegate = this.cache.transform(transformation);
        AbstractDelegatingAdvancedCache newInstance = newDelegate != this.cache ? this.rewrap(newDelegate) : this;
        return transformation.apply(newInstance);
    }

    @Override
    public AdvancedCache<K, V> withSubject(Subject subject) {
        AdvancedCache<K, V> newDelegate = this.cache.withSubject(subject);
        if (newDelegate != this.cache) {
            return this.rewrap(newDelegate);
        }
        return this;
    }

    @Override
    public boolean lock(K ... key) {
        return this.cache.lock(key);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.cache.lock(keys);
    }

    @Override
    public Stats getStats() {
        return this.cache.getStats();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cache.getClassLoader();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return this;
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.cache.getAll(keys);
    }

    @Override
    public CacheEntry<K, V> getCacheEntry(Object key) {
        return this.cache.getCacheEntry(key);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> getCacheEntryAsync(Object key) {
        return this.cache.getCacheEntryAsync(key);
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.cache.getAllCacheEntries(keys);
    }

    @Override
    public Map<K, V> getAndPutAll(Map<? extends K, ? extends V> map) {
        return this.cache.getAndPutAll(map);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.cache.getGroup(groupName);
    }

    @Override
    public void removeGroup(String groupName) {
        this.cache.removeGroup(groupName);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.cache.put(key, value, metadata);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.cache.replace(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, Metadata metadata) {
        return this.cache.replaceAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> replaceAsyncEntry(K key, V value, Metadata metadata) {
        return this.cache.replaceAsyncEntry(key, value, metadata);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.cache.replace(key, oldValue, value, metadata);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return this.cache.replaceAsync(key, oldValue, newValue, metadata);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.cache.putIfAbsent(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, Metadata metadata) {
        return this.cache.putIfAbsentAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putIfAbsentAsyncEntry(K key, V value, Metadata metadata) {
        return this.cache.putIfAbsentAsyncEntry(key, value, metadata);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.cache.putAsync(key, value, metadata);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> putAsyncEntry(K key, V value, Metadata metadata) {
        return this.cache.putAsyncEntry(key, value, metadata);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.cache.putForExternalRead(key, value, metadata);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.cache.computeIfAbsent((K)key, mappingFunction, metadata);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.computeAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.computeIfPresentAsync((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        return this.cache.computeIfAbsentAsync((K)key, mappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        return this.cache.mergeAsync(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction, metadata);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeAsync(key, remappingFunction);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeAsync(key, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeIfPresentAsync(key, remappingFunction);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.cache.mergeAsync(key, value, remappingFunction);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.cache.putAll(map, metadata);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, Metadata metadata) {
        return this.cache.putAllAsync(map, metadata);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cache.cacheEntrySet();
    }

    @Override
    public LockedStream<K, V> lockedStream() {
        return this.cache.lockedStream();
    }

    @Override
    public CompletableFuture<Boolean> removeLifespanExpired(K key, V value, Long lifespan) {
        return this.cache.removeLifespanExpired(key, value, lifespan);
    }

    @Override
    public CompletableFuture<Boolean> removeMaxIdleExpired(K key, V value) {
        return this.cache.removeMaxIdleExpired(key, value);
    }

    @Override
    public AdvancedCache<?, ?> withEncoding(Class<? extends Encoder> encoder) {
        AdvancedCache<?, ?> encoderCache = this.cache.withEncoding(encoder);
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    @Override
    public AdvancedCache withEncoding(Class<? extends Encoder> keyEncoder, Class<? extends Encoder> valueEncoder) {
        AdvancedCache<?, ?> encoderCache = this.cache.withEncoding(keyEncoder, valueEncoder);
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<?, ?> withKeyEncoding(Class<? extends Encoder> encoder) {
        AdvancedCache<?, ?> encoderCache = this.cache.withKeyEncoding(encoder);
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    @Override
    @Deprecated(forRemoval=true)
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> wrapper) {
        AdvancedCache<K, V> encoderCache = this.cache.withWrapping(wrapper);
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<?, ?> withMediaType(String keyMediaType, String valueMediaType) {
        AdvancedCache<?, ?> encoderCache = this.cache.withMediaType(keyMediaType, valueMediaType);
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    @Override
    public <K1, V1> AdvancedCache<K1, V1> withMediaType(MediaType keyMediaType, MediaType valueMediaType) {
        AdvancedCache encoderCache = this.cache.withMediaType(keyMediaType, valueMediaType);
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> withStorageMediaType() {
        AdvancedCache<K, V> encoderCache = this.cache.withStorageMediaType();
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    @Override
    @Deprecated(forRemoval=true)
    public AdvancedCache<K, V> withWrapping(Class<? extends Wrapper> keyWrapper, Class<? extends Wrapper> valueWrapper) {
        AdvancedCache<K, V> encoderCache = this.cache.withWrapping(keyWrapper, valueWrapper);
        if (encoderCache != this.cache) {
            return this.rewrap(encoderCache);
        }
        return this;
    }

    public abstract AdvancedCache rewrap(AdvancedCache var1);

    @Override
    public DataConversion getKeyDataConversion() {
        return this.cache.getKeyDataConversion();
    }

    @Override
    public DataConversion getValueDataConversion() {
        return this.cache.getValueDataConversion();
    }

    @Override
    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.cache.getAllAsync(keys);
    }

    @Override
    public CompletableFuture<CacheEntry<K, V>> removeAsyncEntry(Object key) {
        return this.cache.removeAsyncEntry(key);
    }
}

