/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentSortedSet;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.SetType;

public class SortedSetType
extends SetType {
    private final Comparator<?> comparator;

    public SortedSetType(String role, String propertyRef, Comparator<?> comparator) {
        super(role, propertyRef);
        this.comparator = comparator;
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return CollectionClassification.SORTED_SET;
    }

    @Override
    public Class<?> getReturnedClass() {
        return SortedSet.class;
    }

    @Override
    public PersistentCollection<?> instantiate(SharedSessionContractImplementor session, CollectionPersister persister, Object key) {
        return new PersistentSortedSet(session, this.comparator);
    }

    @Override
    public Object instantiate(int anticipatedSize) {
        return new TreeSet(this.comparator);
    }

    @Override
    public PersistentCollection<?> wrap(SharedSessionContractImplementor session, Object collection) {
        return new PersistentSortedSet(session, (SortedSet)collection);
    }
}

