/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import java.util.List;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.support.DefaultBatchConfiguration;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.batch.BatchConversionServiceCustomizer;
import org.springframework.boot.autoconfigure.batch.BatchDataSource;
import org.springframework.boot.autoconfigure.batch.BatchDataSourceScriptDatabaseInitializer;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.batch.BatchTaskExecutor;
import org.springframework.boot.autoconfigure.batch.BatchTransactionManager;
import org.springframework.boot.autoconfigure.batch.JobExecutionExitCodeGenerator;
import org.springframework.boot.autoconfigure.batch.JobLauncherApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.autoconfigure.sql.init.OnDatabaseInitializationCondition;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.sql.init.dependency.DatabaseInitializationDependencyConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={HibernateJpaAutoConfiguration.class, TransactionAutoConfiguration.class})
@ConditionalOnClass(value={JobLauncher.class, DataSource.class, DatabasePopulator.class})
@ConditionalOnBean(value={DataSource.class, PlatformTransactionManager.class})
@ConditionalOnMissingBean(value={DefaultBatchConfiguration.class}, annotation={EnableBatchProcessing.class})
@EnableConfigurationProperties(value={BatchProperties.class})
@Import(value={DatabaseInitializationDependencyConfigurer.class})
public class BatchAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.batch.job", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public JobLauncherApplicationRunner jobLauncherApplicationRunner(JobLauncher jobLauncher, JobExplorer jobExplorer, JobRepository jobRepository, BatchProperties properties) {
        JobLauncherApplicationRunner runner = new JobLauncherApplicationRunner(jobLauncher, jobExplorer, jobRepository);
        String jobName = properties.getJob().getName();
        if (StringUtils.hasText((String)jobName)) {
            runner.setJobName(jobName);
        }
        return runner;
    }

    @Bean
    @ConditionalOnMissingBean(value={ExitCodeGenerator.class})
    public JobExecutionExitCodeGenerator jobExecutionExitCodeGenerator() {
        return new JobExecutionExitCodeGenerator();
    }

    static class OnBatchDatasourceInitializationCondition
    extends OnDatabaseInitializationCondition {
        OnBatchDatasourceInitializationCondition() {
            super("Batch", "spring.batch.jdbc.initialize-schema", "spring.batch.initialize-schema");
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={OnBatchDatasourceInitializationCondition.class})
    static class DataSourceInitializerConfiguration {
        DataSourceInitializerConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        BatchDataSourceScriptDatabaseInitializer batchDataSourceInitializer(DataSource dataSource, @BatchDataSource ObjectProvider<DataSource> batchDataSource, BatchProperties properties) {
            return new BatchDataSourceScriptDatabaseInitializer((DataSource)batchDataSource.getIfAvailable(() -> dataSource), properties.getJdbc());
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class SpringBootBatchConfiguration
    extends DefaultBatchConfiguration {
        private final DataSource dataSource;
        private final PlatformTransactionManager transactionManager;
        private final TaskExecutor taskExector;
        private final BatchProperties properties;
        private final List<BatchConversionServiceCustomizer> batchConversionServiceCustomizers;
        private final ExecutionContextSerializer executionContextSerializer;

        SpringBootBatchConfiguration(DataSource dataSource, @BatchDataSource ObjectProvider<DataSource> batchDataSource, PlatformTransactionManager transactionManager, @BatchTransactionManager ObjectProvider<PlatformTransactionManager> batchTransactionManager, @BatchTaskExecutor ObjectProvider<TaskExecutor> batchTaskExecutor, BatchProperties properties, ObjectProvider<BatchConversionServiceCustomizer> batchConversionServiceCustomizers, ObjectProvider<ExecutionContextSerializer> executionContextSerializer) {
            this.dataSource = (DataSource)batchDataSource.getIfAvailable(() -> dataSource);
            this.transactionManager = (PlatformTransactionManager)batchTransactionManager.getIfAvailable(() -> transactionManager);
            this.taskExector = (TaskExecutor)batchTaskExecutor.getIfAvailable();
            this.properties = properties;
            this.batchConversionServiceCustomizers = batchConversionServiceCustomizers.orderedStream().toList();
            this.executionContextSerializer = (ExecutionContextSerializer)executionContextSerializer.getIfAvailable();
        }

        protected DataSource getDataSource() {
            return this.dataSource;
        }

        protected PlatformTransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        protected String getTablePrefix() {
            String tablePrefix = this.properties.getJdbc().getTablePrefix();
            return tablePrefix != null ? tablePrefix : super.getTablePrefix();
        }

        protected Isolation getIsolationLevelForCreate() {
            Isolation isolation = this.properties.getJdbc().getIsolationLevelForCreate();
            return isolation != null ? isolation : super.getIsolationLevelForCreate();
        }

        protected ConfigurableConversionService getConversionService() {
            ConfigurableConversionService conversionService = super.getConversionService();
            for (BatchConversionServiceCustomizer customizer : this.batchConversionServiceCustomizers) {
                customizer.customize(conversionService);
            }
            return conversionService;
        }

        protected ExecutionContextSerializer getExecutionContextSerializer() {
            return this.executionContextSerializer != null ? this.executionContextSerializer : super.getExecutionContextSerializer();
        }

        protected TaskExecutor getTaskExecutor() {
            return this.taskExector != null ? this.taskExector : super.getTaskExecutor();
        }
    }
}

