/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Date;
import org.apache.activemq.artemis.core.management.impl.ActiveMQServerControlImpl;
import org.apache.activemq.artemis.core.management.impl.view.ActiveMQAbstractView;
import org.apache.activemq.artemis.core.management.impl.view.ConsumerField;
import org.apache.activemq.artemis.core.management.impl.view.predicate.ConsumerFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.utils.JsonLoader;

public class ConsumerView
extends ActiveMQAbstractView<ServerConsumer> {
    public static final String CONSUMER_STATUS_OK = "OK";
    public static final String CONSUMER_STATUS_ORPHANED = "Orphaned";
    private static final String defaultSortColumn = ConsumerField.ID.getName();
    private final ActiveMQServer server;

    public ConsumerView(ActiveMQServer server) {
        this.server = server;
        this.predicate = new ConsumerFilterPredicate(server);
    }

    @Override
    public Class getClassT() {
        return ServerConsumer.class;
    }

    @Override
    public JsonObjectBuilder toJson(ServerConsumer consumer) {
        ServerSession session = this.server.getSessionByID(consumer.getSessionID());
        ActiveMQServerControlImpl serverControl = this.server.getActiveMQServerControl();
        if (session == null) {
            return null;
        }
        JsonObjectBuilder obj = JsonLoader.createObjectBuilder().add(ConsumerField.ID.getName(), this.toString(consumer.getSequentialID())).add(ConsumerField.SESSION.getName(), this.toString(consumer.getSessionName())).add(ConsumerField.CLIENT_ID.getName(), this.toString(consumer.getConnectionClientID())).add(ConsumerField.USER.getName(), this.toString(session.getUsername())).add(ConsumerField.VALIDATED_USER.getName(), this.toString(session.getValidatedUser())).add(ConsumerField.PROTOCOL.getName(), this.toString(consumer.getConnectionProtocolName())).add(ConsumerField.QUEUE.getName(), this.toString(consumer.getQueueName())).add(ConsumerField.QUEUE_TYPE.getName(), this.toString(consumer.getQueueType()).toLowerCase()).add(ConsumerField.FILTER.getName(), this.toString(consumer.getFilterString())).add(ConsumerField.ADDRESS.getName(), this.toString(consumer.getQueueAddress())).add(ConsumerField.LOCAL_ADDRESS.getName(), this.toString(consumer.getConnectionLocalAddress())).add(ConsumerField.REMOTE_ADDRESS.getName(), this.toString(consumer.getConnectionRemoteAddress())).add(ConsumerField.CREATION_TIME.getName(), new Date(consumer.getCreationTime()).toString()).add(ConsumerField.MESSAGES_IN_TRANSIT.getName(), this.toString(consumer.getMessagesInTransit())).add(ConsumerField.MESSAGES_IN_TRANSIT_SIZE.getName(), this.toString(consumer.getMessagesInTransitSize())).add(ConsumerField.MESSAGES_DELIVERED.getName(), this.toString(consumer.getMessagesDelivered())).add(ConsumerField.MESSAGES_DELIVERED_SIZE.getName(), this.toString(consumer.getMessagesDeliveredSize())).add(ConsumerField.MESSAGES_ACKNOWLEDGED.getName(), this.toString(consumer.getMessagesAcknowledged())).add(ConsumerField.MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT.getName(), this.toString(consumer.getMessagesAcknowledgedAwaitingCommit())).add(ConsumerField.LAST_DELIVERED_TIME.getName(), consumer.getLastDeliveredTime()).add(ConsumerField.LAST_ACKNOWLEDGED_TIME.getName(), consumer.getLastAcknowledgedTime()).add(ConsumerField.STATUS.getName(), ConsumerView.checkConsumerStatus(consumer, this.server));
        return obj;
    }

    @Override
    public Object getField(ServerConsumer consumer, String fieldName) {
        ServerSession session = this.server.getSessionByID(consumer.getSessionID());
        if (session == null) {
            return null;
        }
        ConsumerField field = ConsumerField.valueOfName(fieldName);
        switch (field) {
            case ID: {
                return consumer.getSequentialID();
            }
            case SESSION: {
                return consumer.getSessionName();
            }
            case USER: {
                return session.getUsername();
            }
            case VALIDATED_USER: {
                return session.getValidatedUser();
            }
            case CLIENT_ID: {
                return consumer.getConnectionClientID();
            }
            case PROTOCOL: {
                return consumer.getConnectionProtocolName();
            }
            case QUEUE: {
                return consumer.getQueueName();
            }
            case QUEUE_TYPE: {
                return consumer.getQueueType();
            }
            case FILTER: {
                return consumer.getFilterString();
            }
            case LOCAL_ADDRESS: {
                return consumer.getConnectionLocalAddress();
            }
            case REMOTE_ADDRESS: {
                return consumer.getConnectionRemoteAddress();
            }
            case CREATION_TIME: {
                return new Date(consumer.getCreationTime());
            }
            case MESSAGES_IN_TRANSIT: {
                return consumer.getMessagesInTransit();
            }
            case MESSAGES_IN_TRANSIT_SIZE: {
                return consumer.getMessagesInTransitSize();
            }
            case MESSAGES_DELIVERED: {
                return consumer.getMessagesDelivered();
            }
            case MESSAGES_DELIVERED_SIZE: {
                return consumer.getMessagesDeliveredSize();
            }
            case MESSAGES_ACKNOWLEDGED: {
                return consumer.getMessagesAcknowledged();
            }
            case MESSAGES_ACKNOWLEDGED_AWAITING_COMMIT: {
                return consumer.getMessagesAcknowledgedAwaitingCommit();
            }
            case LAST_DELIVERED_TIME: {
                return consumer.getLastDeliveredTime();
            }
            case LAST_ACKNOWLEDGED_TIME: {
                return consumer.getLastAcknowledgedTime();
            }
            case STATUS: {
                return ConsumerView.checkConsumerStatus(consumer, this.server);
            }
        }
        throw new IllegalArgumentException("Unsupported field, " + fieldName);
    }

    public static String checkConsumerStatus(ServerConsumer consumer, ActiveMQServer server) {
        if (server.getRemotingService().getConnection(consumer.getConnectionID()) == null) {
            return CONSUMER_STATUS_ORPHANED;
        }
        return CONSUMER_STATUS_OK;
    }

    @Override
    public String getDefaultOrderColumn() {
        return defaultSortColumn;
    }
}

