/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.LineBorder;

public class JETALineBorder
extends LineBorder {
    private boolean m_top = true;
    private boolean m_left = true;
    private boolean m_bottom = true;
    private boolean m_right = true;

    public JETALineBorder() {
        super(Color.black);
    }

    public JETALineBorder(Color color, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(color, n, bl);
        this.m_top = bl2;
        this.m_left = bl3;
        this.m_bottom = bl4;
        this.m_right = bl5;
    }

    public Insets getBorderInsets(Component component) {
        if (this.getRoundedCorners()) {
            return super.getBorderInsets(component);
        }
        int n = this.getThickness();
        return new Insets(this.m_top ? n : 0, this.m_left ? n : 0, this.m_bottom ? n : 0, this.m_right ? n : 0);
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        if (this.getRoundedCorners()) {
            return super.getBorderInsets(component, insets);
        }
        insets.left = this.m_left ? this.thickness : 0;
        insets.top = this.m_top ? this.thickness : 0;
        insets.right = this.m_right ? this.thickness : 0;
        insets.bottom = this.m_bottom ? this.thickness : 0;
        return insets;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.getRoundedCorners() || this.m_top && this.m_bottom && this.m_right && this.m_left) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
        } else {
            Color color = graphics.getColor();
            graphics.setColor(this.lineColor);
            for (int i = 0; i < this.thickness; ++i) {
                int n5 = n2 + i;
                int n6 = n + i;
                int n7 = n6 + n3 - i - i - 1;
                int n8 = n5 + n4 - i - i - 1;
                if (this.m_top) {
                    graphics.drawLine(n, n5, n + n3 - 1, n5);
                }
                if (this.m_left) {
                    graphics.drawLine(n6, n2, n6, n2 + n4 - 1);
                }
                if (this.m_bottom) {
                    graphics.drawLine(n, n8, n + n3 - 1, n8);
                }
                if (!this.m_right) continue;
                graphics.drawLine(n7, n2, n7, n2 + n4 - 1);
            }
            graphics.setColor(color);
        }
    }
}

