/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.client.impl.Topology;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupRequestMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.BackupResponseMessage;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.cluster.ha.ColocatedHAManager;
import org.apache.activemq.artemis.core.server.cluster.ha.ColocatedPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.HAManager;
import org.apache.activemq.artemis.core.server.cluster.quorum.QuorumVote;
import org.apache.activemq.artemis.core.server.cluster.quorum.QuorumVoteHandler;
import org.apache.activemq.artemis.core.server.cluster.quorum.Vote;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.PrimaryActivation;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;

public class ColocatedActivation
extends PrimaryActivation {
    private static final SimpleString REQUEST_BACKUP_QUORUM_VOTE = new SimpleString("RequestBackupQuorumVote");
    private final ColocatedHAManager colocatedHAManager;
    private final ColocatedPolicy colocatedPolicy;
    PrimaryActivation primaryActivation;
    private final ActiveMQServerImpl server;

    public ColocatedActivation(ActiveMQServerImpl activeMQServer, ColocatedPolicy colocatedPolicy, PrimaryActivation primaryActivation) {
        this.server = activeMQServer;
        this.colocatedPolicy = colocatedPolicy;
        this.primaryActivation = primaryActivation;
        this.colocatedHAManager = new ColocatedHAManager(colocatedPolicy, this.server);
    }

    @Override
    public void haStarted() {
        this.server.getClusterManager().getQuorumManager().registerQuorumHandler(new RequestBackupQuorumVoteHandler());
        if (this.colocatedPolicy.isRequestBackup()) {
            this.server.getClusterManager().getQuorumManager().vote(new RequestBackupQuorumVote());
        }
    }

    @Override
    public void freezeConnections(RemotingService remotingService) {
        this.primaryActivation.freezeConnections(remotingService);
    }

    @Override
    public void postConnectionFreeze() {
        this.primaryActivation.postConnectionFreeze();
    }

    @Override
    public void preStorageClose() throws Exception {
        this.primaryActivation.preStorageClose();
    }

    @Override
    public void sendPrimaryIsStopping() {
        this.primaryActivation.sendPrimaryIsStopping();
    }

    @Override
    public ReplicationManager getReplicationManager() {
        return this.primaryActivation.getReplicationManager();
    }

    @Override
    public HAManager getHAManager() {
        return this.colocatedHAManager;
    }

    @Override
    public void run() {
        this.primaryActivation.run();
    }

    @Override
    public void close(boolean permanently, boolean restarting) throws Exception {
        this.primaryActivation.close(permanently, restarting);
    }

    @Override
    public ChannelHandler getActivationChannelHandler(final Channel channel, Acceptor acceptorUsed) {
        final ChannelHandler activationChannelHandler = this.primaryActivation.getActivationChannelHandler(channel, acceptorUsed);
        return new ChannelHandler(){

            public void handlePacket(Packet packet) {
                if (packet.getType() == 127) {
                    BackupRequestMessage backupRequestMessage = (BackupRequestMessage)packet;
                    boolean started = false;
                    try {
                        started = ColocatedActivation.this.colocatedHAManager.activateBackup(backupRequestMessage.getBackupSize(), backupRequestMessage.getJournalDirectory(), backupRequestMessage.getBindingsDirectory(), backupRequestMessage.getLargeMessagesDirectory(), backupRequestMessage.getPagingDirectory(), backupRequestMessage.getNodeID());
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.failedToActivateBackup(e);
                    }
                    channel.send((Packet)new BackupResponseMessage(started));
                } else if (activationChannelHandler != null) {
                    activationChannelHandler.handlePacket(packet);
                }
            }
        };
    }

    class RequestBackupVote
    extends Vote<Pair<String, Integer>> {
        private int backupsSize;
        private String nodeID;
        private boolean backupAvailable;

        RequestBackupVote() {
            this.backupsSize = -1;
        }

        RequestBackupVote(int backupsSize, String nodeID, boolean backupAvailable) {
            this.backupsSize = backupsSize;
            this.nodeID = nodeID;
            this.backupAvailable = backupAvailable;
        }

        @Override
        public void encode(ActiveMQBuffer buff) {
            buff.writeInt(this.backupsSize);
            buff.writeNullableString(this.nodeID);
            buff.writeBoolean(this.backupAvailable);
        }

        @Override
        public void decode(ActiveMQBuffer buff) {
            this.backupsSize = buff.readInt();
            this.nodeID = buff.readNullableString();
            this.backupAvailable = buff.readBoolean();
        }

        @Override
        public boolean isRequestServerVote() {
            return true;
        }

        @Override
        public Pair<String, Integer> getVote() {
            return new Pair((Object)this.nodeID, (Object)this.backupsSize);
        }

        public String toString() {
            return "RequestBackupVote [backupsSize=" + this.backupsSize + ", nodeID=" + this.nodeID + ", backupAvailable=" + this.backupAvailable + "]";
        }
    }

    private final class RequestBackupQuorumVote
    extends QuorumVote<RequestBackupVote, Pair<String, Integer>> {
        private final List<Pair<String, Integer>> nodes;

        private RequestBackupQuorumVote() {
            super(REQUEST_BACKUP_QUORUM_VOTE);
            this.nodes = new ArrayList<Pair<String, Integer>>();
        }

        @Override
        public Vote connected() {
            return new RequestBackupVote();
        }

        @Override
        public Vote notConnected() {
            return new RequestBackupVote();
        }

        @Override
        public void vote(RequestBackupVote vote) {
            if (vote.backupAvailable) {
                this.nodes.add(vote.getVote());
            }
        }

        @Override
        public Pair<String, Integer> getDecision() {
            Collections.sort(this.nodes, new Comparator<Pair<String, Integer>>(){

                @Override
                public int compare(Pair<String, Integer> o1, Pair<String, Integer> o2) {
                    return ((Integer)o1.getB()).compareTo((Integer)o2.getB());
                }
            });
            return this.nodes.get(0);
        }

        @Override
        public void allVotesCast(Topology voteTopology) {
            if (this.nodes.size() > 0) {
                Pair<String, Integer> decision = this.getDecision();
                TopologyMemberImpl member = voteTopology.getMember((String)decision.getA());
                try {
                    boolean backupStarted = ColocatedActivation.this.colocatedHAManager.requestBackup((Pair<TransportConfiguration, TransportConfiguration>)member.getConnector(), (Integer)decision.getB(), !ColocatedActivation.this.colocatedPolicy.isSharedStore());
                    if (!backupStarted) {
                        this.nodes.clear();
                        ColocatedActivation.this.server.getScheduledPool().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ColocatedActivation.this.server.getClusterManager().getQuorumManager().vote(new RequestBackupQuorumVote());
                            }
                        }, ColocatedActivation.this.colocatedPolicy.getBackupRequestRetryInterval(), TimeUnit.MILLISECONDS);
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToSendRequestToNode(e);
                }
            } else {
                this.nodes.clear();
                ColocatedActivation.this.server.getScheduledPool().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ColocatedActivation.this.server.getClusterManager().getQuorumManager().vote(RequestBackupQuorumVote.this);
                    }
                }, ColocatedActivation.this.colocatedPolicy.getBackupRequestRetryInterval(), TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public SimpleString getName() {
            return REQUEST_BACKUP_QUORUM_VOTE;
        }
    }

    private final class RequestBackupQuorumVoteHandler
    implements QuorumVoteHandler {
        private RequestBackupQuorumVoteHandler() {
        }

        @Override
        public Vote vote(Vote vote) {
            int size = ColocatedActivation.this.colocatedHAManager.getBackupServers().size();
            return new RequestBackupVote(size, ColocatedActivation.this.server.getNodeID().toString(), size < ColocatedActivation.this.colocatedPolicy.getMaxBackups());
        }

        @Override
        public SimpleString getQuorumName() {
            return REQUEST_BACKUP_QUORUM_VOTE;
        }

        @Override
        public Vote decode(ActiveMQBuffer voteBuffer) {
            RequestBackupVote requestBackupVote = new RequestBackupVote();
            requestBackupVote.decode(voteBuffer);
            return requestBackupVote;
        }
    }
}

