/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.util;

import de.schlichtherle.truezip.util.CanonicalStringSet;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;

public final class SuffixSet
extends CanonicalStringSet {
    public static final char SEPARATOR = '|';
    public static final char PREFIX = '.';

    public SuffixSet() {
        super(new SuffixMapper(), '|');
    }

    public SuffixSet(String suffixes) {
        super(new SuffixMapper(), '|');
        super.addAll(suffixes);
    }

    public SuffixSet(Collection<String> c) {
        super(new SuffixMapper(), '|');
        super.addAll(c);
    }

    public Pattern toPattern() {
        Iterator<String> i = this.iterator();
        if (i.hasNext()) {
            StringBuilder sb = new StringBuilder(".*\\.(?i)(");
            int c = 0;
            do {
                String suffix = i.next();
                if (0 < c++) {
                    sb.append('|');
                }
                sb.append("\\Q").append(suffix).append("\\E");
            } while (i.hasNext());
            assert (0 < c);
            return Pattern.compile(sb.append(")[\\").append(File.separatorChar).append("/]*").toString());
        }
        return Pattern.compile("\\00");
    }

    private static class SuffixMapper
    implements CanonicalStringSet.Canonicalizer {
        private SuffixMapper() {
        }

        @Override
        public String map(Object o) {
            String suffix = o.toString();
            while (0 < suffix.length() && suffix.charAt(0) == '.') {
                suffix = suffix.substring(1);
            }
            return suffix.toLowerCase(Locale.ROOT);
        }
    }
}

