/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client.diagnostics.analyzer;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.cloud.config.client.validation.InvalidApplicationNameException;

public class InvalidApplicationNameExceptionFailureAnalyzer
extends AbstractFailureAnalyzer<InvalidApplicationNameException> {
    protected FailureAnalysis analyze(Throwable rootFailure, InvalidApplicationNameException cause) {
        StringBuilder description = new StringBuilder(String.format("%s:%n", cause.getMessage()));
        description.append(String.format("%n    Property: %s", cause.getProperty()));
        description.append(String.format("%n    Value: %s", cause.getValue()));
        String action = "Change ${spring.application.name} or the ${spring.cloud.config.name} override so that it does not begin with 'application-'.";
        return new FailureAnalysis(description.toString(), action, (Throwable)cause);
    }
}

