/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.AbstractSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpressionHelper;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ExtractFunction
extends AbstractSqmFunctionDescriptor
implements FunctionRenderer {
    private final Dialect dialect;

    public ExtractFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super("extract", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(2), FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL), StandardFunctionReturnTypeResolvers.useArgType(1), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        ExtractUnit field = (ExtractUnit)sqlAstArguments.get(0);
        TemporalUnit unit = field.getUnit();
        String pattern = this.dialect.extractPattern(unit);
        new PatternRenderer(pattern).render(sqlAppender, sqlAstArguments, walker);
    }

    protected <T> SelfRenderingSqmFunction generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        SqmExtractUnit field = (SqmExtractUnit)arguments.get(0);
        SqmExpression originalExpression = (SqmExpression)arguments.get(1);
        boolean compositeTemporal = SqmExpressionHelper.isCompositeTemporal(originalExpression);
        SqmExpression<?> expression = SqmExpressionHelper.getOffsetAdjustedExpression(originalExpression);
        TemporalUnit unit = field.getUnit();
        switch (unit) {
            case NANOSECOND: {
                return this.extractNanoseconds(expression, queryEngine);
            }
            case NATIVE: {
                throw new SemanticException("NATIVE is not a legal field for extract()");
            }
            case OFFSET: {
                if (compositeTemporal) {
                    JpaPath offsetPath = ((SqmPath)originalExpression).get("zoneOffset");
                    return new SelfRenderingSqmFunction((SqmFunctionDescriptor)this, (sqlAppender, sqlAstArguments, returnType, walker) -> ((SqlAstNode)sqlAstArguments.get(0)).accept(walker), Collections.singletonList(offsetPath), null, null, StandardFunctionReturnTypeResolvers.useArgType(1), expression.nodeBuilder(), "extract");
                }
                return this.extractOffsetUsingFormat(expression, queryEngine);
            }
            case DATE: 
            case TIME: {
                return this.extractDateOrTimeUsingCast(expression, field.getType(), queryEngine);
            }
            case WEEK_OF_MONTH: {
                return this.extractWeek(expression, field, TemporalUnit.DAY_OF_MONTH, queryEngine);
            }
            case WEEK_OF_YEAR: {
                return this.extractWeek(expression, field, TemporalUnit.DAY_OF_YEAR, queryEngine);
            }
        }
        return new SelfRenderingSqmFunction<T>((SqmFunctionDescriptor)this, this, expression == originalExpression ? arguments : List.of(arguments.get(0), expression), impliedResultType, this.getArgumentsValidator(), this.getReturnTypeResolver(), expression.nodeBuilder(), "extract");
    }

    private SelfRenderingSqmFunction<Integer> extractWeek(SqmExpression<?> expressionToExtract, SqmExtractUnit<?> field, TemporalUnit dayOf, QueryEngine queryEngine) {
        NodeBuilder builder = field.nodeBuilder();
        TypeConfiguration typeConfiguration = queryEngine.getTypeConfiguration();
        BasicType<Integer> intType = typeConfiguration.getBasicTypeForJavaType(Integer.class);
        BasicType<Float> floatType = typeConfiguration.getBasicTypeForJavaType(Float.class);
        SqmExtractUnit<Integer> dayOfUnit = new SqmExtractUnit<Integer>(dayOf, intType, builder);
        SelfRenderingSqmFunction<Integer> extractDayOf = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(dayOfUnit, expressionToExtract), intType, queryEngine);
        SqmExtractUnit<Integer> dayOfWeekUnit = new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_WEEK, intType, builder);
        SelfRenderingSqmFunction<Integer> extractDayOfWeek = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(dayOfWeekUnit, expressionToExtract), intType, queryEngine);
        SqmLiteral<Float> seven = new SqmLiteral<Float>(Float.valueOf(7.0f), floatType, builder);
        SqmLiteral<Integer> one = new SqmLiteral<Integer>(1, intType, builder);
        SqmBinaryArithmetic<Integer> daySubtractionInt = new SqmBinaryArithmetic<Integer>(BinaryArithmeticOperator.SUBTRACT, extractDayOf, extractDayOfWeek, intType, builder);
        AbstractSqmExpression daySubtraction = this.dialect.requiresFloatCastingOfIntegerDivision() ? queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(daySubtractionInt, new SqmCastTarget<Float>(floatType, builder)), floatType, queryEngine) : daySubtractionInt;
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("ceiling").generateSqmExpression(new SqmBinaryArithmetic<Integer>(BinaryArithmeticOperator.ADD, new SqmBinaryArithmetic<Float>(BinaryArithmeticOperator.DIVIDE, daySubtraction, seven, floatType, builder), one, intType, builder), intType, queryEngine);
    }

    private SelfRenderingSqmFunction<Long> toLong(SqmExpression<?> arg, QueryEngine queryEngine) {
        BasicType<Long> longType = queryEngine.getTypeConfiguration().getBasicTypeForJavaType(Long.class);
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("floor").generateSqmExpression(arg, longType, queryEngine);
    }

    private SelfRenderingSqmFunction<Long> extractNanoseconds(SqmExpression<?> expressionToExtract, QueryEngine queryEngine) {
        NodeBuilder builder = expressionToExtract.nodeBuilder();
        TypeConfiguration typeConfiguration = queryEngine.getTypeConfiguration();
        BasicType<Float> floatType = typeConfiguration.getBasicTypeForJavaType(Float.class);
        SqmExtractUnit<Float> extractSeconds = new SqmExtractUnit<Float>(TemporalUnit.SECOND, floatType, builder);
        SqmLiteral<Float> billion = new SqmLiteral<Float>(Float.valueOf(1.0E9f), floatType, builder);
        return this.toLong(new SqmBinaryArithmetic<Float>(BinaryArithmeticOperator.MULTIPLY, this.generateSqmExpression(Arrays.asList(extractSeconds, expressionToExtract), floatType, queryEngine), billion, floatType, builder), queryEngine);
    }

    private SelfRenderingSqmFunction<ZoneOffset> extractOffsetUsingFormat(SqmExpression<?> expressionToExtract, QueryEngine queryEngine) {
        NodeBuilder builder = expressionToExtract.nodeBuilder();
        TypeConfiguration typeConfiguration = queryEngine.getTypeConfiguration();
        BasicType<ZoneOffset> offsetType = typeConfiguration.getBasicTypeForJavaType(ZoneOffset.class);
        BasicType<String> stringType = typeConfiguration.getBasicTypeForJavaType(String.class);
        SqmFormat offsetFormat = new SqmFormat("xxx", (SqmExpressible<String>)stringType, builder);
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("format").generateSqmExpression(Arrays.asList(expressionToExtract, offsetFormat), offsetType, queryEngine);
    }

    private SelfRenderingSqmFunction<?> extractDateOrTimeUsingCast(SqmExpression<?> expressionToExtract, ReturnableType<?> type, QueryEngine queryEngine) {
        NodeBuilder builder = expressionToExtract.nodeBuilder();
        SqmCastTarget target = new SqmCastTarget(type, builder);
        return queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(expressionToExtract, target), type, queryEngine);
    }

    @Override
    public String getArgumentListSignature() {
        return "(TEMPORAL_UNIT field from TEMPORAL arg)";
    }
}

