/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.data;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.DataValueFactory;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import com.vladsch.flexmark.util.data.NullableDataKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableDataSet
extends DataSet
implements MutableDataHolder {
    public MutableDataSet() {
    }

    public MutableDataSet(DataHolder other) {
        super(other);
    }

    @Override
    @NotNull
    public <T> MutableDataSet set(@NotNull DataKey<T> key, @NotNull T value) {
        return this.set((DataKeyBase<T>)key, value);
    }

    @Override
    @NotNull
    public <T> MutableDataSet set(@NotNull NullableDataKey<T> key, @Nullable T value) {
        return this.set((DataKeyBase<T>)key, value);
    }

    private <T> MutableDataSet set(@NotNull DataKeyBase<T> key, T value) {
        this.dataSet.put(key, value);
        return this;
    }

    @Override
    @NotNull
    public MutableDataSet setFrom(@NotNull MutableDataSetter dataSetter) {
        dataSetter.setIn(this);
        return this;
    }

    @Override
    @NotNull
    public MutableDataSet setAll(@NotNull DataHolder other) {
        this.dataSet.putAll(other.getAll());
        return this;
    }

    public static MutableDataSet merge(DataHolder ... dataHolders) {
        MutableDataSet dataSet = new MutableDataSet();
        for (DataHolder dataHolder : dataHolders) {
            if (dataHolder == null) continue;
            dataSet.dataSet.putAll(dataHolder.getAll());
        }
        return dataSet;
    }

    @Override
    @NotNull
    public MutableDataHolder setIn(@NotNull MutableDataHolder dataHolder) {
        dataHolder.setAll(this);
        return dataHolder;
    }

    @Override
    @NotNull
    public MutableDataSet remove(@NotNull DataKeyBase<?> key) {
        this.dataSet.remove(key);
        return this;
    }

    @Override
    @Nullable
    public Object getOrCompute(@NotNull DataKeyBase<?> key, @NotNull DataValueFactory<?> factory) {
        if (this.dataSet.containsKey(key)) {
            return this.dataSet.get(key);
        }
        Object value = factory.apply(this);
        this.dataSet.put(key, value);
        return value;
    }

    @Override
    @NotNull
    public MutableDataSet toMutable() {
        return this;
    }

    @Override
    @NotNull
    public DataSet toImmutable() {
        return new DataSet(this);
    }

    @Override
    @NotNull
    public MutableDataSet toDataSet() {
        return this;
    }

    @Override
    @NotNull
    public MutableDataSet clear() {
        this.dataSet.clear();
        return this;
    }
}

