/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.parser;

import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.InlineParserFactory;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.parser.PostProcessorFactory;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.CustomBlockParserFactory;
import com.vladsch.flexmark.parser.block.ParagraphPreProcessorFactory;
import com.vladsch.flexmark.parser.delimiter.DelimiterProcessor;
import com.vladsch.flexmark.parser.internal.DocumentParser;
import com.vladsch.flexmark.parser.internal.InlineParserImpl;
import com.vladsch.flexmark.parser.internal.LinkRefProcessorData;
import com.vladsch.flexmark.parser.internal.PostProcessorManager;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.IParse;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeRepository;
import com.vladsch.flexmark.util.builder.BuilderBase;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.DataSet;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.SharedDataKeys;
import com.vladsch.flexmark.util.misc.Extension;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.ReplacedBasedSequence;
import com.vladsch.flexmark.util.sequence.mappers.SpecialLeadInHandler;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parser
implements IParse {
    public static final DataKey<Collection<Extension>> EXTENSIONS = SharedDataKeys.EXTENSIONS;
    public static final DataKey<KeepType> REFERENCES_KEEP = new DataKey("REFERENCES_KEEP", (Object)KeepType.FIRST);
    public static final DataKey<ReferenceRepository> REFERENCES = new DataKey("REFERENCES", (Object)new ReferenceRepository(null), ReferenceRepository::new);
    public static final DataKey<Boolean> ASTERISK_DELIMITER_PROCESSOR = new DataKey("ASTERISK_DELIMITER_PROCESSOR", (Object)true);
    public static final DataKey<Boolean> TRACK_DOCUMENT_LINES = new DataKey("TRACK_DOCUMENT_LINES", (Object)false);
    public static final DataKey<Boolean> BLOCK_QUOTE_PARSER = new DataKey("BLOCK_QUOTE_PARSER", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_EXTEND_TO_BLANK_LINE = new DataKey("BLOCK_QUOTE_EXTEND_TO_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> BLOCK_QUOTE_IGNORE_BLANK_LINE = new DataKey("BLOCK_QUOTE_IGNORE_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> BLOCK_QUOTE_ALLOW_LEADING_SPACE = new DataKey("BLOCK_QUOTE_ALLOW_LEADING_SPACE", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_INTERRUPTS_PARAGRAPH = new DataKey("BLOCK_QUOTE_INTERRUPTS_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("BLOCK_QUOTE_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> BLOCK_QUOTE_WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("BLOCK_QUOTE_WITH_LEAD_SPACES_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_BLOCK_PARSER = new DataKey("FENCED_CODE_BLOCK_PARSER", (Object)true);
    public static final DataKey<Boolean> MATCH_CLOSING_FENCE_CHARACTERS = new DataKey("MATCH_CLOSING_FENCE_CHARACTERS", (Object)true);
    public static final DataKey<Boolean> FENCED_CODE_CONTENT_BLOCK = new DataKey("FENCED_CODE_CONTENT_BLOCK", (Object)false);
    public static final DataKey<Boolean> CODE_SOFT_LINE_BREAKS = new DataKey("CODE_SOFT_LINE_BREAKS", (Object)false);
    public static final DataKey<Boolean> HARD_LINE_BREAK_LIMIT = new DataKey("HARD_LINE_BREAK_LIMIT", (Object)false);
    public static final DataKey<Boolean> HEADING_PARSER = new DataKey("HEADING_PARSER", (Object)true);
    public static final DataKey<Integer> HEADING_SETEXT_MARKER_LENGTH = new DataKey("HEADING_SETEXT_MARKER_LENGTH", (Object)1);
    public static final DataKey<Boolean> HEADING_NO_ATX_SPACE = SharedDataKeys.HEADING_NO_ATX_SPACE;
    public static final DataKey<Boolean> ESCAPE_HEADING_NO_ATX_SPACE = SharedDataKeys.ESCAPE_HEADING_NO_ATX_SPACE;
    public static final DataKey<Boolean> HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE = new DataKey("HEADING_NO_EMPTY_HEADING_WITHOUT_SPACE", (Object)false);
    public static final DataKey<Boolean> HEADING_NO_LEAD_SPACE = new DataKey("HEADING_NO_LEAD_SPACE", (Object)false);
    public static final DataKey<Boolean> HEADING_CAN_INTERRUPT_ITEM_PARAGRAPH = new DataKey("HEADING_CAN_INTERRUPT_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_PARSER = new DataKey("HTML_BLOCK_PARSER", (Object)true);
    public static final DataKey<Boolean> HTML_COMMENT_BLOCKS_INTERRUPT_PARAGRAPH = new DataKey("HTML_COMMENT_BLOCKS_INTERRUPT_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> HTML_FOR_TRANSLATOR = SharedDataKeys.HTML_FOR_TRANSLATOR;
    public static final DataKey<Boolean> INLINE_DELIMITER_DIRECTIONAL_PUNCTUATIONS = new DataKey("INLINE_DELIMITER_DIRECTIONAL_PUNCTUATIONS", (Object)false);
    public static final DataKey<Boolean> INDENTED_CODE_BLOCK_PARSER = new DataKey("INDENTED_CODE_BLOCK_PARSER", (Object)true);
    public static final DataKey<Boolean> INDENTED_CODE_NO_TRAILING_BLANK_LINES = new DataKey("INDENTED_CODE_NO_TRAILING_BLANK_LINES", (Object)true);
    public static final DataKey<Boolean> INTELLIJ_DUMMY_IDENTIFIER = SharedDataKeys.INTELLIJ_DUMMY_IDENTIFIER;
    public static final DataKey<Boolean> MATCH_NESTED_LINK_REFS_FIRST = new DataKey("MATCH_NESTED_LINK_REFS_FIRST", (Object)true);
    public static final DataKey<Boolean> PARSE_INNER_HTML_COMMENTS = SharedDataKeys.PARSE_INNER_HTML_COMMENTS;
    public static final DataKey<Boolean> PARSE_MULTI_LINE_IMAGE_URLS = new DataKey("PARSE_MULTI_LINE_IMAGE_URLS", (Object)false);
    public static final DataKey<Boolean> PARSE_JEKYLL_MACROS_IN_URLS = new DataKey("PARSE_JEKYLL_MACROS_IN_URLS", (Object)false);
    public static final DataKey<Boolean> SPACE_IN_LINK_URLS = new DataKey("SPACE_IN_LINK_URLS", (Object)false);
    public static final DataKey<Boolean> SPACE_IN_LINK_ELEMENTS = new DataKey("SPACE_IN_LINK_ELEMENTS", (Object)false);
    public static final DataKey<Boolean> WWW_AUTO_LINK_ELEMENT = new DataKey("WWW_AUTO_LINK_ELEMENT", (Object)false);
    public static final DataKey<Boolean> REFERENCE_PARAGRAPH_PRE_PROCESSOR = new DataKey("REFERENCE_BLOCK_PRE_PROCESSOR", (Object)true);
    public static final DataKey<Boolean> THEMATIC_BREAK_PARSER = new DataKey("THEMATIC_BREAK_PARSER", (Object)true);
    public static final DataKey<Boolean> THEMATIC_BREAK_RELAXED_START = new DataKey("THEMATIC_BREAK_RELAXED_START", (Object)true);
    public static final DataKey<Boolean> UNDERSCORE_DELIMITER_PROCESSOR = new DataKey("UNDERSCORE_DELIMITER_PROCESSOR", (Object)true);
    public static final DataKey<Boolean> BLANK_LINES_IN_AST = SharedDataKeys.BLANK_LINES_IN_AST;
    public static final DataKey<Boolean> USE_HARDCODED_LINK_ADDRESS_PARSER = new DataKey("USE_HARDCODED_LINK_ADDRESS_PARSER", (Object)true);
    public static final DataKey<Boolean> STRONG_WRAPS_EMPHASIS = new DataKey("STRONG_WRAPS_EMPHASIS", (Object)false);
    public static final DataKey<Boolean> LINKS_ALLOW_MATCHED_PARENTHESES = new DataKey("LINKS_ALLOW_MATCHED_PARENTHESES", (Object)true);
    public static final DataKey<Boolean> LIST_BLOCK_PARSER = new DataKey("LIST_BLOCK_PARSER", (Object)true);
    public static final DataKey<ParserEmulationProfile> PARSER_EMULATION_PROFILE = new DataKey("PARSER_EMULATION_PROFILE", (Object)ParserEmulationProfile.COMMONMARK);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSER = new DataKey("HTML_BLOCK_DEEP_PARSER", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_NON_BLOCK = new DataKey("HTML_BLOCK_DEEP_PARSE_NON_BLOCK", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_COMMENT_ONLY_FULL_LINE = new DataKey("HTML_BLOCK_COMMENT_ONLY_FULL_LINE", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_START_ONLY_ON_BLOCK_TAGS = new DataKey("HTML_BLOCK_START_ONLY_ON_BLOCK_TAGS", HTML_BLOCK_DEEP_PARSER);
    public static final DataKey<List<String>> HTML_BLOCK_TAGS = new DataKey("HTML_BLOCK_TAGS", Arrays.asList("address", "article", "aside", "base", "basefont", "blockquote", "body", "caption", "center", "col", "colgroup", "dd", "details", "dialog", "dir", "div", "dl", "dt", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hr", "html", "iframe", "legend", "li", "link", "main", "math", "menu", "menuitem", "meta", "nav", "noframes", "ol", "optgroup", "option", "p", "param", "section", "source", "summary", "table", "tbody", "td", "tfoot", "th", "thead", "title", "tr", "track", "ul"));
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS = new DataKey("HTML_BL OCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_FIRST_OPEN_TAG_ON_ONE_LINE = new DataKey("HTML_BL HTML_BLOCK_DEEP_PARSE_FIRST_OPEN_TAG_ON_ONE_LINE", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_MARKDOWN_INTERRUPTS_CLOSED = new DataKey("HTML_BLOCK_DEEP_PARSE_MARKDOWN_INTERRUPTS_CLOSED", (Object)false);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS_PARTIAL_TAG = new DataKey("HTML_BLOCK_DEEP_PARSE_BLANK_LINE_INTERRUPTS_PARTIAL_TAG", (Object)true);
    public static final DataKey<Boolean> HTML_BLOCK_DEEP_PARSE_INDENTED_CODE_INTERRUPTS = new DataKey("HTML_BLOCK_DEEP_PARSE_INDENTED_CODE_INTERRUPTS", (Object)false);
    public static final DataKey<String> TRANSLATION_HTML_BLOCK_TAG_PATTERN = SharedDataKeys.TRANSLATION_HTML_BLOCK_TAG_PATTERN;
    public static final DataKey<String> TRANSLATION_HTML_INLINE_TAG_PATTERN = SharedDataKeys.TRANSLATION_HTML_INLINE_TAG_PATTERN;
    public static final DataKey<String> TRANSLATION_AUTOLINK_TAG_PATTERN = SharedDataKeys.TRANSLATION_AUTOLINK_TAG_PATTERN;
    public static final DataKey<Integer> LISTS_CODE_INDENT = new DataKey("LISTS_CODE_INDENT", (Object)4);
    public static final DataKey<Integer> LISTS_ITEM_INDENT = new DataKey("LISTS_ITEM_INDENT", (Object)4);
    public static final DataKey<Integer> LISTS_NEW_ITEM_CODE_INDENT = new DataKey("LISTS_NEW_ITEM_CODE_INDENT", (Object)4);
    public static final DataKey<Boolean> LISTS_ITEM_MARKER_SPACE = new DataKey("LISTS_ITEM_MARKER_SPACE", (Object)false);
    public static final DataKey<String[]> LISTS_ITEM_MARKER_SUFFIXES = new DataKey("LISTS_ITEM_MARKER_SUFFIXES", (Object)new String[0]);
    public static final DataKey<Boolean> LISTS_NUMBERED_ITEM_MARKER_SUFFIXED = new DataKey("LISTS_NUMBERED_ITEM_MARKER_SUFFIXED", (Object)true);
    public static final DataKey<Boolean> LISTS_AUTO_LOOSE = new DataKey("LISTS_AUTO_LOOSE", (Object)true);
    public static final DataKey<Boolean> LISTS_AUTO_LOOSE_ONE_LEVEL_LISTS = new DataKey("LISTS_AUTO_LOOSE_ONE_LEVEL_LISTS", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_PREV_HAS_TRAILING_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_PREV_HAS_TRAILING_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_LAST_ITEM_PREV_HAS_TRAILING_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_LAST_ITEM_PREV_HAS_TRAILING_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN = new DataKey("LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_BLANK_LINE_FOLLOWS_ITEM_PARAGRAPH = new DataKey("LISTS_LOOSE_WHEN_BLANK_LINE_FOLLOWS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_HAS_LOOSE_SUB_ITEM = new DataKey("LISTS_LOOSE_WHEN_HAS_LOOSE_SUB_ITEM", (Object)false);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_HAS_TRAILING_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_HAS_TRAILING_BLANK_LINE", (Object)true);
    public static final DataKey<Boolean> LISTS_LOOSE_WHEN_CONTAINS_BLANK_LINE = new DataKey("LISTS_LOOSE_WHEN_CONTAINS_BLANK_LINE", (Object)false);
    public static final DataKey<Boolean> LISTS_DELIMITER_MISMATCH_TO_NEW_LIST = new DataKey("LISTS_DELIMITER_MISMATCH_TO_NEW_LIST", (Object)true);
    public static final DataKey<Boolean> LISTS_END_ON_DOUBLE_BLANK = new DataKey("LISTS_END_ON_DOUBLE_BLANK", (Object)false);
    public static final DataKey<Boolean> LISTS_ITEM_TYPE_MISMATCH_TO_NEW_LIST = new DataKey("LISTS_ITEM_TYPE_MISMATCH_TO_NEW_LIST", (Object)true);
    public static final DataKey<Boolean> LISTS_ITEM_TYPE_MISMATCH_TO_SUB_LIST = new DataKey("LISTS_ITEM_TYPE_MISMATCH_TO_SUB_LIST", (Object)false);
    public static final DataKey<Boolean> LISTS_ORDERED_ITEM_DOT_ONLY = new DataKey("LISTS_ORDERED_ITEM_DOT_ONLY", (Object)false);
    public static final DataKey<Boolean> LISTS_ORDERED_LIST_MANUAL_START = new DataKey("LISTS_ORDERED_LIST_MANUAL_START", (Object)true);
    public static final DataKey<Boolean> LISTS_ITEM_CONTENT_AFTER_SUFFIX = new DataKey("LISTS_ITEM_CONTENT_AFTER_SUFFIX", (Object)false);
    public static final DataKey<Boolean> LISTS_BULLET_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_BULLET_ITEM_INTERRUPTS_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_ORDERED_ITEM_INTERRUPTS_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_BULLET_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_NON_ONE_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)true);
    public static final DataKey<Boolean> LISTS_EMPTY_BULLET_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_BULLET_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<Boolean> LISTS_EMPTY_ORDERED_NON_ONE_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH = new DataKey("LISTS_EMPTY_ORDERED_NON_ONE_SUB_ITEM_INTERRUPTS_ITEM_PARAGRAPH", (Object)false);
    public static final DataKey<String> LISTS_ITEM_PREFIX_CHARS = new DataKey("LISTS_ITEM_PREFIX_CHARS", (Object)"+*-");
    public static final DataKey<List<SpecialLeadInHandler>> SPECIAL_LEAD_IN_HANDLERS = new DataKey("SPECIAL_LEAD_IN_HANDLERS", Collections.emptyList());
    public static final DataKey<Integer> CODE_BLOCK_INDENT = new DataKey("CODE_BLOCK_INDENT", LISTS_ITEM_INDENT);
    private final List<CustomBlockParserFactory> blockParserFactories;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private final BitSet delimiterCharacters;
    private final BitSet specialCharacters;
    private final List<PostProcessorManager.PostProcessorDependencyStage> postProcessorDependencies;
    private final List<List<ParagraphPreProcessorFactory>> paragraphPreProcessorFactories;
    private final List<List<BlockPreProcessorFactory>> blockPreProcessorDependencies;
    private final LinkRefProcessorData linkRefProcessors;
    private final List<InlineParserExtensionFactory> inlineParserExtensionFactories;
    private final InlineParserFactory inlineParserFactory;
    private final DataHolder options;

    Parser(Builder builder) {
        DataSet options = builder.toImmutable();
        this.blockParserFactories = DocumentParser.calculateBlockParserFactories((DataHolder)options, builder.blockParserFactories);
        ArrayList<SpecialLeadInHandler> specialLeadInHandlers = new ArrayList<SpecialLeadInHandler>(builder.specialLeadInHandlers);
        for (CustomBlockParserFactory factory : this.blockParserFactories) {
            SpecialLeadInHandler escaper = factory.getLeadInHandler((DataHolder)options);
            if (escaper == null) continue;
            specialLeadInHandlers.add(escaper);
        }
        MutableDataSet optionsWithSpecialLeadInHandlers = new MutableDataSet((DataHolder)builder);
        optionsWithSpecialLeadInHandlers.set(SPECIAL_LEAD_IN_HANDLERS, specialLeadInHandlers);
        this.options = optionsWithSpecialLeadInHandlers.toImmutable();
        this.inlineParserFactory = builder.inlineParserFactory == null ? DocumentParser.INLINE_PARSER_FACTORY : builder.inlineParserFactory;
        this.paragraphPreProcessorFactories = DocumentParser.calculateParagraphPreProcessors((DataHolder)options, builder.paragraphPreProcessorFactories, this.inlineParserFactory);
        this.blockPreProcessorDependencies = DocumentParser.calculateBlockPreProcessors((DataHolder)options, builder.blockPreProcessorFactories);
        this.delimiterProcessors = InlineParserImpl.calculateDelimiterProcessors((DataHolder)options, builder.delimiterProcessors);
        this.delimiterCharacters = InlineParserImpl.calculateDelimiterCharacters((DataHolder)options, this.delimiterProcessors.keySet());
        this.linkRefProcessors = InlineParserImpl.calculateLinkRefProcessors((DataHolder)options, builder.linkRefProcessors);
        this.specialCharacters = InlineParserImpl.calculateSpecialCharacters((DataHolder)options, this.delimiterCharacters);
        this.postProcessorDependencies = PostProcessorManager.calculatePostProcessors((DataHolder)options, builder.postProcessorFactories);
        this.inlineParserExtensionFactories = builder.inlineParserExtensionFactories;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(DataHolder options) {
        return new Builder(options);
    }

    @NotNull
    public Document parse(@NotNull BasedSequence input) {
        if (input instanceof ReplacedBasedSequence) {
            throw new IllegalArgumentException("Parser.parse() does not support BasedSequences with replaced or non-contiguous segments.\nUse BasedSequence.of(input.toString()) to convert to contiguous based sequence.");
        }
        DocumentParser documentParser = new DocumentParser(this.options, this.blockParserFactories, this.paragraphPreProcessorFactories, this.blockPreProcessorDependencies, this.inlineParserFactory.inlineParser(this.options, this.specialCharacters, this.delimiterCharacters, this.delimiterProcessors, this.linkRefProcessors, this.inlineParserExtensionFactories));
        Document document = documentParser.parse((CharSequence)input);
        return this.postProcess(document);
    }

    @NotNull
    public Document parse(@NotNull String input) {
        DocumentParser documentParser = new DocumentParser(this.options, this.blockParserFactories, this.paragraphPreProcessorFactories, this.blockPreProcessorDependencies, this.inlineParserFactory.inlineParser(this.options, this.specialCharacters, this.delimiterCharacters, this.delimiterProcessors, this.linkRefProcessors, this.inlineParserExtensionFactories));
        Document document = documentParser.parse((CharSequence)BasedSequence.of((CharSequence)input));
        return this.postProcess(document);
    }

    @NotNull
    public Document parseReader(@NotNull Reader input) throws IOException {
        DocumentParser documentParser = new DocumentParser(this.options, this.blockParserFactories, this.paragraphPreProcessorFactories, this.blockPreProcessorDependencies, this.inlineParserFactory.inlineParser(this.options, this.specialCharacters, this.delimiterCharacters, this.delimiterProcessors, this.linkRefProcessors, this.inlineParserExtensionFactories));
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    private Document postProcess(Document document) {
        document = PostProcessorManager.processDocument(document, this.postProcessorDependencies);
        return document;
    }

    @Nullable
    public DataHolder getOptions() {
        return this.options;
    }

    public boolean transferReferences(@NotNull Document document, @NotNull Document included, Boolean onlyIfUndefined) {
        boolean transferred = false;
        if (this.options.contains(EXTENSIONS)) {
            for (Extension extension : (Collection)EXTENSIONS.get(this.options)) {
                ReferenceHoldingExtension parserExtension;
                if (!(extension instanceof ReferenceHoldingExtension) || !(parserExtension = (ReferenceHoldingExtension)extension).transferReferences((MutableDataHolder)document, (DataHolder)included)) continue;
                transferred = true;
            }
        }
        if (document.contains(REFERENCES) && included.contains(REFERENCES) && Parser.transferReferences((NodeRepository)REFERENCES.get((DataHolder)document), (NodeRepository)REFERENCES.get((DataHolder)included), onlyIfUndefined != null ? onlyIfUndefined : REFERENCES_KEEP.get((DataHolder)document) == KeepType.FIRST)) {
            transferred = true;
        }
        if (transferred) {
            document.set(HtmlRenderer.RECHECK_UNDEFINED_REFERENCES, (Object)true);
        }
        return transferred;
    }

    public static <T extends Node> boolean transferReferences(NodeRepository<T> destination, NodeRepository<T> included, boolean onlyIfUndefined) {
        return NodeRepository.transferReferences(destination, included, (boolean)onlyIfUndefined, null);
    }

    public static MutableDataHolder addExtensions(MutableDataHolder options, Extension ... extensions) {
        Iterable extensionIterable = (Iterable)EXTENSIONS.get((DataHolder)options);
        ArrayList<Extension> extensionList = new ArrayList<Extension>(Arrays.asList(extensions));
        for (Extension extension : extensionIterable) {
            extensionList.add(extension);
        }
        options.set(EXTENSIONS, extensionList);
        return options;
    }

    public static MutableDataHolder removeExtensions(MutableDataHolder options, Class ... extensions) {
        Iterable extensionIterable = (Iterable)EXTENSIONS.get((DataHolder)options);
        HashSet<Extension> extensionList = new HashSet<Extension>();
        for (Extension extension : extensionIterable) {
            boolean keep = true;
            for (Class clazz : extensions) {
                if (!clazz.isInstance(extension)) continue;
                keep = false;
                break;
            }
            if (!keep) continue;
            extensionList.add(extension);
        }
        options.set(EXTENSIONS, extensionList);
        return options;
    }

    public static interface ReferenceHoldingExtension
    extends Extension {
        public boolean transferReferences(MutableDataHolder var1, DataHolder var2);
    }

    public static interface ParserExtension
    extends Extension {
        public void parserOptions(MutableDataHolder var1);

        public void extend(Builder var1);
    }

    public static class Builder
    extends BuilderBase<Builder> {
        final List<CustomBlockParserFactory> blockParserFactories = new ArrayList<CustomBlockParserFactory>();
        final List<DelimiterProcessor> delimiterProcessors = new ArrayList<DelimiterProcessor>();
        final List<PostProcessorFactory> postProcessorFactories = new ArrayList<PostProcessorFactory>();
        final List<ParagraphPreProcessorFactory> paragraphPreProcessorFactories = new ArrayList<ParagraphPreProcessorFactory>();
        final List<BlockPreProcessorFactory> blockPreProcessorFactories = new ArrayList<BlockPreProcessorFactory>();
        final List<LinkRefProcessorFactory> linkRefProcessors = new ArrayList<LinkRefProcessorFactory>();
        final List<InlineParserExtensionFactory> inlineParserExtensionFactories = new ArrayList<InlineParserExtensionFactory>();
        InlineParserFactory inlineParserFactory = null;
        final List<SpecialLeadInHandler> specialLeadInHandlers = new ArrayList<SpecialLeadInHandler>();

        public Builder(DataHolder options) {
            super(options);
            this.loadExtensions();
        }

        public Builder() {
        }

        @NotNull
        public Parser build() {
            return new Parser(this);
        }

        protected void removeApiPoint(@NotNull Object apiPoint) {
            if (apiPoint instanceof CustomBlockParserFactory) {
                this.blockParserFactories.remove(apiPoint);
            } else if (apiPoint instanceof DelimiterProcessor) {
                this.delimiterProcessors.remove(apiPoint);
            } else if (apiPoint instanceof PostProcessorFactory) {
                this.postProcessorFactories.remove(apiPoint);
            } else if (apiPoint instanceof ParagraphPreProcessorFactory) {
                this.paragraphPreProcessorFactories.remove(apiPoint);
            } else if (apiPoint instanceof BlockPreProcessorFactory) {
                this.blockPreProcessorFactories.remove(apiPoint);
            } else if (apiPoint instanceof LinkRefProcessorFactory) {
                this.linkRefProcessors.remove(apiPoint);
            } else if (apiPoint instanceof SpecialLeadInHandler) {
                this.specialLeadInHandlers.remove(apiPoint);
            } else if (apiPoint instanceof InlineParserExtensionFactory) {
                this.inlineParserExtensionFactories.remove(apiPoint);
            } else if (apiPoint instanceof InlineParserFactory) {
                this.inlineParserFactory = null;
            } else {
                throw new IllegalStateException("Unknown data point type: " + apiPoint.getClass().getName());
            }
        }

        protected void preloadExtension(@NotNull Extension extension) {
            if (extension instanceof ParserExtension) {
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.parserOptions((MutableDataHolder)this);
            }
        }

        protected boolean loadExtension(@NotNull Extension extension) {
            if (extension instanceof ParserExtension) {
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.extend(this);
                return true;
            }
            return false;
        }

        public Builder customBlockParserFactory(CustomBlockParserFactory blockParserFactory) {
            this.blockParserFactories.add(blockParserFactory);
            this.addExtensionApiPoint(blockParserFactory);
            return this;
        }

        public Builder customInlineParserExtensionFactory(InlineParserExtensionFactory inlineParserExtensionFactory) {
            this.inlineParserExtensionFactories.add(inlineParserExtensionFactory);
            this.addExtensionApiPoint(inlineParserExtensionFactory);
            return this;
        }

        public Builder customInlineParserFactory(InlineParserFactory blockParserFactory) {
            if (this.inlineParserFactory != null) {
                throw new IllegalStateException("custom inline parser factory is already set to " + this.inlineParserFactory.getClass().getName());
            }
            this.inlineParserFactory = blockParserFactory;
            this.addExtensionApiPoint(blockParserFactory);
            return this;
        }

        public Builder customDelimiterProcessor(DelimiterProcessor delimiterProcessor) {
            this.delimiterProcessors.add(delimiterProcessor);
            this.addExtensionApiPoint(delimiterProcessor);
            return this;
        }

        public Builder postProcessorFactory(PostProcessorFactory postProcessorFactory) {
            this.postProcessorFactories.add(postProcessorFactory);
            this.addExtensionApiPoint(postProcessorFactory);
            return this;
        }

        public Builder paragraphPreProcessorFactory(ParagraphPreProcessorFactory paragraphPreProcessorFactory) {
            this.paragraphPreProcessorFactories.add(paragraphPreProcessorFactory);
            this.addExtensionApiPoint(paragraphPreProcessorFactory);
            return this;
        }

        public Builder blockPreProcessorFactory(BlockPreProcessorFactory blockPreProcessorFactory) {
            this.blockPreProcessorFactories.add(blockPreProcessorFactory);
            this.addExtensionApiPoint(blockPreProcessorFactory);
            return this;
        }

        public Builder linkRefProcessorFactory(LinkRefProcessorFactory linkRefProcessor) {
            this.linkRefProcessors.add(linkRefProcessor);
            this.addExtensionApiPoint(linkRefProcessor);
            return this;
        }

        public Builder specialLeadInHandler(SpecialLeadInHandler specialLeadInHandler) {
            this.specialLeadInHandlers.add(specialLeadInHandler);
            this.addExtensionApiPoint(specialLeadInHandler);
            return this;
        }
    }
}

