/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.federation.FederatedAbstract;
import org.apache.activemq.artemis.core.server.federation.Federation;

public class FederationManager
implements ActiveMQComponent {
    private final ActiveMQServer server;
    private Map<String, Federation> federations = new HashMap<String, Federation>();
    private State state;

    public FederationManager(ActiveMQServer server) {
        this.server = server;
    }

    public synchronized void start() throws ActiveMQException {
        if (this.state == State.STARTED) {
            return;
        }
        this.deploy();
        for (Federation federation : this.federations.values()) {
            federation.start();
        }
        this.state = State.STARTED;
    }

    public synchronized void stop() {
        if (this.state == State.STOPPED) {
            return;
        }
        this.state = State.STOPPING;
        for (Federation federation : this.federations.values()) {
            federation.stop();
        }
        this.federations.clear();
        this.state = State.STOPPED;
    }

    public boolean isStarted() {
        return this.state == State.STARTED;
    }

    public synchronized void deploy() throws ActiveMQException {
        for (FederationConfiguration federationConfiguration : this.server.getConfiguration().getFederationConfigurations()) {
            this.deploy(federationConfiguration);
        }
        if (this.state != State.STARTED) {
            this.state = State.DEPLOYED;
        }
    }

    public synchronized boolean undeploy(String name) {
        Federation federation = this.federations.remove(name);
        if (federation != null) {
            federation.stop();
        }
        return true;
    }

    public synchronized boolean deploy(FederationConfiguration federationConfiguration) throws ActiveMQException {
        Federation federation = this.federations.get(federationConfiguration.getName());
        if (federation == null) {
            federation = this.newFederation(federationConfiguration);
        } else if (!Objects.equals(federation.getConfig().getCredentials(), federationConfiguration.getCredentials())) {
            this.undeploy(federationConfiguration.getName());
            federation = this.newFederation(federationConfiguration);
        }
        federation.deploy();
        return true;
    }

    private synchronized Federation newFederation(FederationConfiguration federationConfiguration) throws ActiveMQException {
        Federation federation = new Federation(this.server, federationConfiguration);
        this.federations.put(federationConfiguration.getName(), federation);
        if (this.state == State.STARTED) {
            federation.start();
        }
        return federation;
    }

    public Federation get(String name) {
        return this.federations.get(name);
    }

    public void register(FederatedAbstract federatedAbstract) {
        this.server.registerBrokerPlugin(federatedAbstract);
    }

    public void unregister(FederatedAbstract federatedAbstract) {
        this.server.unRegisterBrokerPlugin(federatedAbstract);
    }

    static enum State {
        STOPPED,
        STOPPING,
        DEPLOYED,
        STARTED;

    }
}

