/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.server.jetty;

import ai.digital.configuration.central.deploy.ServerSideProperties;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.XldRequestLog;
import com.xebialabs.deployit.util.SslFactoryBuilder;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;

class JettyServerConnector {
    private static final Logger logger = LoggerFactory.getLogger(JettyServerConnector.class);

    JettyServerConnector() {
    }

    public static JettyServerCustomizer create(ServerConfiguration serverConfiguration, ServerSideProperties serverSideProperties) {
        return jettyServer -> {
            ServerConnector connector;
            jettyServer.setStopTimeout(1000L);
            if (serverConfiguration.isSsl()) {
                logger.debug("Setting up Jetty to use SSL");
                SslContextFactory.Server sslContextFactory = SslFactoryBuilder.build(serverConfiguration);
                HttpConnectionFactory httpConnectionFactory = JettyServerConnector.getHttpConnectionFactory(serverSideProperties);
                connector = new ServerConnector(jettyServer, sslContextFactory, new ConnectionFactory[]{httpConnectionFactory});
            } else {
                HttpConnectionFactory httpConnectionFactory = JettyServerConnector.getHttpConnectionFactory(serverSideProperties);
                connector = new ServerConnector(jettyServer, new ConnectionFactory[]{httpConnectionFactory});
            }
            connector.setIdleTimeout((long)serverConfiguration.getHttpIdleTimeoutMillis().intValue());
            connector.setHost(serverConfiguration.getHttpBindAddress());
            connector.setPort(serverConfiguration.getHttpPort());
            jettyServer.setConnectors((Connector[])new ServerConnector[]{connector});
            XldRequestLog logWriter = new XldRequestLog("conf/logback-access.xml");
            jettyServer.setRequestLog((RequestLog)logWriter);
            logger.info("Connector listen {} on {}:{}", new Object[]{serverConfiguration.isSsl() ? "secure" : "no-secure", connector.getHost(), connector.getPort()});
        };
    }

    private static HttpConnectionFactory getHttpConnectionFactory(ServerSideProperties serverSideProperties) {
        HttpConfiguration configuration = new HttpConfiguration();
        configuration.setUriCompliance(UriCompliance.from(Set.of(UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR, UriCompliance.Violation.AMBIGUOUS_PATH_ENCODING)));
        configuration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(serverSideProperties.sniCheckEnabled(), TimeUnit.SECONDS.convert(365L, TimeUnit.DAYS), true));
        logger.debug("Setting up Jetty to use HTTP/1.1 with SNI check: {}", (Object)serverSideProperties.sniCheckEnabled());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(configuration);
        httpConnectionFactory.getHttpConfiguration().setHttpCompliance(HttpCompliance.RFC2616);
        httpConnectionFactory.getHttpConfiguration().setSendServerVersion(false);
        return httpConnectionFactory;
    }
}

