/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.util.Headers;
import org.jgroups.util.Util;

public abstract class BaseMessage
implements Message {
    protected Address dest;
    protected Address sender;
    protected volatile Header[] headers;
    protected volatile short flags;
    protected volatile byte transient_flags;
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;

    public BaseMessage() {
    }

    public BaseMessage(Address dest) {
        this.setDest(dest);
        this.headers = BaseMessage.createHeaders(Util.DEFAULT_HEADERS);
    }

    @Override
    public Address getDest() {
        return this.dest;
    }

    @Override
    public Message setDest(Address new_dest) {
        this.dest = new_dest;
        return this;
    }

    @Override
    public Address getSrc() {
        return this.sender;
    }

    @Override
    public Message setSrc(Address new_src) {
        this.sender = new_src;
        return this;
    }

    @Override
    public int getNumHeaders() {
        return Headers.size(this.headers);
    }

    @Override
    public Map<Short, Header> getHeaders() {
        return Headers.getHeaders(this.headers);
    }

    public Header[] headers() {
        return this.headers;
    }

    public Message headers(Header[] hdrs) {
        this.headers = hdrs;
        return this;
    }

    @Override
    public String printHeaders() {
        return Headers.printHeaders(this.headers);
    }

    @Override
    public Message setFlag(Message.Flag ... flags) {
        if (flags != null) {
            short tmp = this.flags;
            for (Message.Flag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp | flag.value());
            }
            this.flags = tmp;
        }
        return this;
    }

    @Override
    public Message setFlag(Message.TransientFlag ... flags) {
        if (flags != null) {
            short tmp = this.transient_flags;
            for (Message.TransientFlag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp | flag.value());
            }
            this.transient_flags = (byte)tmp;
        }
        return this;
    }

    @Override
    public Message setFlag(short flag, boolean transient_flags) {
        if (transient_flags) {
            this.transient_flags = (byte)flag;
        } else {
            this.flags = flag;
        }
        return this;
    }

    @Override
    public short getFlags(boolean transient_flags) {
        return transient_flags ? (short)this.transient_flags : this.flags;
    }

    @Override
    public Message clearFlag(Message.Flag ... flags) {
        if (flags != null) {
            short tmp = this.flags;
            for (Message.Flag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp & ~flag.value());
            }
            this.flags = tmp;
        }
        return this;
    }

    @Override
    public Message clearFlag(Message.TransientFlag ... flags) {
        if (flags != null) {
            short tmp = this.transient_flags;
            for (Message.TransientFlag flag : flags) {
                if (flag == null) continue;
                tmp = (short)(tmp & ~flag.value());
            }
            this.transient_flags = (byte)tmp;
        }
        return this;
    }

    @Override
    public boolean isFlagSet(Message.Flag flag) {
        return Util.isFlagSet(this.flags, flag);
    }

    @Override
    public boolean isFlagSet(Message.TransientFlag flag) {
        return Util.isTransientFlagSet(this.transient_flags, flag);
    }

    @Override
    public synchronized boolean setFlagIfAbsent(Message.TransientFlag flag) {
        if (this.isFlagSet(flag)) {
            return false;
        }
        this.setFlag(flag);
        return true;
    }

    @Override
    public Message copy(boolean copy_payload, boolean copy_headers) {
        BaseMessage retval = (BaseMessage)this.create().get();
        retval.dest = this.dest;
        retval.sender = this.sender;
        retval.flags = this.flags;
        retval.transient_flags = this.transient_flags;
        Header[] headerArray = retval.headers = copy_headers && this.headers != null ? Headers.copy(this.headers) : BaseMessage.createHeaders(Util.DEFAULT_HEADERS);
        if (copy_payload) {
            this.copyPayload(retval);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message putHeader(short id, Header hdr) {
        if (id < 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid");
        }
        if (hdr != null) {
            hdr.setProtId(id);
        }
        BaseMessage baseMessage = this;
        synchronized (baseMessage) {
            Header[] resized_array;
            if (this.headers == null) {
                this.headers = BaseMessage.createHeaders(Util.DEFAULT_HEADERS);
            }
            if ((resized_array = Headers.putHeader(this.headers, id, hdr, true)) != null) {
                this.headers = resized_array;
            }
        }
        return this;
    }

    @Override
    public <T extends Header> T getHeader(short id) {
        if (id <= 0) {
            throw new IllegalArgumentException("An ID of " + id + " is invalid. Add the protocol which calls getHeader() to jg-protocol-ids.xml");
        }
        return Headers.getHeader(this.headers, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message clearHeaders() {
        BaseMessage baseMessage = this;
        synchronized (baseMessage) {
            this.headers = BaseMessage.createHeaders(Util.DEFAULT_HEADERS);
        }
        return this;
    }

    @Override
    public <T> T getPayload() {
        return this.getObject();
    }

    @Override
    public Message setPayload(Object pl) {
        return this.setObject(pl);
    }

    public String toString() {
        return String.format("[%s to %s, %d bytes%s%s]", this.sender, this.dest == null ? "<all>" : this.dest, this.getLength(), this.flags > 0 ? ", flags=" + Util.flagsToString(this.flags) : "", this.transient_flags > 0 ? ", transient_flags=" + Util.transientFlagsToString(this.transient_flags) : "");
    }

    @Override
    public int serializedSize() {
        return this.size();
    }

    @Override
    public int size() {
        int retval = 3;
        if (this.dest != null) {
            retval += Util.size(this.dest);
        }
        if (this.sender != null) {
            retval += Util.size(this.sender);
        }
        retval += 2;
        return retval += Headers.marshalledSize(this.headers);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        byte leading = 0;
        if (this.dest != null) {
            leading = Util.setFlag(leading, (byte)1);
        }
        if (this.sender != null) {
            leading = Util.setFlag(leading, (byte)2);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (this.dest != null) {
            Util.writeAddress(this.dest, out);
        }
        if (this.sender != null) {
            Util.writeAddress(this.sender, out);
        }
        Headers.writeHeaders(this.headers, out, (short[])null);
        this.writePayload(out);
    }

    @Override
    public void writeToNoAddrs(Address src, DataOutput out, short ... excluded_headers) throws IOException {
        boolean write_src_addr;
        byte leading = 0;
        boolean bl = write_src_addr = src == null || this.sender != null && !this.sender.equals(src);
        if (write_src_addr) {
            leading = Util.setFlag(leading, (byte)2);
        }
        out.write(leading);
        out.writeShort(this.flags);
        if (write_src_addr) {
            Util.writeAddress(this.sender, out);
        }
        Headers.writeHeaders(this.headers, out, excluded_headers);
        this.writePayload(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        byte leading = in.readByte();
        this.flags = in.readShort();
        if (Util.isFlagSet(leading, (byte)1)) {
            this.dest = Util.readAddress(in);
        }
        if (Util.isFlagSet(leading, (byte)2)) {
            this.sender = Util.readAddress(in);
        }
        this.headers = Headers.readHeaders(in);
        this.readPayload(in);
    }

    protected Message copyPayload(Message copy) {
        return copy;
    }

    protected static Header[] createHeaders(int size) {
        return size > 0 ? new Header[size] : new Header[Util.DEFAULT_HEADERS];
    }
}

