/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.time.Year;
import java.time.format.DateTimeFormatter;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class YearJavaType
extends AbstractClassJavaType<Year> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy");
    public static final YearJavaType INSTANCE = new YearJavaType();

    public YearJavaType() {
        super(Year.class);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getJdbcType(4);
    }

    @Override
    public String toString(Year value) {
        return value == null ? null : value.format(FORMATTER);
    }

    @Override
    public Year fromString(CharSequence string) {
        return string == null ? null : Year.parse(string, FORMATTER);
    }

    @Override
    public <X> X unwrap(Year value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (X)value;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.getValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.getValue());
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Year wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Year) {
            return (Year)value;
        }
        if (value instanceof Number) {
            return Year.of(((Number)value).intValue());
        }
        if (value instanceof String) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

