/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.BitSet;
import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.jdbc.internal.AbstractJdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class JdbcValuesCacheHit
extends AbstractJdbcValues {
    private List<?> cachedResults;
    private final int numberOfRows;
    private final JdbcValuesMapping resolvedMapping;
    private final int[] valueIndexesToCacheIndexes;
    private final int offset;
    private int position = -1;

    public JdbcValuesCacheHit(List<?> cachedResults, JdbcValuesMapping resolvedMapping) {
        this.cachedResults = cachedResults;
        this.offset = !cachedResults.isEmpty() && cachedResults.get(0) instanceof JdbcValuesMetadata ? 1 : 0;
        this.numberOfRows = cachedResults.size() - this.offset;
        this.resolvedMapping = resolvedMapping;
        BitSet valueIndexesToCache = new BitSet();
        for (DomainResult<?> domainResult : resolvedMapping.getDomainResults()) {
            domainResult.collectValueIndexesToCache(valueIndexesToCache);
        }
        if (valueIndexesToCache.nextClearBit(0) == -1) {
            this.valueIndexesToCacheIndexes = null;
        } else {
            int[] valueIndexesToCacheIndexes = new int[valueIndexesToCache.length()];
            int cacheIndex = 0;
            for (int i = 0; i < valueIndexesToCacheIndexes.length; ++i) {
                valueIndexesToCacheIndexes[i] = valueIndexesToCache.get(i) ? cacheIndex++ : -1;
            }
            this.valueIndexesToCacheIndexes = valueIndexesToCacheIndexes;
        }
    }

    @Override
    protected boolean processNext(RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processNext : position = %d; numberOfRows = %d", this.position, this.numberOfRows);
        ++this.position;
        if (this.position >= this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    protected boolean processPrevious(RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processPrevious : position = %d; numberOfRows = %d", this.position, this.numberOfRows);
        --this.position;
        if (this.position >= this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    protected boolean processScroll(int numberOfRows, RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processScroll(%d) : position = %d; numberOfRows = %d", numberOfRows, this.position, this.numberOfRows);
        this.position += numberOfRows;
        if (this.position > this.numberOfRows) {
            this.position = this.numberOfRows;
            return false;
        }
        return true;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    protected boolean processPosition(int position, RowProcessingState rowProcessingState) {
        ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("JdbcValuesCacheHit#processPosition(%d) : position = %d; numberOfRows = %d", position, this.position, this.numberOfRows);
        if (position < 0) {
            int newPosition = this.numberOfRows + position;
            ResultsLogger.RESULTS_MESSAGE_LOGGER.debugf("Translated negative absolute position `%d` into `%d` based on `%d` number of rows", position, newPosition, this.numberOfRows);
            position = newPosition;
        }
        if (position > this.numberOfRows) {
            ResultsLogger.RESULTS_MESSAGE_LOGGER.debugf("Absolute position `%d` exceeded number of rows `%d`", position, this.numberOfRows);
            this.position = this.numberOfRows;
            return false;
        }
        this.position = position;
        return true;
    }

    @Override
    public boolean isBeforeFirst(RowProcessingState rowProcessingState) {
        return this.position < 0;
    }

    @Override
    public void beforeFirst(RowProcessingState rowProcessingState) {
        this.position = -1;
    }

    @Override
    public boolean isFirst(RowProcessingState rowProcessingState) {
        return this.position == 0;
    }

    @Override
    public boolean first(RowProcessingState rowProcessingState) {
        this.position = 0;
        return this.numberOfRows > 0;
    }

    @Override
    public boolean isAfterLast(RowProcessingState rowProcessingState) {
        return this.position >= this.numberOfRows;
    }

    @Override
    public void afterLast(RowProcessingState rowProcessingState) {
        this.position = this.numberOfRows;
    }

    @Override
    public boolean isLast(RowProcessingState rowProcessingState) {
        if (this.numberOfRows == 0) {
            return this.position == 0;
        }
        return this.position == this.numberOfRows - 1;
    }

    @Override
    public boolean last(RowProcessingState rowProcessingState) {
        if (this.numberOfRows == 0) {
            this.position = 0;
            return false;
        }
        this.position = this.numberOfRows - 1;
        return true;
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.resolvedMapping;
    }

    @Override
    public Object getCurrentRowValue(int valueIndex) {
        if (this.position >= this.numberOfRows) {
            return null;
        }
        Object row = this.cachedResults.get(this.position + this.offset);
        if (this.valueIndexesToCacheIndexes == null) {
            return ((Object[])row)[valueIndex];
        }
        if (row.getClass() != Object[].class) {
            assert (this.valueIndexesToCacheIndexes[valueIndex] == 0);
            return row;
        }
        return ((Object[])row)[this.valueIndexesToCacheIndexes[valueIndex]];
    }

    @Override
    public void finishRowProcessing(RowProcessingState rowProcessingState) {
    }

    @Override
    public void finishUp(SharedSessionContractImplementor session) {
        this.cachedResults = null;
    }

    @Override
    public void setFetchSize(int fetchSize) {
    }
}

