/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;

public class FilterImpl
implements Filter,
Serializable {
    public static final String MARKER = "$FILTER_PLACEHOLDER$";
    private transient FilterDefinition definition;
    private final String filterName;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final boolean autoEnabled;

    void afterDeserialize(SessionFactoryImplementor factory) {
        this.definition = factory.getFilterDefinition(this.filterName);
        this.validate();
    }

    public FilterImpl(FilterDefinition configuration) {
        this.definition = configuration;
        this.filterName = this.definition.getFilterName();
        this.autoEnabled = this.definition.isAutoEnabled();
    }

    @Override
    public FilterDefinition getFilterDefinition() {
        return this.definition;
    }

    @Override
    public String getName() {
        return this.definition.getFilterName();
    }

    @Override
    public boolean isAutoEnabled() {
        return this.autoEnabled;
    }

    public Map<String, ?> getParameters() {
        return this.parameters;
    }

    @Override
    public Filter setParameter(String name, Object value) throws IllegalArgumentException {
        Object argument = this.definition.processArgument(value);
        JdbcMapping type = this.definition.getParameterJdbcMapping(name);
        if (type == null) {
            throw new IllegalArgumentException("Undefined filter parameter [" + name + "]");
        }
        if (argument != null && !type.getJavaTypeDescriptor().isInstance(argument)) {
            throw new IllegalArgumentException("Incorrect type for parameter [" + name + "]");
        }
        this.parameters.put(name, argument);
        return this;
    }

    @Override
    public Filter setParameterList(String name, Collection<?> values) throws HibernateException {
        if (values == null) {
            throw new IllegalArgumentException("Collection must be not null");
        }
        JdbcMapping type = this.definition.getParameterJdbcMapping(name);
        if (type == null) {
            throw new HibernateException("Undefined filter parameter [" + name + "]");
        }
        if (!values.isEmpty()) {
            Object element = values.iterator().next();
            if (!type.getJavaTypeDescriptor().isInstance(element)) {
                throw new HibernateException("Incorrect type for parameter [" + name + "]");
            }
        }
        this.parameters.put(name, values);
        return this;
    }

    @Override
    public Filter setParameterList(String name, Object[] values) throws IllegalArgumentException {
        return this.setParameterList(name, Arrays.asList(values));
    }

    public Object getParameter(String name) {
        return this.parameters.get(name);
    }

    public Supplier<?> getParameterResolver(String name) {
        return this.definition.getParameterResolver(name);
    }

    @Override
    public void validate() throws HibernateException {
        for (String parameterName : this.definition.getParameterNames()) {
            if (this.hasArgument(parameterName) || this.hasResolver(parameterName)) continue;
            throw new HibernateException("Filter parameter '" + this.getName() + "' has neither an argument nor a resolver");
        }
    }

    private boolean hasResolver(String parameterName) {
        Supplier<?> resolver = this.getParameterResolver(parameterName);
        return resolver != null && !resolver.getClass().isInterface();
    }

    private boolean hasArgument(String parameterName) {
        return this.parameters.containsKey(parameterName);
    }
}

