/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io;

import java.util.Collection;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;

public interface IOCallback {
    public void done();

    public void onError(int var1, String var2);

    public static void done(Collection<? extends IOCallback> delegates) {
        if (delegates != null) {
            delegates.forEach(callback -> {
                try {
                    callback.done();
                }
                catch (Throwable e) {
                    ActiveMQJournalLogger.LOGGER.errorCompletingCallback(e);
                }
            });
        }
    }

    public static void onError(Collection<? extends IOCallback> delegates, int errorCode, String errorMessage) {
        delegates.forEach(callback -> {
            try {
                callback.onError(errorCode, errorMessage);
            }
            catch (Throwable e) {
                ActiveMQJournalLogger.LOGGER.errorCallingErrorCallback(e);
            }
        });
    }
}

