/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Internal;
import org.hibernate.boot.internal.ForeignKeyNameSource;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.JoinedList;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class DenormalizedTable
extends Table {
    private final Table includedTable;
    private List<Column> reorderedColumns;

    public DenormalizedTable(String contributor, Namespace namespace, Identifier physicalTableName, boolean isAbstract, Table includedTable) {
        super(contributor, namespace, physicalTableName, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    public DenormalizedTable(String contributor, Namespace namespace, Identifier physicalTableName, String subselectFragment, boolean isAbstract, Table includedTable) {
        super(contributor, namespace, physicalTableName, subselectFragment, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    public DenormalizedTable(String contributor, Namespace namespace, String subselect, boolean isAbstract, Table includedTable) {
        super(contributor, namespace, subselect, isAbstract);
        this.includedTable = includedTable;
        includedTable.setHasDenormalizedTables();
    }

    @Override
    public void createForeignKeys(MetadataBuildingContext context) {
        this.includedTable.createForeignKeys(context);
        for (ForeignKey foreignKey : this.includedTable.getForeignKeys().values()) {
            PersistentClass referencedClass = foreignKey.resolveReferencedClass(context.getMetadataCollector());
            if (foreignKey.getReferencedTable() == null) {
                foreignKey.setReferencedTable(referencedClass.getTable());
            }
            this.createForeignKey(context.getBuildingOptions().getImplicitNamingStrategy().determineForeignKeyName(new ForeignKeyNameSource(foreignKey, this, context)).render(context.getMetadataCollector().getDatabase().getDialect()), foreignKey.getColumns(), foreignKey.getReferencedEntityName(), foreignKey.getKeyDefinition(), foreignKey.getReferencedColumns());
        }
    }

    @Override
    public Column getColumn(Column column) {
        Column superColumn = super.getColumn(column);
        return superColumn != null ? superColumn : this.includedTable.getColumn(column);
    }

    @Override
    public Column getColumn(Identifier name) {
        Column superColumn = super.getColumn(name);
        return superColumn != null ? superColumn : this.includedTable.getColumn(name);
    }

    @Override
    public Collection<Column> getColumns() {
        if (this.reorderedColumns != null) {
            return this.reorderedColumns;
        }
        return new JoinedList<Column>(new ArrayList<Column>(this.includedTable.getColumns()), new ArrayList<Column>(super.getColumns()));
    }

    @Override
    public boolean containsColumn(Column column) {
        return super.containsColumn(column) || this.includedTable.containsColumn(column);
    }

    @Override
    public PrimaryKey getPrimaryKey() {
        return this.includedTable.getPrimaryKey();
    }

    @Override
    @Deprecated(forRemoval=true)
    public Iterator<UniqueKey> getUniqueKeyIterator() {
        if (!this.includedTable.isPhysicalTable()) {
            for (UniqueKey uniqueKey : this.includedTable.getUniqueKeys().values()) {
                this.createUniqueKey(uniqueKey.getColumns());
            }
        }
        return this.getUniqueKeys().values().iterator();
    }

    public Table getIncludedTable() {
        return this.includedTable;
    }

    @Override
    @Internal
    public void reorderColumns(List<Column> columns) {
        assert (this.includedTable.getColumns().size() + super.getColumns().size() == columns.size() && columns.containsAll(this.includedTable.getColumns()) && columns.containsAll(super.getColumns()) && this.reorderedColumns == null);
        this.reorderedColumns = columns;
    }
}

