/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.notifications.cachelistener.BaseQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.EventWrapper;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.util.KeyValuePair;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class QueueingAllSegmentListener<K, V>
extends BaseQueueingSegmentListener<K, V, Event<K, V>> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected final Queue<KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>>> queue = new ConcurrentLinkedQueue<KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>>>();
    protected final InternalEntryFactory entryFactory;

    QueueingAllSegmentListener(InternalEntryFactory entryFactory, int segment, KeyPartitioner keyPartitioner) {
        super(segment, keyPartitioner);
        this.entryFactory = entryFactory;
    }

    @Override
    public boolean handleEvent(EventWrapper<K, V, Event<K, V>> wrapper, ListenerInvocation<Event<K, V>> invocation) {
        boolean queued;
        boolean bl = queued = !this.completed.get();
        if (queued) {
            boolean continueQueueing = true;
            Event<K, V> event = wrapper.getEvent();
            if (event instanceof CacheEntryEvent) {
                CacheEntryEvent cacheEvent = (CacheEntryEvent)event;
                InternalCacheEntry cacheEntry = this.entryFactory.create(cacheEvent.getKey(), cacheEvent.getValue(), cacheEvent.getMetadata());
                if (this.addEvent(wrapper.getKey(), this.segmentFromEventWrapper(wrapper), cacheEntry.getValue() != null ? cacheEntry : REMOVED)) {
                    continueQueueing = false;
                }
            }
            if (continueQueueing) {
                KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>> eventPair = new KeyValuePair<Event<K, V>, ListenerInvocation<Event<K, V>>>(event, invocation);
                this.queue.add(eventPair);
                if (this.completed.get() && this.queue.remove(eventPair)) {
                    return false;
                }
            }
        }
        return queued;
    }

    @Override
    public CompletionStage<Void> transferComplete() {
        AggregateCompletionStage<Void> aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        Iterator iterator = this.queue.iterator();
        while (iterator.hasNext()) {
            KeyValuePair eventPair = (KeyValuePair)iterator.next();
            CompletionStage<Void> eventStage = ((ListenerInvocation)eventPair.getValue()).invoke((Event)eventPair.getKey());
            if (eventStage != null) {
                aggregateCompletionStage.dependsOn(eventStage);
            }
            iterator.remove();
        }
        this.completed.set(true);
        return aggregateCompletionStage.freeze();
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

