/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.relay.Bridge;
import org.jgroups.protocols.relay.ForwardingRoute;
import org.jgroups.protocols.relay.RELAY;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.UUID;

public class Relayer3
extends Relayer {
    protected final Collection<Bridge> bridges = new ConcurrentLinkedQueue<Bridge>();

    public Relayer3(RELAY relay, Log log) {
        super(relay, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Relayer> start(RelayConfig.SiteConfig site_cfg, String bridge_name, final String my_site_id) throws Throwable {
        if (this.done) {
            this.log.trace(String.valueOf(this.relay.getAddress()) + ": will not start the Relayer as stop() has been called");
            return CompletableFuture.completedFuture(this);
        }
        try {
            List<RelayConfig.ForwardConfig> forward_configs = site_cfg.getForwards();
            for (RelayConfig.ForwardConfig cfg : forward_configs) {
                ForwardingRoute fr = new ForwardingRoute(cfg.to(), cfg.gateway());
                this.forward_routes.add(fr);
            }
            List<RelayConfig.BridgeConfig> bridge_configs = site_cfg.getBridges();
            for (RelayConfig.BridgeConfig cfg : bridge_configs) {
                Bridge bridge = new Bridge(cfg.createChannel(), this, cfg.getClusterName(), bridge_name, new AddressGenerator(){

                    @Override
                    public Address generateAddress() {
                        return this.generateAddress(null);
                    }

                    @Override
                    public Address generateAddress(String name) {
                        return new SiteUUID(UUID.randomUUID(), name, my_site_id);
                    }
                });
                this.bridges.add(bridge);
            }
            for (Bridge bridge : this.bridges) {
                bridge.start();
            }
            CompletableFuture<Relayer3> completableFuture = CompletableFuture.completedFuture(this);
            return completableFuture;
        }
        catch (Throwable t) {
            this.stop();
            CompletableFuture<Relayer> completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            if (this.done) {
                this.stop();
            }
        }
    }

    @Override
    public void stop() {
        this.done = true;
        this.bridges.forEach(Bridge::stop);
        this.bridges.clear();
    }

    @Override
    protected View getBridgeView(String cluster_name) {
        if (cluster_name == null || this.bridges == null) {
            return null;
        }
        for (Bridge bridge : this.bridges) {
            if (!Objects.equals(bridge.cluster_name, cluster_name)) continue;
            return bridge.view;
        }
        return null;
    }
}

