/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.functional.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commons.util.Experimental;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Listeners;
import org.infinispan.functional.Param;
import org.infinispan.functional.Traversable;
import org.infinispan.functional.impl.AbstractFunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.Params;
import org.infinispan.functional.impl.Traversables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Experimental
public final class ReadWriteMapImpl<K, V>
extends AbstractFunctionalMap<K, V>
implements FunctionalMap.ReadWriteMap<K, V> {
    private static final Log log = LogFactory.getLog(ReadWriteMapImpl.class);

    private ReadWriteMapImpl(Params params, FunctionalMapImpl<K, V> functionalMap) {
        super(params, functionalMap);
    }

    public static <K, V> FunctionalMap.ReadWriteMap<K, V> create(FunctionalMapImpl<K, V> functionalMap) {
        return ReadWriteMapImpl.create(Params.from(functionalMap.params.params), functionalMap);
    }

    private static <K, V> FunctionalMap.ReadWriteMap<K, V> create(Params params, FunctionalMapImpl<K, V> functionalMap) {
        return new ReadWriteMapImpl<K, V>(params, functionalMap);
    }

    @Override
    public <R> CompletableFuture<R> eval(K key, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, %s)", key, this.params);
        Object keyEncoded = this.keyDataConversion.toStorage(key);
        ReadWriteKeyCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadWriteKeyCommand(keyEncoded, f, this.fmap.keyPartitioner.getSegment(keyEncoded), this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return this.invokeAsync(ctx, cmd);
    }

    @Override
    public <T, R> CompletableFuture<R> eval(K key, T argument, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked eval(k=%s, v=%s, %s)", key, argument, this.params);
        Object keyEncoded = this.keyDataConversion.toStorage(key);
        Object argumentEncoded = this.valueDataConversion.toStorage(argument);
        ReadWriteKeyValueCommand<K, V, T, R> cmd = this.fmap.commandsFactory.buildReadWriteKeyValueCommand(keyEncoded, argumentEncoded, f, this.fmap.keyPartitioner.getSegment(keyEncoded), this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, 1);
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return this.invokeAsync(ctx, cmd);
    }

    @Override
    public <T, R> Traversable<R> evalMany(Map<? extends K, ? extends T> arguments, BiFunction<T, EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(entries=%s, %s)", arguments, this.params);
        Map<? extends T, ? extends T> argumentsEncoded = this.encodeEntries(arguments);
        ReadWriteManyEntriesCommand<K, V, T, R> cmd = this.fmap.commandsFactory.buildReadWriteManyEntriesCommand(argumentsEncoded, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, arguments.size());
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return Traversables.of(((List)this.invokeAsync(ctx, cmd).join()).stream());
    }

    @Override
    public <R> Traversable<R> evalMany(Set<? extends K> keys, Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalMany(keys=%s, %s)", keys, this.params);
        Set<?> encodedKeys = this.encodeKeys(keys);
        ReadWriteManyCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadWriteManyCommand(encodedKeys, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, keys.size());
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return Traversables.of(((List)this.invokeAsync(ctx, cmd).join()).stream());
    }

    @Override
    public <R> Traversable<R> evalAll(Function<EntryView.ReadWriteEntryView<K, V>, R> f) {
        log.tracef("Invoked evalAll(%s)", this.params);
        HashSet keys = new HashSet(this.fmap.cache.keySet());
        Set<?> encodedKeys = this.encodeKeys(keys);
        ReadWriteManyCommand<K, V, R> cmd = this.fmap.commandsFactory.buildReadWriteManyCommand(encodedKeys, f, this.params, this.keyDataConversion, this.valueDataConversion);
        InvocationContext ctx = this.getInvocationContext(true, encodedKeys.size());
        if (ctx.getLockOwner() == null) {
            ctx.setLockOwner(cmd.getKeyLockOwner());
        }
        return Traversables.of(((List)this.invokeAsync(ctx, cmd).join()).stream());
    }

    @Override
    public Listeners.ReadWriteListeners<K, V> listeners() {
        return this.fmap.notifier;
    }

    @Override
    public FunctionalMap.ReadWriteMap<K, V> withParams(Param<?> ... ps) {
        if (ps == null || ps.length == 0) {
            return this;
        }
        if (this.params.containsAll(ps)) {
            return this;
        }
        return ReadWriteMapImpl.create(this.params.addAll(ps), this.fmap);
    }
}

