/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.postgresql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericEnumType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(GenericEnumType.class);
    private final String sqlTypeName;

    public GenericEnumType(String sqlTypeName) {
        super(sqlTypeName, 1111, String.class, false);
        if (sqlTypeName == null) {
            throw new NullPointerException("The parameter 'sqlTypeName' must not be null");
        }
        this.sqlTypeName = sqlTypeName;
    }

    @Override
    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getString(column);
    }

    @Override
    public void setSqlValue(Object enumObject, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.getEnum(enumObject, statement.getConnection()));
    }

    @Override
    public Object typeCast(Object arg0) throws TypeCastException {
        return arg0.toString();
    }

    private Object getEnum(Object value, Connection connection) throws TypeCastException {
        logger.debug("getEnum(value={}, connection={}) - start", value, (Object)connection);
        Object tempEnum = null;
        try {
            Class aPGObjectClass = super.loadClass("org.postgresql.util.PGobject", connection);
            Constructor ct = aPGObjectClass.getConstructor(null);
            tempEnum = ct.newInstance(null);
            Method setTypeMethod = aPGObjectClass.getMethod("setType", String.class);
            setTypeMethod.invoke(tempEnum, this.sqlTypeName);
            Method setValueMethod = aPGObjectClass.getMethod("setValue", String.class);
            setValueMethod.invoke(tempEnum, value.toString());
        }
        catch (ClassNotFoundException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InstantiationException e) {
            throw new TypeCastException(value, this, e);
        }
        return tempEnum;
    }

    @Override
    public String getSqlTypeName() {
        return this.sqlTypeName;
    }
}

