/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.DelegatingSecurityContextRepository;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.NullSecurityContextRepository;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.DisableEncodeUrlFilter;
import org.springframework.security.web.session.ForceEagerSessionCreationFilter;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.session.SimpleRedirectInvalidSessionStrategy;
import org.springframework.security.web.session.SimpleRedirectSessionInformationExpiredStrategy;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class SessionManagementConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<SessionManagementConfigurer<H>, H> {
    private final SessionAuthenticationStrategy DEFAULT_SESSION_FIXATION_STRATEGY;
    private SessionAuthenticationStrategy sessionFixationAuthenticationStrategy;
    private SessionAuthenticationStrategy sessionAuthenticationStrategy;
    private SessionAuthenticationStrategy providedSessionAuthenticationStrategy;
    private InvalidSessionStrategy invalidSessionStrategy;
    private SessionInformationExpiredStrategy expiredSessionStrategy;
    private List<SessionAuthenticationStrategy> sessionAuthenticationStrategies;
    private SessionRegistry sessionRegistry;
    private Integer maximumSessions;
    private String expiredUrl;
    private boolean maxSessionsPreventsLogin;
    private SessionCreationPolicy sessionPolicy;
    private boolean enableSessionUrlRewriting;
    private String invalidSessionUrl;
    private String sessionAuthenticationErrorUrl;
    private AuthenticationFailureHandler sessionAuthenticationFailureHandler;
    private Set<String> propertiesThatRequireImplicitAuthentication;
    private Boolean requireExplicitAuthenticationStrategy;
    private SecurityContextRepository sessionManagementSecurityContextRepository;

    public SessionManagementConfigurer() {
        this.sessionFixationAuthenticationStrategy = this.DEFAULT_SESSION_FIXATION_STRATEGY = SessionManagementConfigurer.createDefaultSessionFixationProtectionStrategy();
        this.sessionAuthenticationStrategies = new ArrayList<SessionAuthenticationStrategy>();
        this.propertiesThatRequireImplicitAuthentication = new HashSet<String>();
        this.sessionManagementSecurityContextRepository = new HttpSessionSecurityContextRepository();
    }

    public SessionManagementConfigurer<H> invalidSessionUrl(String invalidSessionUrl) {
        this.invalidSessionUrl = invalidSessionUrl;
        this.propertiesThatRequireImplicitAuthentication.add("invalidSessionUrl = " + invalidSessionUrl);
        return this;
    }

    public SessionManagementConfigurer<H> requireExplicitAuthenticationStrategy(boolean requireExplicitAuthenticationStrategy) {
        this.requireExplicitAuthenticationStrategy = requireExplicitAuthenticationStrategy;
        return this;
    }

    public SessionManagementConfigurer<H> invalidSessionStrategy(InvalidSessionStrategy invalidSessionStrategy) {
        Assert.notNull((Object)invalidSessionStrategy, (String)"invalidSessionStrategy");
        this.invalidSessionStrategy = invalidSessionStrategy;
        this.propertiesThatRequireImplicitAuthentication.add("invalidSessionStrategy = " + String.valueOf(invalidSessionStrategy));
        return this;
    }

    public SessionManagementConfigurer<H> sessionAuthenticationErrorUrl(String sessionAuthenticationErrorUrl) {
        this.sessionAuthenticationErrorUrl = sessionAuthenticationErrorUrl;
        this.propertiesThatRequireImplicitAuthentication.add("sessionAuthenticationErrorUrl = " + sessionAuthenticationErrorUrl);
        return this;
    }

    public SessionManagementConfigurer<H> sessionAuthenticationFailureHandler(AuthenticationFailureHandler sessionAuthenticationFailureHandler) {
        this.sessionAuthenticationFailureHandler = sessionAuthenticationFailureHandler;
        this.propertiesThatRequireImplicitAuthentication.add("sessionAuthenticationFailureHandler = " + String.valueOf(sessionAuthenticationFailureHandler));
        return this;
    }

    public SessionManagementConfigurer<H> enableSessionUrlRewriting(boolean enableSessionUrlRewriting) {
        this.enableSessionUrlRewriting = enableSessionUrlRewriting;
        return this;
    }

    public SessionManagementConfigurer<H> sessionCreationPolicy(SessionCreationPolicy sessionCreationPolicy) {
        Assert.notNull((Object)((Object)sessionCreationPolicy), (String)"sessionCreationPolicy cannot be null");
        this.sessionPolicy = sessionCreationPolicy;
        this.propertiesThatRequireImplicitAuthentication.add("sessionCreationPolicy = " + String.valueOf((Object)sessionCreationPolicy));
        return this;
    }

    public SessionManagementConfigurer<H> sessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.providedSessionAuthenticationStrategy = sessionAuthenticationStrategy;
        this.propertiesThatRequireImplicitAuthentication.add("sessionAuthenticationStrategy = " + String.valueOf(sessionAuthenticationStrategy));
        return this;
    }

    public SessionManagementConfigurer<H> addSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionAuthenticationStrategy) {
        this.sessionAuthenticationStrategies.add(sessionAuthenticationStrategy);
        return this;
    }

    public SessionFixationConfigurer sessionFixation() {
        return new SessionFixationConfigurer();
    }

    public SessionManagementConfigurer<H> sessionFixation(Customizer<SessionFixationConfigurer> sessionFixationCustomizer) {
        sessionFixationCustomizer.customize(new SessionFixationConfigurer());
        return this;
    }

    public ConcurrencyControlConfigurer maximumSessions(int maximumSessions) {
        this.maximumSessions = maximumSessions;
        this.propertiesThatRequireImplicitAuthentication.add("maximumSessions = " + maximumSessions);
        return new ConcurrencyControlConfigurer();
    }

    public SessionManagementConfigurer<H> sessionConcurrency(Customizer<ConcurrencyControlConfigurer> sessionConcurrencyCustomizer) {
        sessionConcurrencyCustomizer.customize(new ConcurrencyControlConfigurer());
        return this;
    }

    private void setSessionFixationAuthenticationStrategy(SessionAuthenticationStrategy sessionFixationAuthenticationStrategy) {
        this.sessionFixationAuthenticationStrategy = this.postProcess(sessionFixationAuthenticationStrategy);
    }

    @Override
    public void init(H http) {
        SecurityContextRepository securityContextRepository = http.getSharedObject(SecurityContextRepository.class);
        boolean stateless = this.isStateless();
        if (securityContextRepository == null) {
            if (stateless) {
                http.setSharedObject(SecurityContextRepository.class, (RequestAttributeSecurityContextRepository)new RequestAttributeSecurityContextRepository());
                this.sessionManagementSecurityContextRepository = new NullSecurityContextRepository();
            } else {
                HttpSessionSecurityContextRepository httpSecurityRepository = new HttpSessionSecurityContextRepository();
                httpSecurityRepository.setDisableUrlRewriting(!this.enableSessionUrlRewriting);
                httpSecurityRepository.setAllowSessionCreation(this.isAllowSessionCreation());
                AuthenticationTrustResolver trustResolver = http.getSharedObject(AuthenticationTrustResolver.class);
                if (trustResolver != null) {
                    httpSecurityRepository.setTrustResolver(trustResolver);
                }
                this.sessionManagementSecurityContextRepository = httpSecurityRepository;
                DelegatingSecurityContextRepository defaultRepository = new DelegatingSecurityContextRepository(new SecurityContextRepository[]{httpSecurityRepository, new RequestAttributeSecurityContextRepository()});
                http.setSharedObject(SecurityContextRepository.class, (DelegatingSecurityContextRepository)defaultRepository);
            }
        } else {
            this.sessionManagementSecurityContextRepository = securityContextRepository;
        }
        RequestCache requestCache = http.getSharedObject(RequestCache.class);
        if (requestCache == null && stateless) {
            http.setSharedObject(RequestCache.class, (NullRequestCache)new NullRequestCache());
        }
        http.setSharedObject(SessionAuthenticationStrategy.class, (SessionAuthenticationStrategy)this.getSessionAuthenticationStrategy(http));
        http.setSharedObject(InvalidSessionStrategy.class, (InvalidSessionStrategy)this.getInvalidSessionStrategy());
    }

    @Override
    public void configure(H http) {
        SessionManagementFilter sessionManagementFilter = this.createSessionManagementFilter(http);
        if (sessionManagementFilter != null) {
            http.addFilter((Filter)sessionManagementFilter);
        }
        if (this.isConcurrentSessionControlEnabled()) {
            ConcurrentSessionFilter concurrentSessionFilter = this.createConcurrencyFilter(http);
            concurrentSessionFilter = this.postProcess(concurrentSessionFilter);
            http.addFilter((Filter)concurrentSessionFilter);
        }
        if (!this.enableSessionUrlRewriting) {
            http.addFilter((Filter)new DisableEncodeUrlFilter());
        }
        if (this.sessionPolicy == SessionCreationPolicy.ALWAYS) {
            http.addFilter((Filter)new ForceEagerSessionCreationFilter());
        }
    }

    private boolean shouldRequireExplicitAuthenticationStrategy() {
        boolean defaultRequireExplicitAuthenticationStrategy = this.propertiesThatRequireImplicitAuthentication.isEmpty();
        if (this.requireExplicitAuthenticationStrategy == null) {
            return defaultRequireExplicitAuthenticationStrategy;
        }
        if (this.requireExplicitAuthenticationStrategy.booleanValue() && !defaultRequireExplicitAuthenticationStrategy) {
            throw new IllegalStateException("Invalid configuration that explicitly sets requireExplicitAuthenticationStrategy to " + this.requireExplicitAuthenticationStrategy + " but implicitly requires it due to the following properties being set: " + String.valueOf(this.propertiesThatRequireImplicitAuthentication));
        }
        return this.requireExplicitAuthenticationStrategy;
    }

    private SessionManagementFilter createSessionManagementFilter(H http) {
        AuthenticationTrustResolver trustResolver;
        AuthenticationFailureHandler failureHandler;
        InvalidSessionStrategy strategy;
        if (this.shouldRequireExplicitAuthenticationStrategy()) {
            return null;
        }
        SecurityContextRepository securityContextRepository = this.sessionManagementSecurityContextRepository;
        SessionManagementFilter sessionManagementFilter = new SessionManagementFilter(securityContextRepository, this.getSessionAuthenticationStrategy(http));
        if (this.sessionAuthenticationErrorUrl != null) {
            sessionManagementFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler(this.sessionAuthenticationErrorUrl));
        }
        if ((strategy = this.getInvalidSessionStrategy()) != null) {
            sessionManagementFilter.setInvalidSessionStrategy(strategy);
        }
        if ((failureHandler = this.getSessionAuthenticationFailureHandler()) != null) {
            sessionManagementFilter.setAuthenticationFailureHandler(failureHandler);
        }
        if ((trustResolver = http.getSharedObject(AuthenticationTrustResolver.class)) != null) {
            sessionManagementFilter.setTrustResolver(trustResolver);
        }
        sessionManagementFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        return this.postProcess(sessionManagementFilter);
    }

    private ConcurrentSessionFilter createConcurrencyFilter(H http) {
        List<LogoutHandler> logoutHandlers;
        SessionInformationExpiredStrategy expireStrategy = this.getExpiredSessionStrategy();
        SessionRegistry sessionRegistry = this.getSessionRegistry(http);
        ConcurrentSessionFilter concurrentSessionFilter = expireStrategy != null ? new ConcurrentSessionFilter(sessionRegistry, expireStrategy) : new ConcurrentSessionFilter(sessionRegistry);
        LogoutConfigurer logoutConfigurer = http.getConfigurer(LogoutConfigurer.class);
        if (logoutConfigurer != null && !CollectionUtils.isEmpty(logoutHandlers = logoutConfigurer.getLogoutHandlers())) {
            concurrentSessionFilter.setLogoutHandlers(logoutHandlers);
        }
        concurrentSessionFilter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        return concurrentSessionFilter;
    }

    InvalidSessionStrategy getInvalidSessionStrategy() {
        if (this.invalidSessionStrategy != null) {
            return this.invalidSessionStrategy;
        }
        if (this.invalidSessionUrl == null) {
            return null;
        }
        this.invalidSessionStrategy = new SimpleRedirectInvalidSessionStrategy(this.invalidSessionUrl);
        return this.invalidSessionStrategy;
    }

    SessionInformationExpiredStrategy getExpiredSessionStrategy() {
        if (this.expiredSessionStrategy != null) {
            return this.expiredSessionStrategy;
        }
        if (this.expiredUrl == null) {
            return null;
        }
        this.expiredSessionStrategy = new SimpleRedirectSessionInformationExpiredStrategy(this.expiredUrl);
        return this.expiredSessionStrategy;
    }

    AuthenticationFailureHandler getSessionAuthenticationFailureHandler() {
        if (this.sessionAuthenticationFailureHandler != null) {
            return this.sessionAuthenticationFailureHandler;
        }
        if (this.sessionAuthenticationErrorUrl == null) {
            return null;
        }
        this.sessionAuthenticationFailureHandler = new SimpleUrlAuthenticationFailureHandler(this.sessionAuthenticationErrorUrl);
        return this.sessionAuthenticationFailureHandler;
    }

    SessionCreationPolicy getSessionCreationPolicy() {
        if (this.sessionPolicy != null) {
            return this.sessionPolicy;
        }
        SessionCreationPolicy sessionPolicy = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(SessionCreationPolicy.class);
        return sessionPolicy != null ? sessionPolicy : SessionCreationPolicy.IF_REQUIRED;
    }

    private boolean isAllowSessionCreation() {
        SessionCreationPolicy sessionPolicy = this.getSessionCreationPolicy();
        return SessionCreationPolicy.ALWAYS == sessionPolicy || SessionCreationPolicy.IF_REQUIRED == sessionPolicy;
    }

    private boolean isStateless() {
        SessionCreationPolicy sessionPolicy = this.getSessionCreationPolicy();
        return SessionCreationPolicy.STATELESS == sessionPolicy;
    }

    private SessionAuthenticationStrategy getSessionAuthenticationStrategy(H http) {
        if (this.sessionAuthenticationStrategy != null) {
            return this.sessionAuthenticationStrategy;
        }
        List<SessionAuthenticationStrategy> delegateStrategies = this.sessionAuthenticationStrategies;
        SessionAuthenticationStrategy defaultSessionAuthenticationStrategy = this.providedSessionAuthenticationStrategy == null ? this.postProcess(this.sessionFixationAuthenticationStrategy) : this.providedSessionAuthenticationStrategy;
        if (this.isConcurrentSessionControlEnabled()) {
            SessionRegistry sessionRegistry = this.getSessionRegistry(http);
            ConcurrentSessionControlAuthenticationStrategy concurrentSessionControlStrategy = new ConcurrentSessionControlAuthenticationStrategy(sessionRegistry);
            concurrentSessionControlStrategy.setMaximumSessions(this.maximumSessions.intValue());
            concurrentSessionControlStrategy.setExceptionIfMaximumExceeded(this.maxSessionsPreventsLogin);
            concurrentSessionControlStrategy = this.postProcess(concurrentSessionControlStrategy);
            RegisterSessionAuthenticationStrategy registerSessionStrategy = new RegisterSessionAuthenticationStrategy(sessionRegistry);
            registerSessionStrategy = this.postProcess(registerSessionStrategy);
            delegateStrategies.addAll(Arrays.asList(concurrentSessionControlStrategy, defaultSessionAuthenticationStrategy, registerSessionStrategy));
        } else {
            delegateStrategies.add(defaultSessionAuthenticationStrategy);
        }
        this.sessionAuthenticationStrategy = (SessionAuthenticationStrategy)this.postProcess(new CompositeSessionAuthenticationStrategy(delegateStrategies));
        return this.sessionAuthenticationStrategy;
    }

    private SessionRegistry getSessionRegistry(H http) {
        if (this.sessionRegistry == null) {
            this.sessionRegistry = this.getBeanOrNull(SessionRegistry.class);
        }
        if (this.sessionRegistry == null) {
            SessionRegistryImpl sessionRegistry = new SessionRegistryImpl();
            this.registerDelegateApplicationListener(http, (ApplicationListener<?>)sessionRegistry);
            this.sessionRegistry = sessionRegistry;
        }
        return this.sessionRegistry;
    }

    private void registerDelegateApplicationListener(H http, ApplicationListener<?> delegate) {
        DelegatingApplicationListener delegating = this.getBeanOrNull(DelegatingApplicationListener.class);
        if (delegating == null) {
            return;
        }
        GenericApplicationListenerAdapter smartListener = new GenericApplicationListenerAdapter(delegate);
        delegating.addListener((SmartApplicationListener)smartListener);
    }

    private boolean isConcurrentSessionControlEnabled() {
        return this.maximumSessions != null;
    }

    private static SessionAuthenticationStrategy createDefaultSessionFixationProtectionStrategy() {
        return new ChangeSessionIdAuthenticationStrategy();
    }

    private <T> T getBeanOrNull(Class<T> type) {
        ApplicationContext context = ((HttpSecurityBuilder)this.getBuilder()).getSharedObject(ApplicationContext.class);
        if (context == null) {
            return null;
        }
        try {
            return (T)context.getBean(type);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    public final class SessionFixationConfigurer {
        public SessionManagementConfigurer<H> newSession() {
            SessionFixationProtectionStrategy sessionFixationProtectionStrategy = new SessionFixationProtectionStrategy();
            sessionFixationProtectionStrategy.setMigrateSessionAttributes(false);
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)sessionFixationProtectionStrategy);
            return SessionManagementConfigurer.this;
        }

        public SessionManagementConfigurer<H> migrateSession() {
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)new SessionFixationProtectionStrategy());
            return SessionManagementConfigurer.this;
        }

        public SessionManagementConfigurer<H> changeSessionId() {
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)new ChangeSessionIdAuthenticationStrategy());
            return SessionManagementConfigurer.this;
        }

        public SessionManagementConfigurer<H> none() {
            SessionManagementConfigurer.this.setSessionFixationAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
            return SessionManagementConfigurer.this;
        }
    }

    public final class ConcurrencyControlConfigurer {
        private ConcurrencyControlConfigurer() {
        }

        public ConcurrencyControlConfigurer maximumSessions(int maximumSessions) {
            SessionManagementConfigurer.this.maximumSessions = maximumSessions;
            return this;
        }

        public ConcurrencyControlConfigurer expiredUrl(String expiredUrl) {
            SessionManagementConfigurer.this.expiredUrl = expiredUrl;
            return this;
        }

        public ConcurrencyControlConfigurer expiredSessionStrategy(SessionInformationExpiredStrategy expiredSessionStrategy) {
            SessionManagementConfigurer.this.expiredSessionStrategy = expiredSessionStrategy;
            return this;
        }

        public ConcurrencyControlConfigurer maxSessionsPreventsLogin(boolean maxSessionsPreventsLogin) {
            SessionManagementConfigurer.this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
            return this;
        }

        public ConcurrencyControlConfigurer sessionRegistry(SessionRegistry sessionRegistry) {
            SessionManagementConfigurer.this.sessionRegistry = sessionRegistry;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public SessionManagementConfigurer<H> and() {
            return SessionManagementConfigurer.this;
        }
    }
}

