/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.jgroups.Address;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.logging.Log;
import org.jgroups.protocols.FILE_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.Util;

@Experimental
public class SWIFT_PING
extends FILE_PING {
    protected SwiftClient swiftClient;
    @Property(description="Authentication url")
    protected String auth_url;
    @Property(description="Authentication type")
    protected String auth_type = "keystone_v_2_0";
    @Property(description="Openstack Keystone tenant name")
    protected String tenant;
    @Property(description="Username")
    protected String username;
    @Property(description="Password", exposeAsManagedAttribute=false)
    protected String password;
    @Property(description="Name of the root container")
    protected String container = "jgroups";

    @Override
    public void init() throws Exception {
        Utils.validateNotEmpty(this.auth_url, "auth_url");
        Utils.validateNotEmpty(this.auth_type, "auth_type");
        Utils.validateNotEmpty(this.username, "username");
        Utils.validateNotEmpty(this.password, "password");
        Utils.validateNotEmpty(this.container, "container");
        Authenticator authenticator = this.createAuthenticator();
        authenticator.validateParams();
        this.swiftClient = new SwiftClient(authenticator, this.log);
        this.swiftClient.authenticate();
        super.init();
    }

    private Authenticator createAuthenticator() throws Exception {
        AUTH_TYPE authType = AUTH_TYPE.getByConfigName(this.auth_type);
        if (authType == null) {
            throw new IllegalArgumentException("Invalid 'auth_type' : " + this.auth_type);
        }
        URL authUrl = new URL(this.auth_url);
        Keystone_V_2_0_Auth authenticator = null;
        switch (authType.ordinal()) {
            case 0: {
                authenticator = new Keystone_V_2_0_Auth(this.tenant, authUrl, this.username, this.password);
                break;
            }
            default: {
                throw new IllegalStateException("Could not select authenticator");
            }
        }
        return authenticator;
    }

    @Override
    protected void createRootDir() {
        try {
            this.swiftClient.createContainer(this.container);
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailureCreatingContainer"), e);
        }
    }

    @Override
    protected void readAll(List<Address> members, String clustername, Responses responses) {
        try {
            List<String> objects = this.swiftClient.listObjects(this.container);
            for (String object : objects) {
                List<PingData> list = null;
                byte[] bytes = this.swiftClient.readObject(this.container, object);
                list = this.read(new ByteArrayInputStream(bytes));
                if (list == null) {
                    this.log.warn("failed reading " + object);
                    continue;
                }
                for (PingData data : list) {
                    if (members == null || members.contains(data.getAddress())) {
                        responses.addResponse(data, data.isCoord());
                    }
                    if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                    this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
                }
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("ErrorUnmarshallingObject"), e);
        }
    }

    @Override
    protected void write(List<PingData> list, String clustername) {
        try {
            String filename = clustername + "/" + SWIFT_PING.addressToFilename(this.local_addr);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
            this.write(list, out);
            byte[] data = out.toByteArray();
            this.swiftClient.createObject(this.container, filename, data);
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("ErrorMarshallingObject"), e);
        }
    }

    @Override
    protected void remove(String clustername, Address addr) {
        String fileName = clustername + "/" + SWIFT_PING.addressToFilename(addr);
        try {
            this.swiftClient.deleteObject(this.container, fileName);
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailureRemovingData"), e);
        }
    }

    @Override
    protected void removeAll(String clustername) {
        try {
            List<String> objects = this.swiftClient.listObjects(this.container);
            for (String objName : objects) {
                this.swiftClient.deleteObject(this.container, objName);
            }
        }
        catch (Exception t) {
            this.log.error(Util.getMessage("FailedRemovingObjects"), t);
        }
    }

    private static class Utils {
        private Utils() {
        }

        public static void validateNotEmpty(String arg, String argname) {
            if (arg == null || arg.trim().isEmpty()) {
                throw new IllegalArgumentException("'" + argname + "' cannot be empty");
            }
        }

        public static boolean isSuccessCode(int code) {
            return code >= 200 && code < 300;
        }

        public static boolean isAuthDenied(int code) {
            return code == 401;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static HttpResponse doOperation(HttpURLConnection urlConnection, byte[] inputData, boolean hasOutput) throws IOException {
            HttpResponse response = null;
            Closeable inputStream = null;
            OutputStream outputStream = null;
            byte[] payload = null;
            try {
                if (inputData != null) {
                    urlConnection.setDoOutput(true);
                    outputStream = urlConnection.getOutputStream();
                    outputStream.write(inputData);
                }
                int responseCode = urlConnection.getResponseCode();
                if (hasOutput && Utils.isSuccessCode(responseCode)) {
                    payload = Utils.getBytes(urlConnection.getInputStream());
                }
                response = new HttpResponse(urlConnection.getHeaderFields(), responseCode, payload);
            }
            catch (Throwable throwable) {
                Util.close(inputStream);
                Util.close(outputStream);
                throw throwable;
            }
            Util.close(inputStream);
            Util.close((Closeable)outputStream);
            return response;
        }

        public static byte[] getBytes(InputStream inputStream) throws IOException {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }

        public static HttpResponse doVoidOperation(HttpURLConnection urlConnection) throws IOException {
            return Utils.doOperation(urlConnection, null, false);
        }

        public static HttpResponse doSendOperation(HttpURLConnection urlConnection, byte[] content) throws IOException {
            return Utils.doOperation(urlConnection, content, false);
        }

        public static HttpResponse doReadOperation(HttpURLConnection urlConnection) throws IOException {
            return Utils.doOperation(urlConnection, null, true);
        }
    }

    private static interface Authenticator {
        public void validateParams();

        public Credentials authenticate() throws Exception;
    }

    protected static class SwiftClient {
        private final Authenticator authenticator;
        private volatile Credentials credentials;
        private final Log log;

        public SwiftClient(Authenticator authenticator, Log l) {
            this.authenticator = authenticator;
            this.log = l;
        }

        public void authenticate() throws Exception {
            this.credentials = this.authenticator.authenticate();
        }

        public void deleteObject(String containerName, String objectName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, objectName).method("DELETE").getConnection();
            HttpResponse response = Utils.doVoidOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    this.log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.deleteObject(containerName, objectName);
                } else {
                    this.log.error(Util.getMessage("ErrorDeletingObject") + objectName + " from container " + containerName + ",code = " + response.code);
                }
            }
        }

        public void createContainer(String containerName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, null).method("PUT").getConnection();
            HttpResponse response = Utils.doVoidOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    this.log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.createContainer(containerName);
                } else {
                    this.log.error(Util.getMessage("ErrorCreatingContainer") + containerName + " ,code = " + response.code);
                }
            }
        }

        public void createObject(String containerName, String objectName, byte[] contents) throws Exception {
            HttpURLConnection conn = this.getConnBuilder(containerName, objectName).method("PUT").addHeader("Content-Length", String.valueOf(contents.length)).getConnection();
            HttpResponse response = Utils.doSendOperation(conn, contents);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    this.log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    this.createObject(containerName, objectName, contents);
                } else {
                    this.log.error(Util.getMessage("ErrorCreatingObject") + objectName + " in container " + containerName + ",code = " + response.code);
                }
            }
        }

        public byte[] readObject(String containerName, String objectName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, objectName).getConnection();
            HttpResponse response = Utils.doReadOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    this.log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    return this.readObject(containerName, objectName);
                }
                this.log.error(Util.getMessage("ErrorReadingObject") + objectName + " from container " + containerName + ", code = " + response.code);
            }
            return response.payload;
        }

        public List<String> listObjects(String containerName) throws Exception {
            HttpURLConnection urlConnection = this.getConnBuilder(containerName, null).getConnection();
            HttpResponse response = Utils.doReadOperation(urlConnection);
            if (!response.isSuccessCode()) {
                if (response.isAuthDenied()) {
                    this.log.warn("Refreshing credentials and retrying");
                    this.authenticate();
                    return this.listObjects(containerName);
                }
                this.log.error(Util.getMessage("ErrorListingContainer") + containerName + ", code = " + response.code);
            }
            return response.payloadAsLines();
        }

        private ConnBuilder getConnBuilder(String container, String object) throws IOException {
            ConnBuilder connBuilder = new ConnBuilder(this.credentials, container, object);
            connBuilder.addHeader("X-Storage-Token", this.credentials.authToken);
            connBuilder.addHeader("Accept", "*/*");
            return connBuilder;
        }
    }

    private static enum AUTH_TYPE {
        KEYSTONE_V_2_0("keystone_v_2_0");

        private static final Map<String, AUTH_TYPE> LOOKUP;
        private final String configName;

        private AUTH_TYPE(String externalName) {
            this.configName = externalName;
        }

        public static AUTH_TYPE getByConfigName(String configName) {
            return LOOKUP.get(configName);
        }

        static {
            LOOKUP = new HashMap<String, AUTH_TYPE>();
            for (AUTH_TYPE type : EnumSet.allOf(AUTH_TYPE.class)) {
                LOOKUP.put(type.configName, type);
            }
        }
    }

    private static class Keystone_V_2_0_Auth
    implements Authenticator {
        private static final String JSON_RESPONSE_PARSING_SCRIPT = "var response = JSON.parse(json);var result = {};result.id = response.access.token.id;var serviceCatalog = response.access.serviceCatalog;for (var i = 0; i < serviceCatalog.length; i++) {    var service = serviceCatalog[i];    if (service.type == \"object-store\") {        result.url = service.endpoints[0].publicURL;        break;    }}result;";
        private static final Object scriptEngineLock = new Object();
        private static ScriptEngine scriptEngine;
        private final String tenant;
        private final URL authUrl;
        private final String username;
        private final String password;

        public Keystone_V_2_0_Auth(String tenant, URL authUrl, String username, String password) {
            this.tenant = tenant;
            this.authUrl = authUrl;
            this.username = username;
            this.password = password;
        }

        @Override
        public void validateParams() {
            Utils.validateNotEmpty(this.tenant, "tenant");
        }

        @Override
        public Credentials authenticate() throws Exception {
            HttpURLConnection urlConnection = new ConnBuilder(this.authUrl).addHeader("Content-type", "application/json").addHeader("Accept", "application/json").getConnection();
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append("{\"auth\": {\"tenantName\": \"").append(this.tenant).append("\", \"passwordCredentials\": {\"username\": \"").append(this.username).append("\", \"password\": \"").append(this.password).append("\"}}}");
            HttpResponse response = Utils.doOperation(urlConnection, jsonBuilder.toString().getBytes(), true);
            if (response.isSuccessCode()) {
                Map<String, String> result = Keystone_V_2_0_Auth.parseJsonResponse(new String(response.payload, StandardCharsets.UTF_8));
                String authToken = result.get("id");
                String storageUrl = result.get("url");
                if (authToken == null) {
                    throw new IllegalStateException("Missing token id in authentication response");
                }
                if (storageUrl == null) {
                    throw new IllegalStateException("Missing storage service URL in authentication response");
                }
                return new Credentials(authToken, storageUrl);
            }
            throw new IllegalStateException("Error authenticating to the service. Please check your credentials. Code = " + response.code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static Map<String, String> parseJsonResponse(String json) throws ScriptException {
            Object object = scriptEngineLock;
            synchronized (object) {
                if (scriptEngine == null && (scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript")) == null) {
                    throw new RuntimeException("Failed to load JavaScript script engine");
                }
                SimpleBindings bindings = new SimpleBindings();
                bindings.put("json", (Object)json);
                return (Map)scriptEngine.eval(JSON_RESPONSE_PARSING_SCRIPT, (Bindings)bindings);
            }
        }
    }

    private static class HttpResponse {
        private final Map<String, List<String>> headers;
        private final int code;
        private final byte[] payload;

        HttpResponse(Map<String, List<String>> headers, int code, byte[] payload) {
            this.headers = headers;
            this.code = code;
            this.payload = payload;
        }

        public List<String> payloadAsLines() throws IOException {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.payload)));
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            in.close();
            return lines;
        }

        public boolean isSuccessCode() {
            return Utils.isSuccessCode(this.code);
        }

        public boolean isAuthDenied() {
            return Utils.isAuthDenied(this.code);
        }
    }

    private static class ConnBuilder {
        private final HttpURLConnection con;

        public ConnBuilder(URL url) throws IOException {
            this.con = (HttpURLConnection)url.openConnection();
        }

        public ConnBuilder(Credentials credentials, String container, String object) throws IOException {
            String url = credentials.storageUrl + "/" + container;
            if (object != null) {
                url = url + "/" + object;
            }
            this.con = (HttpURLConnection)new URL(url).openConnection();
        }

        public ConnBuilder method(String method) throws ProtocolException {
            this.con.setRequestMethod(method);
            return this;
        }

        public ConnBuilder addHeader(String key, String value) {
            this.con.setRequestProperty(key, value);
            return this;
        }

        public HttpURLConnection getConnection() {
            return this.con;
        }
    }

    private static class Credentials {
        private final String authToken;
        private final String storageUrl;

        public Credentials(String authToken, String storageUrl) {
            this.authToken = authToken;
            this.storageUrl = storageUrl;
        }
    }

    private static class HttpHeaders {
        private static final String CONTENT_TYPE_HEADER = "Content-type";
        private static final String ACCEPT_HEADER = "Accept";
        private static final String STORAGE_TOKEN_HEADER = "X-Storage-Token";
        private static final String CONTENT_LENGTH_HEADER = "Content-Length";

        private HttpHeaders() {
        }
    }
}

