/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MapsId;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AttributeBinderType;
import org.hibernate.annotations.CompositeType;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.LazyGroup;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.ValueGenerationType;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.binder.AttributeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.AnyBinder;
import org.hibernate.boot.model.internal.BasicValueBinder;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CannotForceNonNullableException;
import org.hibernate.boot.model.internal.ClassPropertyHolder;
import org.hibernate.boot.model.internal.CollectionBinder;
import org.hibernate.boot.model.internal.ColumnsBuilder;
import org.hibernate.boot.model.internal.EmbeddableBinder;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyInferredData;
import org.hibernate.boot.model.internal.PropertyPreloadedData;
import org.hibernate.boot.model.internal.TimeZoneStorageHelper;
import org.hibernate.boot.model.internal.ToOneBinder;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.usertype.CompositeUserType;
import org.jboss.logging.Logger;

public class PropertyBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)PropertyBinder.class.getName());
    private MetadataBuildingContext buildingContext;
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private String lazyGroup;
    private AccessType accessType;
    private AnnotatedColumns columns;
    private PropertyHolder holder;
    private Value value;
    private boolean insertable = true;
    private boolean updatable = true;
    private String cascade;
    private BasicValueBinder basicValueBinder;
    private XClass declaringClass;
    private boolean declaringClassSet;
    private boolean embedded;
    private EntityBinder entityBinder;
    private boolean toMany;
    private String referencedEntityName;
    private XProperty property;
    private XClass returnedClass;
    private boolean isId;
    private Map<XClass, InheritanceState> inheritanceStatePerClass;

    public void setReferencedEntityName(String referencedEntityName) {
        this.referencedEntityName = referencedEntityName;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setEntityBinder(EntityBinder entityBinder) {
        this.entityBinder = entityBinder;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setLazyGroup(String lazyGroup) {
        this.lazyGroup = lazyGroup;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public void setColumns(AnnotatedColumns columns) {
        this.columns = columns;
    }

    public void setHolder(PropertyHolder holder) {
        this.holder = holder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setCascade(String cascadeStrategy) {
        this.cascade = cascadeStrategy;
    }

    public void setBuildingContext(MetadataBuildingContext buildingContext) {
        this.buildingContext = buildingContext;
    }

    public void setDeclaringClass(XClass declaringClass) {
        this.declaringClass = declaringClass;
        this.declaringClassSet = true;
    }

    private boolean isToOneValue(Value value) {
        return value instanceof ToOne;
    }

    public void setProperty(XProperty property) {
        this.property = property;
    }

    public void setReturnedClass(XClass returnedClass) {
        this.returnedClass = returnedClass;
    }

    public BasicValueBinder getBasicValueBinder() {
        return this.basicValueBinder;
    }

    public Value getValue() {
        return this.value;
    }

    public void setId(boolean id) {
        this.isId = id;
    }

    public boolean isId() {
        return this.isId;
    }

    public void setInheritanceStatePerClass(Map<XClass, InheritanceState> inheritanceStatePerClass) {
        this.inheritanceStatePerClass = inheritanceStatePerClass;
    }

    private void validateBind() {
        if (!this.declaringClassSet) {
            throw new AssertionFailure("declaringClass has not been set before a bind");
        }
    }

    private void validateMake() {
    }

    private Property makePropertyAndValue() {
        this.validateBind();
        LOG.debugf("MetadataSourceProcessor property %s with lazy=%s", this.name, this.lazy);
        String containerClassName = this.holder.getClassName();
        this.holder.startingProperty(this.property);
        this.basicValueBinder = new BasicValueBinder(BasicValueBinder.Kind.ATTRIBUTE, this.buildingContext);
        this.basicValueBinder.setPropertyName(this.name);
        this.basicValueBinder.setReturnedClassName(this.returnedClassName);
        this.basicValueBinder.setColumns(this.columns);
        this.basicValueBinder.setPersistentClassName(containerClassName);
        this.basicValueBinder.setType(this.property, this.returnedClass, containerClassName, this.holder.resolveAttributeConverterDescriptor(this.property));
        this.basicValueBinder.setReferencedEntityName(this.referencedEntityName);
        this.basicValueBinder.setAccessType(this.accessType);
        this.value = this.basicValueBinder.make();
        return this.makeProperty();
    }

    private void callAttributeBinders(Property prop) {
        for (Annotation containingAnnotation : HCANNHelper.findContainingAnnotations((XAnnotatedElement)this.property, AttributeBinderType.class)) {
            AttributeBinderType binderType = containingAnnotation.annotationType().getAnnotation(AttributeBinderType.class);
            try {
                AttributeBinder<?> binder = binderType.binder().newInstance();
                binder.bind(containingAnnotation, this.buildingContext, this.entityBinder.getPersistentClass(), prop);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @AttributeBinderType annotation '" + containingAnnotation + "'", e);
            }
        }
    }

    public Property makePropertyAndBind() {
        return this.bind(this.makeProperty());
    }

    public Property makePropertyValueAndBind() {
        return this.bind(this.makePropertyAndValue());
    }

    public void setToMany(boolean toMany) {
        this.toMany = toMany;
    }

    private Property bind(Property property) {
        if (this.isId) {
            RootClass rootClass = (RootClass)this.holder.getPersistentClass();
            if (this.toMany || this.entityBinder.wrapIdsInEmbeddedComponents()) {
                this.getOrCreateCompositeId(rootClass).addProperty(property);
            } else {
                rootClass.setIdentifier((KeyValue)this.getValue());
                if (this.embedded) {
                    rootClass.setEmbeddedIdentifier(true);
                } else {
                    rootClass.setIdentifierProperty(property);
                    MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(this.declaringClass, this.inheritanceStatePerClass, this.buildingContext);
                    this.setDeclaredIdentifier(rootClass, superclass, property);
                }
            }
        } else {
            this.holder.addProperty(property, this.columns, this.declaringClass);
        }
        if (this.buildingContext.getMetadataCollector().isInSecondPass()) {
            this.callAttributeBinders(property);
        } else {
            this.buildingContext.getMetadataCollector().addSecondPass(persistentClasses -> this.callAttributeBinders(property));
        }
        return property;
    }

    private void setDeclaredIdentifier(RootClass rootClass, MappedSuperclass superclass, Property prop) {
        ClassPropertyHolder.handleGenericComponentProperty(prop, this.buildingContext);
        if (superclass == null) {
            rootClass.setDeclaredIdentifierProperty(prop);
            return;
        }
        Class type = this.buildingContext.getBootstrapContext().getReflectionManager().toClass(this.declaringClass);
        ClassPropertyHolder.prepareActualProperty(prop, type, false, this.buildingContext, superclass::setDeclaredIdentifierProperty);
    }

    private Component getOrCreateCompositeId(RootClass rootClass) {
        Component id = (Component)rootClass.getIdentifier();
        if (id == null) {
            Component identifier = EmbeddableBinder.createEmbeddable(this.holder, new PropertyPreloadedData(null, null, null), true, false, this.resolveCustomInstantiator(this.property, this.returnedClass), this.buildingContext);
            rootClass.setIdentifier(identifier);
            identifier.setNullValue("undefined");
            rootClass.setEmbeddedIdentifier(true);
            rootClass.setIdentifierMapper(identifier);
            return identifier;
        }
        return id;
    }

    private Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> resolveCustomInstantiator(XProperty property, XClass embeddableClass) {
        if (property.isAnnotationPresent(EmbeddableInstantiator.class)) {
            return ((EmbeddableInstantiator)property.getAnnotation(EmbeddableInstantiator.class)).value();
        }
        if (embeddableClass.isAnnotationPresent(EmbeddableInstantiator.class)) {
            return ((EmbeddableInstantiator)embeddableClass.getAnnotation(EmbeddableInstantiator.class)).value();
        }
        return null;
    }

    public Property makeProperty() {
        this.validateMake();
        LOG.debugf("Building property %s", this.name);
        Property property = new Property();
        property.setName(this.name);
        property.setValue(this.value);
        property.setLazy(this.lazy);
        property.setLazyGroup(this.lazyGroup);
        property.setCascade(this.cascade);
        property.setPropertyAccessorName(this.accessType.getType());
        property.setReturnedClassName(this.returnedClassName);
        this.handleValueGeneration(property);
        this.handleNaturalId(property);
        this.handleLob(property);
        this.handleMutability(property);
        this.handleOptional(property);
        this.inferOptimisticLocking(property);
        LOG.tracev("Cascading {0} with {1}", this.name, this.cascade);
        return property;
    }

    private void handleValueGeneration(Property property) {
        if (this.property != null) {
            property.setValueGeneratorCreator(this.getValueGenerationFromAnnotations(this.property));
        }
    }

    private GeneratorCreator getValueGenerationFromAnnotations(XProperty property) {
        GeneratorCreator creator = null;
        for (Annotation annotation : property.getAnnotations()) {
            GeneratorCreator candidate = GeneratorBinder.generatorCreator(property, annotation);
            if (candidate == null) continue;
            if (creator != null) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' has multiple '@ValueGenerationType' annotations");
            }
            creator = candidate;
        }
        return creator;
    }

    private void handleLob(Property property) {
        if (this.property != null) {
            property.setLob(this.property.isAnnotationPresent(Lob.class));
        }
    }

    private void handleMutability(Property property) {
        if (this.property != null && this.property.isAnnotationPresent(Immutable.class)) {
            this.updatable = false;
        }
        property.setInsertable(this.insertable);
        property.setUpdateable(this.updatable);
    }

    private void handleOptional(Property property) {
        if (this.property != null) {
            property.setOptional(!this.isId && PropertyBinder.isOptional(this.property) && PropertyBinder.isNullable(property));
        }
    }

    private static boolean isNullable(Property property) {
        Value value = property.getValue();
        return value instanceof OneToMany || value.isNullable();
    }

    private void handleNaturalId(Property property) {
        NaturalId naturalId;
        if (this.property != null && this.entityBinder != null && (naturalId = (NaturalId)this.property.getAnnotation(NaturalId.class)) != null) {
            if (!this.entityBinder.isRootEntity()) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' belongs to an entity subclass and may not be annotated '@NaturalId' (only a property of a root '@Entity' or a '@MappedSuperclass' may be a '@NaturalId')");
            }
            if (!naturalId.mutable()) {
                this.updatable = false;
            }
            property.setNaturalIdentifier(true);
        }
    }

    private void inferOptimisticLocking(Property property) {
        if (this.value instanceof Collection) {
            property.setOptimisticLocked(((Collection)this.value).isOptimisticLocked());
        } else if (this.property != null && this.property.isAnnotationPresent(OptimisticLock.class)) {
            OptimisticLock optimisticLock = (OptimisticLock)this.property.getAnnotation(OptimisticLock.class);
            this.validateOptimisticLock(optimisticLock);
            property.setOptimisticLocked(!optimisticLock.excluded());
        } else {
            property.setOptimisticLocked(!this.isToOneValue(this.value) || this.insertable);
        }
    }

    private void validateOptimisticLock(OptimisticLock optimisticLock) {
        if (optimisticLock.excluded()) {
            if (this.property.isAnnotationPresent(Version.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Version'");
            }
            if (this.property.isAnnotationPresent(Id.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@Id'");
            }
            if (this.property.isAnnotationPresent(EmbeddedId.class)) {
                throw new AnnotationException("Property '" + StringHelper.qualify(this.holder.getPath(), this.name) + "' is annotated '@OptimisticLock(excluded=true)' and '@EmbeddedId'");
            }
        }
    }

    static int addElementsOfClass(List<PropertyData> elements, PropertyContainer propertyContainer, MetadataBuildingContext context) {
        int idPropertyCounter = 0;
        for (XProperty property : propertyContainer.propertyIterator()) {
            idPropertyCounter += PropertyBinder.addProperty(propertyContainer, property, elements, context);
        }
        return idPropertyCounter;
    }

    private static int addProperty(PropertyContainer propertyContainer, XProperty property, List<PropertyData> inFlightPropertyDataList, MetadataBuildingContext context) {
        for (PropertyData propertyData : inFlightPropertyDataList) {
            if (!propertyData.getPropertyName().equals(property.getName())) continue;
            PropertyBinder.checkIdProperty(property, propertyData);
            return 0;
        }
        XClass declaringClass = propertyContainer.getDeclaringClass();
        XClass entity = propertyContainer.getEntityAtStake();
        int idPropertyCounter = 0;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(declaringClass, property, propertyContainer.getClassLevelAccessType().getType(), context.getBootstrapContext().getReflectionManager());
        XProperty element = propertyAnnotatedElement.getProperty();
        if (PropertyBinder.hasIdAnnotation((XAnnotatedElement)element)) {
            inFlightPropertyDataList.add(0, propertyAnnotatedElement);
            PropertyBinder.handleIdProperty(propertyContainer, context, declaringClass, entity, (XAnnotatedElement)element);
            if (BinderHelper.hasToOneAnnotation((XAnnotatedElement)element)) {
                context.getMetadataCollector().addToOneAndIdProperty(entity, propertyAnnotatedElement);
            }
            ++idPropertyCounter;
        } else {
            inFlightPropertyDataList.add(propertyAnnotatedElement);
        }
        if (element.isAnnotationPresent(MapsId.class)) {
            context.getMetadataCollector().addPropertyAnnotatedWithMapsId(entity, propertyAnnotatedElement);
        }
        return idPropertyCounter;
    }

    private static void checkIdProperty(XProperty property, PropertyData propertyData) {
        Id incomingIdProperty = (Id)property.getAnnotation(Id.class);
        Id existingIdProperty = (Id)propertyData.getProperty().getAnnotation(Id.class);
        if (incomingIdProperty != null && existingIdProperty == null) {
            throw new MappingException(String.format("You cannot override the [%s] non-identifier property from the [%s] base class or @MappedSuperclass and make it an identifier in the [%s] subclass", propertyData.getProperty().getName(), propertyData.getProperty().getDeclaringClass().getName(), property.getDeclaringClass().getName()));
        }
    }

    private static void handleIdProperty(PropertyContainer propertyContainer, MetadataBuildingContext context, XClass declaringClass, XClass entity, XAnnotatedElement element) {
        if (context.getBuildingOptions().isSpecjProprietarySyntaxEnabled() && element.isAnnotationPresent(Id.class) && element.isAnnotationPresent(Column.class)) {
            String columnName = ((Column)element.getAnnotation(Column.class)).name();
            for (XProperty property : declaringClass.getDeclaredProperties(AccessType.FIELD.getType())) {
                if (property.isAnnotationPresent(MapsId.class) || !PropertyBinder.isJoinColumnPresent(columnName, property)) continue;
                context.getMetadataCollector().addPropertyAnnotatedWithMapsIdSpecj(entity, new PropertyInferredData(declaringClass, property, propertyContainer.getClassLevelAccessType().getType(), context.getBootstrapContext().getReflectionManager()), element.toString());
            }
        }
    }

    private static boolean isJoinColumnPresent(String columnName, XProperty property) {
        if (property.isAnnotationPresent(JoinColumn.class) && ((JoinColumn)property.getAnnotation(JoinColumn.class)).name().equals(columnName)) {
            return true;
        }
        if (property.isAnnotationPresent(JoinColumns.class)) {
            for (JoinColumn columnAnnotation : ((JoinColumns)property.getAnnotation(JoinColumns.class)).value()) {
                if (!columnName.equals(columnAnnotation.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasIdAnnotation(XAnnotatedElement element) {
        return element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class);
    }

    public static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) throws MappingException {
        if (PropertyBinder.alreadyProcessedBySuper(propertyHolder, inferredData, entityBinder)) {
            LOG.debugf("Skipping attribute [%s : %s] as it was already processed as part of super hierarchy", inferredData.getClassOrElementName(), inferredData.getPropertyName());
        } else {
            XProperty property;
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Processing annotations of {0}.{1}", propertyHolder.getEntityName(), inferredData.getPropertyName());
            }
            if ((property = inferredData.getProperty()).isAnnotationPresent(Parent.class)) {
                PropertyBinder.handleParentProperty(propertyHolder, inferredData, property);
            } else {
                PropertyBinder.buildProperty(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass, property, inferredData.getClassOrElement());
            }
        }
    }

    private static boolean alreadyProcessedBySuper(PropertyHolder holder, PropertyData data, EntityBinder binder) {
        return !holder.isComponent() && binder.isPropertyDefinedInSuperHierarchy(data.getPropertyName());
    }

    private static void handleParentProperty(PropertyHolder holder, PropertyData data, XProperty property) {
        if (!holder.isComponent()) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(holder, data) + "' is annotated '@Parent' but is not a member of an embeddable class");
        }
        holder.setParentProperty(property.getName());
    }

    private static void buildProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, XClass returnedClass) {
        ColumnsBuilder columnsBuilder = new ColumnsBuilder(propertyHolder, nullability, property, inferredData, entityBinder, context).extractMetadata();
        PropertyBinder propertyBinder = new PropertyBinder();
        propertyBinder.setName(inferredData.getPropertyName());
        propertyBinder.setReturnedClassName(inferredData.getTypeName());
        propertyBinder.setAccessType(inferredData.getDefaultAccess());
        propertyBinder.setHolder(propertyHolder);
        propertyBinder.setProperty(property);
        propertyBinder.setReturnedClass(inferredData.getPropertyClass());
        propertyBinder.setBuildingContext(context);
        if (isIdentifierMapper) {
            propertyBinder.setInsertable(false);
            propertyBinder.setUpdatable(false);
        }
        propertyBinder.setDeclaringClass(inferredData.getDeclaringClass());
        propertyBinder.setEntityBinder(entityBinder);
        propertyBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
        propertyBinder.setId(!entityBinder.isIgnoreIdAnnotations() && PropertyBinder.hasIdAnnotation((XAnnotatedElement)property));
        LazyGroup lazyGroupAnnotation = (LazyGroup)property.getAnnotation(LazyGroup.class);
        if (lazyGroupAnnotation != null) {
            propertyBinder.setLazyGroup(lazyGroupAnnotation.value());
        }
        AnnotatedJoinColumns joinColumns = columnsBuilder.getJoinColumns();
        AnnotatedColumns columns = PropertyBinder.bindProperty(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass, property, returnedClass, columnsBuilder, propertyBinder);
        PropertyBinder.addIndexes(inSecondPass, property, columns, joinColumns);
        PropertyBinder.addNaturalIds(inSecondPass, property, columns, joinColumns);
    }

    private static AnnotatedColumns bindProperty(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, XClass returnedClass, ColumnsBuilder columnsBuilder, PropertyBinder propertyBinder) {
        if (PropertyBinder.isVersion(property)) {
            PropertyBinder.bindVersionProperty(propertyHolder, inferredData, isIdentifierMapper, context, inheritanceStatePerClass, columnsBuilder.getColumns(), propertyBinder);
        } else if (PropertyBinder.isManyToOne(property)) {
            ToOneBinder.bindManyToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, columnsBuilder.getJoinColumns(), propertyBinder, PropertyBinder.isForcePersist(property));
        } else if (PropertyBinder.isOneToOne(property)) {
            ToOneBinder.bindOneToOne(propertyHolder, inferredData, isIdentifierMapper, inSecondPass, context, property, columnsBuilder.getJoinColumns(), propertyBinder, PropertyBinder.isForcePersist(property));
        } else if (PropertyBinder.isAny(property)) {
            AnyBinder.bindAny(propertyHolder, nullability, inferredData, entityBinder, isIdentifierMapper, context, property, columnsBuilder.getJoinColumns(), PropertyBinder.isForcePersist(property));
        } else if (PropertyBinder.isCollection(property)) {
            CollectionBinder.bindCollection(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, context, inheritanceStatePerClass, property, columnsBuilder.getJoinColumns());
        } else if (!propertyBinder.isId() || !entityBinder.isIgnoreIdAnnotations()) {
            return PropertyBinder.bindBasic(propertyHolder, nullability, inferredData, classGenerators, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, columnsBuilder, columnsBuilder.getColumns(), returnedClass, propertyBinder);
        }
        return columnsBuilder.getColumns();
    }

    private static boolean isVersion(XProperty property) {
        return property.isAnnotationPresent(Version.class);
    }

    private static boolean isOneToOne(XProperty property) {
        return property.isAnnotationPresent(OneToOne.class);
    }

    private static boolean isManyToOne(XProperty property) {
        return property.isAnnotationPresent(ManyToOne.class);
    }

    private static boolean isAny(XProperty property) {
        return property.isAnnotationPresent(Any.class);
    }

    private static boolean isCollection(XProperty property) {
        return property.isAnnotationPresent(jakarta.persistence.OneToMany.class) || property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(ElementCollection.class) || property.isAnnotationPresent(ManyToAny.class);
    }

    private static boolean isForcePersist(XProperty property) {
        return property.isAnnotationPresent(MapsId.class) || property.isAnnotationPresent(Id.class);
    }

    private static void bindVersionProperty(PropertyHolder propertyHolder, PropertyData inferredData, boolean isIdentifierMapper, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, AnnotatedColumns columns, PropertyBinder propertyBinder) {
        PropertyBinder.checkVersionProperty(propertyHolder, isIdentifierMapper);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("{0} is a version property", inferredData.getPropertyName());
        }
        RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
        propertyBinder.setColumns(columns);
        Property property = propertyBinder.makePropertyValueAndBind();
        propertyBinder.getBasicValueBinder().setVersion(true);
        rootClass.setVersion(property);
        MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, context);
        if (superclass != null) {
            superclass.setDeclaredVersion(property);
        } else {
            rootClass.setDeclaredVersion(property);
        }
        ((SimpleValue)property.getValue()).setNullValue("undefined");
        rootClass.setOptimisticLockStyle(OptimisticLockStyle.VERSION);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Version name: {0}, unsavedValue: {1}", rootClass.getVersion().getName(), ((SimpleValue)rootClass.getVersion().getValue()).getNullValue());
        }
    }

    private static void checkVersionProperty(PropertyHolder propertyHolder, boolean isIdentifierMapper) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Class '" + propertyHolder.getEntityName() + "' is annotated '@IdClass' and may not have a property annotated '@Version'");
        }
        if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
            throw new AnnotationException("Entity '" + propertyHolder.getEntityName() + "' is a subclass in an entity class hierarchy and may not have a property annotated '@Version'");
        }
        if (!propertyHolder.isEntity()) {
            throw new AnnotationException("Embedded class '" + propertyHolder.getEntityName() + "' may not have a property annotated '@Version'");
        }
    }

    private static AnnotatedColumns bindBasic(PropertyHolder propertyHolder, Nullability nullability, PropertyData inferredData, Map<String, IdentifierGeneratorDefinition> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, ColumnsBuilder columnsBuilder, AnnotatedColumns columns, XClass returnedClass, PropertyBinder propertyBinder) {
        AnnotatedColumns actualColumns;
        boolean isComposite;
        boolean isOverridden;
        if (propertyBinder.isId() || propertyHolder.isOrWithinEmbeddedId() || propertyHolder.isInIdClass()) {
            PropertyData overridingProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
            if (overridingProperty != null) {
                isOverridden = true;
                InheritanceState state = inheritanceStatePerClass.get(overridingProperty.getClassOrElement());
                isComposite = state != null ? state.hasIdClassOrEmbeddedId() : EmbeddableBinder.isEmbedded(property, returnedClass);
                actualColumns = columnsBuilder.overrideColumnFromMapperOrMapsIdProperty(propertyBinder.isId());
            } else {
                isOverridden = false;
                isComposite = EmbeddableBinder.isEmbedded(property, returnedClass);
                actualColumns = columns;
            }
        } else {
            isOverridden = false;
            isComposite = EmbeddableBinder.isEmbedded(property, returnedClass);
            actualColumns = columns;
        }
        Class<? extends CompositeUserType<?>> compositeUserType = PropertyBinder.resolveCompositeUserType(inferredData, context);
        if (isComposite || compositeUserType != null) {
            propertyBinder = EmbeddableBinder.createCompositeBinder(propertyHolder, inferredData, entityBinder, isIdentifierMapper, isComponentEmbedded, context, inheritanceStatePerClass, property, actualColumns, returnedClass, propertyBinder, isOverridden, compositeUserType);
        } else {
            if (property.isCollection() && property.getElementClass() != null && EmbeddableBinder.isEmbedded(property, property.getElementClass())) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is mapped as basic aggregate component array, but this is not yet supported.");
            }
            PropertyBinder.createBasicBinder(propertyHolder, inferredData, nullability, context, property, actualColumns, propertyBinder, isOverridden);
        }
        if (isOverridden) {
            PropertyBinder.handleGeneratorsForOverriddenId(propertyHolder, classGenerators, context, property, propertyBinder);
        } else if (propertyBinder.isId()) {
            PropertyBinder.processId(propertyHolder, inferredData, (SimpleValue)propertyBinder.getValue(), classGenerators, isIdentifierMapper, context);
        }
        return actualColumns;
    }

    private static void handleGeneratorsForOverriddenId(PropertyHolder propertyHolder, Map<String, IdentifierGeneratorDefinition> classGenerators, MetadataBuildingContext context, XProperty property, PropertyBinder propertyBinder) {
        PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
        IdentifierGeneratorDefinition foreignGenerator = GeneratorBinder.createForeignGenerator(mapsIdProperty);
        if (BinderHelper.isGlobalGeneratorNameGlobal(context)) {
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, foreignGenerator));
        } else {
            HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
            generators.put(foreignGenerator.getName(), foreignGenerator);
            GeneratorBinder.makeIdGenerator((SimpleValue)propertyBinder.getValue(), property, foreignGenerator.getStrategy(), foreignGenerator.getName(), context, generators);
        }
    }

    private static void createBasicBinder(PropertyHolder propertyHolder, PropertyData inferredData, Nullability nullability, MetadataBuildingContext context, XProperty property, AnnotatedColumns columns, PropertyBinder propertyBinder, boolean isOverridden) {
        if (PropertyBinder.shouldForceNotNull(nullability, propertyBinder, PropertyBinder.isExplicitlyOptional(property))) {
            PropertyBinder.forceColumnsNotNull(propertyHolder, inferredData, columns, propertyBinder);
        }
        propertyBinder.setLazy(PropertyBinder.isLazy(property));
        propertyBinder.setColumns(columns);
        if (isOverridden) {
            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
            propertyBinder.setReferencedEntityName(mapsIdProperty.getClassOrElementName());
        }
        propertyBinder.makePropertyValueAndBind();
    }

    private static void forceColumnsNotNull(PropertyHolder holder, PropertyData data, AnnotatedColumns columns, PropertyBinder binder) {
        for (AnnotatedColumn column : columns.getColumns()) {
            if (binder.isId() && column.isFormula()) {
                throw new CannotForceNonNullableException("Identifier property '" + BinderHelper.getPath(holder, data) + "' cannot map to a '@Formula'");
            }
            column.forceNotNull();
        }
    }

    private static boolean shouldForceNotNull(Nullability nullability, PropertyBinder binder, boolean optional) {
        return binder.isId() || !optional && nullability != Nullability.FORCED_NULL;
    }

    private static boolean isExplicitlyOptional(XProperty property) {
        return !property.isAnnotationPresent(Basic.class) || ((Basic)property.getAnnotation(Basic.class)).optional();
    }

    private static boolean isOptional(XProperty property) {
        return property.isAnnotationPresent(Basic.class) ? ((Basic)property.getAnnotation(Basic.class)).optional() : property.isArray() || !property.getClassOrElementClass().isPrimitive();
    }

    private static boolean isLazy(XProperty property) {
        return property.isAnnotationPresent(Basic.class) && ((Basic)property.getAnnotation(Basic.class)).fetch() == FetchType.LAZY;
    }

    private static void addIndexes(boolean inSecondPass, XProperty property, AnnotatedColumns columns, AnnotatedJoinColumns joinColumns) {
        block2: {
            Index index;
            block3: {
                index = (Index)property.getAnnotation(Index.class);
                if (index == null) break block2;
                if (joinColumns == null) break block3;
                for (AnnotatedColumn column : joinColumns.getColumns()) {
                    column.addIndex(index, inSecondPass);
                }
                break block2;
            }
            if (columns == null) break block2;
            for (AnnotatedColumn column : columns.getColumns()) {
                column.addIndex(index, inSecondPass);
            }
        }
    }

    private static void addNaturalIds(boolean inSecondPass, XProperty property, AnnotatedColumns columns, AnnotatedJoinColumns joinColumns) {
        block4: {
            NaturalId naturalId = (NaturalId)property.getAnnotation(NaturalId.class);
            if (naturalId == null) break block4;
            if (joinColumns != null) {
                String keyName = "UK_" + Constraint.hashedName(joinColumns.getTable().getName() + "_NaturalID");
                for (AnnotatedColumn column : joinColumns.getColumns()) {
                    column.addUniqueKey(keyName, inSecondPass);
                }
            } else {
                String keyName = "UK_" + Constraint.hashedName(columns.getTable().getName() + "_NaturalID");
                for (AnnotatedColumn column : columns.getColumns()) {
                    column.addUniqueKey(keyName, inSecondPass);
                }
            }
        }
    }

    private static Class<? extends CompositeUserType<?>> resolveCompositeUserType(PropertyData inferredData, MetadataBuildingContext context) {
        Class embeddableClass;
        XProperty property = inferredData.getProperty();
        XClass returnedClass = inferredData.getClassOrElement();
        if (property != null) {
            CompositeType compositeType = HCANNHelper.findAnnotation((XAnnotatedElement)property, CompositeType.class);
            if (compositeType != null) {
                return compositeType.value();
            }
            Class<? extends CompositeUserType<?>> compositeUserType = TimeZoneStorageHelper.resolveTimeZoneStorageCompositeUserType(property, returnedClass, context);
            if (compositeUserType != null) {
                return compositeUserType;
            }
        }
        if (returnedClass != null && (embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass)) != null) {
            return context.getMetadataCollector().findRegisteredCompositeUserType(embeddableClass);
        }
        return null;
    }

    private static void processId(PropertyHolder propertyHolder, PropertyData inferredData, SimpleValue idValue, Map<String, IdentifierGeneratorDefinition> classGenerators, boolean isIdentifierMapper, MetadataBuildingContext context) {
        if (isIdentifierMapper) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' belongs to an '@IdClass' and may not be annotated '@Id' or '@EmbeddedId'");
        }
        XProperty idProperty = inferredData.getProperty();
        List<Annotation> idGeneratorAnnotations = HCANNHelper.findContainingAnnotations((XAnnotatedElement)idProperty, IdGeneratorType.class);
        List<Annotation> generatorAnnotations = HCANNHelper.findContainingAnnotations((XAnnotatedElement)idProperty, ValueGenerationType.class);
        generatorAnnotations.removeAll(idGeneratorAnnotations);
        if (idGeneratorAnnotations.size() + generatorAnnotations.size() > 1) {
            throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' has too many generator annotations " + CollectionHelper.combine(idGeneratorAnnotations, generatorAnnotations));
        }
        if (!idGeneratorAnnotations.isEmpty()) {
            idValue.setCustomIdGeneratorCreator(GeneratorBinder.identifierGeneratorCreator(idProperty, idGeneratorAnnotations.get(0)));
        } else {
            if (!generatorAnnotations.isEmpty()) {
                throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '" + generatorAnnotations.get(0).annotationType() + "' which is not an '@IdGeneratorType'");
            }
            XClass entityClass = inferredData.getClassOrElement();
            GeneratorBinder.createIdGenerator(idValue, classGenerators, context, entityClass, idProperty);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Bind {0} on {1}", BinderHelper.isCompositeId(entityClass, idProperty) ? "@EmbeddedId" : "@Id", inferredData.getPropertyName());
            }
        }
    }
}

