/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;
import org.apache.derby.shared.common.error.StandardException;

public final class LogicalUndoOperation
extends PageBasicOperation
implements Compensation {
    protected int recordId;
    private transient LogicalPageOperation undoOp = null;

    LogicalUndoOperation(BasePage basePage) {
        super(basePage);
    }

    LogicalUndoOperation(BasePage basePage, int n, LogicalPageOperation logicalPageOperation) {
        super(basePage);
        this.undoOp = logicalPageOperation;
        this.recordId = n;
    }

    public LogicalUndoOperation() {
    }

    @Override
    public int getTypeFormatId() {
        return 104;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.recordId);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.recordId = CompressedNumber.readInt(objectInput);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) {
    }

    @Override
    public void setUndoOp(Undoable undoable) {
        this.undoOp = (LogicalPageOperation)undoable;
    }

    @Override
    public final void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        long l = 0L;
        Object var6_5 = null;
        this.undoOp.undoMe(transaction, this.page, this.recordId, logInstant, limitObjectInput);
        this.releaseResource(transaction);
    }

    @Override
    public void releaseResource(Transaction transaction) {
        if (this.undoOp != null) {
            this.undoOp.releaseResource(transaction);
        }
        super.releaseResource(transaction);
    }

    @Override
    public int group() {
        return super.group() | 4 | 0x100;
    }

    @Override
    public final ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public String toString() {
        return null;
    }
}

