/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.derived;

import jakarta.persistence.metamodel.Bindable;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.descriptor.java.JavaType;

@Incubating
public class AnonymousTupleSqmPathSource<J>
implements SqmPathSource<J> {
    private final String localPathName;
    private final SqmPath<J> path;

    public AnonymousTupleSqmPathSource(String localPathName, SqmPath<J> path) {
        this.localPathName = localPathName;
        this.path = path;
    }

    @Override
    public Class<J> getBindableJavaType() {
        return this.path.getNodeJavaType().getJavaTypeClass();
    }

    @Override
    public String getPathName() {
        return this.localPathName;
    }

    @Override
    public DomainType<J> getSqmPathType() {
        return this.path.getNodeType().getSqmPathType();
    }

    public Bindable.BindableType getBindableType() {
        return this.path.getNodeType().getBindableType();
    }

    @Override
    public JavaType<J> getExpressibleJavaType() {
        return this.path.getNodeJavaType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.path.getNodeType().findSubPathSource(name);
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        NavigablePath navigablePath = intermediatePathSource == null ? lhs.getNavigablePath().append(this.getPathName()) : lhs.getNavigablePath().append(intermediatePathSource.getPathName()).append(this.getPathName());
        DomainType<?> domainType = this.path.getNodeType().getSqmPathType();
        if (domainType instanceof BasicDomainType) {
            return new SqmBasicValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
        }
        if (domainType instanceof EmbeddableDomainType) {
            return new SqmEmbeddedValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
        }
        if (domainType instanceof EntityDomainType) {
            return new SqmEntityValuedSimplePath(navigablePath, this, lhs, lhs.nodeBuilder());
        }
        throw new UnsupportedOperationException("Unsupported path source: " + domainType);
    }
}

