/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.CompositeTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.OrderedTableNameMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(CompositeDataSet.class);
    private final ITable[] _tables;

    public CompositeDataSet(IDataSet[] dataSets) throws DataSetException {
        this(dataSets, true);
    }

    public CompositeDataSet(IDataSet[] dataSets, boolean combine) throws DataSetException {
        this(dataSets, combine, false);
    }

    public CompositeDataSet(IDataSet[] dataSets, boolean combine, boolean caseSensitiveTableNames) throws DataSetException {
        super(caseSensitiveTableNames);
        OrderedTableNameMap orderedTableMap = super.createTableNameMap();
        for (int i = 0; i < dataSets.length; ++i) {
            IDataSet dataSet = dataSets[i];
            ITableIterator iterator = dataSet.iterator();
            while (iterator.next()) {
                this.addTable(iterator.getTable(), orderedTableMap, combine);
            }
        }
        this._tables = orderedTableMap.orderedValues().toArray(new ITable[0]);
    }

    public CompositeDataSet(IDataSet dataSet1, IDataSet dataSet2) throws DataSetException {
        this(new IDataSet[]{dataSet1, dataSet2});
    }

    public CompositeDataSet(IDataSet dataSet1, IDataSet dataSet2, boolean combine) throws DataSetException {
        this(new IDataSet[]{dataSet1, dataSet2}, combine);
    }

    public CompositeDataSet(IDataSet dataSet, boolean combine) throws DataSetException {
        this(new IDataSet[]{dataSet}, combine);
    }

    public CompositeDataSet(IDataSet dataSet) throws DataSetException {
        this(new IDataSet[]{dataSet}, true);
    }

    public CompositeDataSet(ITable[] tables) throws DataSetException {
        this(tables, false);
    }

    public CompositeDataSet(ITable[] tables, boolean caseSensitiveTableNames) throws DataSetException {
        super(caseSensitiveTableNames);
        OrderedTableNameMap orderedTableMap = super.createTableNameMap();
        for (int i = 0; i < tables.length; ++i) {
            this.addTable(tables[i], orderedTableMap, true);
        }
        this._tables = orderedTableMap.orderedValues().toArray(new ITable[0]);
    }

    private void addTable(ITable newTable, OrderedTableNameMap tableMap, boolean combine) throws AmbiguousTableNameException {
        if (logger.isDebugEnabled()) {
            logger.debug("addTable(newTable={}, tableList={}, combine={}) - start", new Object[]{newTable, tableMap, String.valueOf(combine)});
        }
        String tableName = newTable.getTableMetaData().getTableName();
        if (!combine) {
            tableMap.add(tableName, newTable);
            return;
        }
        ITable existingTable = (ITable)tableMap.get(tableName);
        if (existingTable != null) {
            tableMap.update(tableName, new CompositeTable(existingTable, newTable));
            return;
        }
        tableMap.add(tableName, newTable);
    }

    @Override
    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createIterator(reversed={}) - start", (Object)String.valueOf(reversed));
        }
        return new DefaultTableIterator(this._tables, reversed);
    }
}

